/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils.workspace;

import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoDeltaVisitor;
import org.eclipse.acceleo.common.internal.utils.workspace.BundleURLConverter;
import org.eclipse.acceleo.common.internal.utils.workspace.WorkspaceClassInstance;
import org.eclipse.acceleo.common.utils.CompactLinkedHashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.IDynamicExtensionRegistry;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoWorkspaceUtil {
    public static final AcceleoWorkspaceUtil INSTANCE = new AcceleoWorkspaceUtil();
    private static final int OSGI_TIMEOUT = 3000;
    private static final String UNINSTALLATION_FAILURE_KEY = "WorkspaceUtil.UninstallationFailure";
    private static final String EMPTY_PLUGIN_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><plugin/>";
    private static final String REFERENCE_URI_PREFIX = "reference:";
    final Set<IPluginModelBase> changedContributions = new CompactLinkedHashSet<IPluginModelBase>();
    final Map<IPluginModelBase, Bundle> workspaceInstalledBundles = new HashMap<IPluginModelBase, Bundle>();
    final Map<String, WorkspaceClassInstance> workspaceLoadedClasses = new HashMap<String, WorkspaceClassInstance>();
    private final IResourceChangeListener workspaceListener = new WorkspaceResourcesListener();
    private final Set<String> logOnceProjectLoad = Sets.newHashSet();

    private AcceleoWorkspaceUtil() {
    }

    public static IProject getProject(String bundleName) {
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model.getBundleDescription().getSymbolicName().equals(bundleName)) {
                return model.getUnderlyingResource().getProject();
            }
            ++n2;
        }
        return null;
    }

    public static URL getResourceURL(Class<?> clazz, String resourcePath) throws IOException {
        Bundle bundle;
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        URL resourceURL = null;
        if (packageAdmin != null && (bundle = packageAdmin.getBundle(clazz)) != null) {
            resourceURL = AcceleoWorkspaceUtil.getBundleResourceURL(bundle, "/", resourcePath);
        }
        if (resourceURL == null) {
            resourceURL = clazz.getResource(resourcePath);
        }
        if (packageAdminReference != null) {
            context.ungetService(packageAdminReference);
        }
        return resourceURL;
    }

    private static URL getBundleResourceURL(Bundle bundle, String pathSeparator, String resourcePath) throws IOException {
        Enumeration resources;
        URL resourceURL = null;
        Enumeration emtlFiles = bundle.findEntries(pathSeparator, resourcePath, true);
        if (emtlFiles != null && emtlFiles.hasMoreElements()) {
            resourceURL = (URL)emtlFiles.nextElement();
        }
        if (resourceURL == null && (resources = bundle.getResources(resourcePath)) != null && resources.hasMoreElements()) {
            resourceURL = (URL)resources.nextElement();
        }
        if (resourceURL != null) {
            resourceURL = FileLocator.resolve(resourceURL);
        }
        return resourceURL;
    }

    public static Bundle getBundle(Class<?> clazz) {
        Bundle bundle = null;
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin != null) {
            bundle = packageAdmin.getBundle(clazz);
        }
        if (packageAdminReference != null) {
            context.ungetService(packageAdminReference);
        }
        return bundle;
    }

    public static Bundle[] getBundles(String bundleName) {
        Bundle[] bundle = null;
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin != null) {
            bundle = packageAdmin.getBundles(bundleName, null);
        }
        if (packageAdminReference != null) {
            context.ungetService(packageAdminReference);
        }
        return bundle;
    }

    public static IFile getWorkspaceFile(File file) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
    }

    public static File getWorkspaceFile(String path) throws IOException {
        File soughtFile;
        if (path.startsWith("platform:/resource/")) {
            Path relativePath = new Path(path.substring("platform:/resource/".length()));
            IFile soughtIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)relativePath);
            soughtFile = soughtIFile.getLocation().toFile();
        } else if (path.startsWith("platform:/plugin/")) {
            int bundleNameEnd = path.indexOf(47, "platform:/plugin/".length() + 1);
            String bundleName = path.substring("platform:/plugin/".length(), bundleNameEnd);
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle != null) {
                URL bundleFileURL = bundle.getEntry(path.substring(bundleNameEnd));
                URL fileURL = FileLocator.toFileURL((URL)bundleFileURL);
                soughtFile = new File(fileURL.getFile());
            } else {
                soughtFile = null;
            }
        } else {
            Path fullPath;
            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            if (workspaceLocation.isPrefixOf((IPath)(fullPath = new Path(path)))) {
                fullPath = fullPath.removeFirstSegments(workspaceLocation.segmentCount());
            }
            IFile soughtIFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)fullPath);
            soughtFile = soughtIFile.getLocation().toFile();
        }
        return soughtFile;
    }

    public static String resolveAsPlatformPlugin(String filePath) {
        BundleURLConverter converter = new BundleURLConverter(filePath);
        return converter.resolveAsPlatformPlugin();
    }

    public static String resolveInBundles(String filePath) {
        BundleURLConverter converter = new BundleURLConverter(filePath);
        return converter.resolveAsNativeProtocolURL();
    }

    private static Bundle getBundle(String pluginLocation) {
        Bundle[] bundles = AcceleoCommonPlugin.getDefault().getContext().getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (pluginLocation.equals(bundles[i].getLocation())) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    private static Set<String> getOutputFolders(IProject project) {
        CompactLinkedHashSet<String> classpathEntries = new CompactLinkedHashSet<String>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath output;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && (output = entry.getOutputLocation()) != null) {
                    classpathEntries.add(output.removeFirstSegments(1).toString());
                }
                ++n2;
            }
            IPath output = javaProject.getOutputLocation();
            classpathEntries.add(output.removeFirstSegments(1).toString());
        }
        catch (JavaModelException e) {
            AcceleoCommonPlugin.log((Exception)((Object)e), false);
        }
        return classpathEntries;
    }

    private static boolean hasCorrespondingExportPackage(IPluginModelBase model, String qualifiedName) {
        String packageName = "";
        int end = qualifiedName.lastIndexOf(46);
        if (end != -1) {
            packageName = qualifiedName.substring(0, end);
        }
        ExportPackageDescription[] exportPackageDescriptionArray = model.getBundleDescription().getExportPackages();
        int n = exportPackageDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription exported = exportPackageDescriptionArray[n2];
            if (packageName.startsWith(exported.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void addWorkspaceContribution(IProject project) {
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model != null && !this.workspaceInstalledBundles.containsKey(model)) {
            this.changedContributions.add(model);
        }
    }

    public synchronized void dispose() {
        this.changedContributions.clear();
        this.workspaceLoadedClasses.clear();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.workspaceListener);
        for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
            Bundle bundle = entry.getValue();
            try {
                this.uninstallBundle(bundle);
            }
            catch (BundleException e) {
                AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString(UNINSTALLATION_FAILURE_KEY, bundle.getSymbolicName()), (Throwable)e));
            }
        }
        this.workspaceInstalledBundles.clear();
    }

    public synchronized Class<?> getClass(String qualifiedName, boolean honorOSGiVisibility) {
        if (this.changedContributions.size() > 0) {
            this.refreshContributions();
        }
        Class<?> clazz = null;
        WorkspaceClassInstance workspaceInstance = this.workspaceLoadedClasses.get(qualifiedName);
        if (workspaceInstance != null) {
            if (workspaceInstance.isStale()) {
                for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
                    IPluginModelBase model = entry.getKey();
                    if (!workspaceInstance.getBundle().equals(model.getBundleDescription().getSymbolicName())) continue;
                    clazz = this.internalLoadClass(entry.getValue(), qualifiedName);
                    workspaceInstance.setStale(false);
                    workspaceInstance.setClass(clazz);
                    break;
                }
            } else {
                clazz = workspaceInstance.getInstance().getClass();
            }
        }
        if (clazz != null) {
            return clazz;
        }
        Iterator<Map.Entry<IPluginModelBase, Bundle>> iterator = this.workspaceInstalledBundles.entrySet().iterator();
        while (clazz == null && iterator.hasNext()) {
            Map.Entry<IPluginModelBase, Bundle> entry = iterator.next();
            if (honorOSGiVisibility && !AcceleoWorkspaceUtil.hasCorrespondingExportPackage(entry.getKey(), qualifiedName)) continue;
            try {
                clazz = entry.getValue().loadClass(qualifiedName);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassLookupFailure", qualifiedName), false);
        }
        return clazz;
    }

    public synchronized Class<?> getClass(IProject project, String qualifiedName) {
        Class<?> instance = null;
        this.addWorkspaceContribution(project);
        this.refreshContributions();
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        Bundle installedBundle = this.workspaceInstalledBundles.get(model);
        if (installedBundle != null) {
            instance = this.internalLoadClass(installedBundle, qualifiedName);
        }
        return instance;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized ResourceBundle getResourceBundle(String qualifiedName) {
        originalException = null;
        try {
            bundle = ResourceBundle.getBundle(qualifiedName);
            return bundle;
        }
        catch (MissingResourceException e) {
            originalException = e;
            if (this.changedContributions.size() > 0) {
                this.refreshContributions();
            }
            ** for (entry : this.workspaceInstalledBundles.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            bundle = entry.getValue();
            propertiesResource = bundle.getResource(String.valueOf(qualifiedName.replace('.', '/')) + ".properties");
            if (propertiesResource == null) continue;
            stream = null;
            stream = propertiesResource.openStream();
            stream = new BufferedInputStream(stream);
            var9_10 = new PropertyResourceBundle(stream);
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException v0) {}
            return var9_10;
            catch (IOException v1) {
                try {}
                catch (Throwable var8_11) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException v2) {}
                    throw var8_11;
                }
                try {
                    if (stream == null) continue;
                    stream.close();
                }
                catch (IOException v3) {}
                continue;
            }
        }
lbl39:
        // 1 sources

        throw originalException;
    }

    public synchronized Object getServiceInstance(Class<?> serviceClass) {
        String qualifiedName = serviceClass.getName();
        for (Map.Entry<String, WorkspaceClassInstance> workspaceClass : this.workspaceLoadedClasses.entrySet()) {
            if (!workspaceClass.getKey().equals(qualifiedName)) continue;
            WorkspaceClassInstance workspaceInstance = workspaceClass.getValue();
            if (workspaceInstance.isStale()) {
                for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
                    IPluginModelBase model = entry.getKey();
                    if (!workspaceInstance.getBundle().equals(model.getBundleDescription().getSymbolicName())) continue;
                    Class<?> clazz = this.internalLoadClass(entry.getValue(), qualifiedName);
                    workspaceInstance.setStale(false);
                    workspaceInstance.setClass(clazz);
                    break;
                }
            }
            return workspaceInstance.getInstance();
        }
        return null;
    }

    public void initialize() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.workspaceListener, 23);
    }

    public boolean isInDynamicBundle(Class<?> clazz) {
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin != null) {
            Bundle bundle = packageAdmin.getBundle(clazz);
            if (this.workspaceInstalledBundles.values().contains(bundle)) {
                return true;
            }
        }
        if (packageAdminReference != null) {
            context.ungetService(packageAdminReference);
        }
        return false;
    }

    public synchronized void refreshContributions() {
        if (this.changedContributions.size() == 0) {
            return;
        }
        for (IPluginModelBase candidate : this.changedContributions) {
            this.installBundle(candidate);
        }
        this.changedContributions.clear();
    }

    public synchronized void reset() {
        this.changedContributions.clear();
        this.workspaceLoadedClasses.clear();
        for (Map.Entry<IPluginModelBase, Bundle> entry : this.workspaceInstalledBundles.entrySet()) {
            Bundle bundle = entry.getValue();
            try {
                if (bundle.getState() == 1) continue;
                this.uninstallBundle(bundle);
            }
            catch (BundleException e) {
                AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString(UNINSTALLATION_FAILURE_KEY, bundle.getSymbolicName()), (Throwable)e));
            }
        }
        this.workspaceInstalledBundles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void refreshPackages(Bundle[] bundles) {
        BundleContext context = AcceleoCommonPlugin.getDefault().getContext();
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminReference != null) {
            packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        }
        if (packageAdmin == null) return;
        final boolean[] flag = new boolean[1];
        FrameworkListener listener = new FrameworkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 4) return;
                boolean[] blArray = flag;
                synchronized (flag) {
                    flag[0] = true;
                    flag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        if (bundles != null && Platform.getExtensionRegistry() instanceof IDynamicExtensionRegistry) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                IContributor contributor = ContributorFactoryOSGi.createContributor((Bundle)bundle);
                if (!((IDynamicExtensionRegistry)registry).hasContributor(contributor)) {
                    registry.addContribution((InputStream)new ByteArrayInputStream(EMPTY_PLUGIN_XML.getBytes()), contributor, false, null, null, ((ExtensionRegistry)registry).getTemporaryUserToken());
                }
                ++n2;
            }
        }
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        boolean[] blArray = flag;
        synchronized (flag) {
            while (!flag[0]) {
                try {
                    flag.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            context.removeFrameworkListener(listener);
            if (packageAdminReference == null) return;
            context.ungetService(packageAdminReference);
            return;
        }
    }

    void uninstallBundle(Bundle target) throws BundleException {
        target.uninstall();
        this.refreshPackages(null);
    }

    private void checkImportPackagesDependencies(IPluginModelBase model) {
        BundleDescription desc = model.getBundleDescription();
        if (desc == null) {
            return;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = desc.getImportPackages();
        int n = importPackageSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification importPackage = importPackageSpecificationArray[n2];
            IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            int n3 = iPluginModelBaseArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPluginModelBase workspaceModel = iPluginModelBaseArray[n4];
                if (workspaceModel != null && workspaceModel.getBundleDescription() != null) {
                    ExportPackageDescription[] exportPackageDescriptionArray = workspaceModel.getBundleDescription().getExportPackages();
                    int n5 = exportPackageDescriptionArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ExportPackageDescription export = exportPackageDescriptionArray[n6];
                        if (importPackage.isSatisfiedBy((BaseDescription)export)) {
                            this.installBundle(workspaceModel);
                            break;
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void checkRequireBundleDependencies(IPluginModelBase model) {
        BundleDescription desc = model.getBundleDescription();
        if (desc == null) {
            return;
        }
        BundleSpecification[] bundleSpecificationArray = desc.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            int n3 = iPluginModelBaseArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPluginModelBase workspaceModel = iPluginModelBaseArray[n4];
                if (requiredBundle.isSatisfiedBy((BaseDescription)workspaceModel.getBundleDescription())) {
                    this.installBundle(workspaceModel);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void installBundle(IPluginModelBase model) {
        try {
            IResource candidateManifest = model.getUnderlyingResource();
            IProject project = candidateManifest.getProject();
            URL url = null;
            try {
                url = project.getLocationURI().toURL();
            }
            catch (MalformedURLException e) {
                try {
                    URI uri = project.getLocationURI();
                    IFileStore store = EFS.getStore((URI)uri);
                    File file = store.toLocalFile(0, null);
                    if (file != null) {
                        url = file.toURI().toURL();
                    }
                }
                catch (CoreException ex) {
                    AcceleoCommonPlugin.log(e, false);
                    AcceleoCommonPlugin.log((Exception)((Object)ex), false);
                }
            }
            if (url != null) {
                String candidateLocationReference = REFERENCE_URI_PREFIX + URLDecoder.decode(url.toExternalForm(), System.getProperty("file.encoding"));
                Bundle bundle = AcceleoWorkspaceUtil.getBundle(candidateLocationReference);
                if (bundle == null) {
                    this.checkRequireBundleDependencies(model);
                    bundle = this.installBundle(candidateLocationReference);
                    this.setBundleClasspath(project, bundle);
                    this.workspaceInstalledBundles.put(model, bundle);
                    this.checkImportPackagesDependencies(model);
                }
                this.refreshPackages(new Bundle[]{bundle});
            }
        }
        catch (BundleException e) {
            String bundleName = model.getBundleDescription().getName();
            if (!this.logOnceProjectLoad.contains(bundleName)) {
                this.logOnceProjectLoad.add(bundleName);
                AcceleoCommonPlugin.log((IStatus)new Status(2, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString("WorkspaceUtil.InstallationFailure", bundleName, e.getMessage()), (Throwable)e));
            }
        }
        catch (MalformedURLException e) {
            AcceleoCommonPlugin.log(e, false);
        }
        catch (UnsupportedEncodingException e) {
            AcceleoCommonPlugin.log(e, false);
        }
    }

    private Bundle installBundle(String pluginLocation) throws BundleException, IllegalStateException {
        Bundle target = AcceleoCommonPlugin.getDefault().getContext().installBundle(pluginLocation);
        int state = target.getState();
        if (state != 2) {
            throw new IllegalStateException(AcceleoCommonMessages.getString("WorkspaceUtil.IllegalBundleState", target, state));
        }
        return target;
    }

    private Class<?> internalLoadClass(Bundle bundle, String qualifiedName) {
        try {
            Class clazz;
            WorkspaceClassInstance workspaceInstance = this.workspaceLoadedClasses.get(qualifiedName);
            if (workspaceInstance == null) {
                clazz = bundle.loadClass(qualifiedName);
                this.workspaceLoadedClasses.put(qualifiedName, new WorkspaceClassInstance(clazz, bundle.getSymbolicName()));
            } else if (workspaceInstance.isStale()) {
                clazz = bundle.loadClass(qualifiedName);
                workspaceInstance.setStale(false);
                workspaceInstance.setClass(clazz);
            } else {
                clazz = workspaceInstance.getClassInstance();
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            e.fillInStackTrace();
            AcceleoCommonPlugin.log(AcceleoCommonMessages.getString("BundleClassLookupFailure", qualifiedName, bundle.getSymbolicName()), e, false);
            return null;
        }
    }

    private void setBundleClasspath(IProject plugin, Bundle bundle) {
        Set<String> classpathEntries = AcceleoWorkspaceUtil.getOutputFolders(plugin);
        if (classpathEntries.size() > 0) {
            BaseData bundleData = (BaseData)((AbstractBundle)bundle).getBundleData();
            StringBuilder classpath = new StringBuilder();
            classpath.append(bundleData.getClassPathString()).append(',');
            Iterator<String> entryIterator = classpathEntries.iterator();
            while (entryIterator.hasNext()) {
                classpath.append(entryIterator.next());
                if (!entryIterator.hasNext()) continue;
                classpath.append(',');
            }
            bundleData.setClassPathString(classpath.toString());
        }
    }

    class WorkspaceResourcesListener
    implements IResourceChangeListener {
        WorkspaceResourcesListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 2: 
                case 4: {
                    IProject project;
                    IPluginModelBase model;
                    if (!(event.getResource() instanceof IProject) || (model = PluginRegistry.findModel((IProject)(project = (IProject)event.getResource()))) == null) break;
                    Bundle bundle = AcceleoWorkspaceUtil.this.workspaceInstalledBundles.remove(model);
                    AcceleoWorkspaceUtil.this.changedContributions.remove(model);
                    if (bundle == null) break;
                    try {
                        AcceleoWorkspaceUtil.this.uninstallBundle(bundle);
                    }
                    catch (BundleException e) {
                        AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString(AcceleoWorkspaceUtil.UNINSTALLATION_FAILURE_KEY, bundle.getSymbolicName()), (Throwable)e));
                    }
                    break;
                }
                case 16: {
                    this.processBuildEvent(event);
                }
            }
        }

        private void processBuildEvent(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            switch (event.getBuildKind()) {
                case 9: {
                    if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) break;
                }
                case 10: {
                    AcceleoDeltaVisitor visitor = new AcceleoDeltaVisitor();
                    try {
                        delta.accept((IResourceDeltaVisitor)visitor);
                    }
                    catch (CoreException e) {
                        AcceleoCommonPlugin.log((Exception)((Object)e), false);
                    }
                    for (IProject changed : visitor.getChangedProjects()) {
                        IPluginModelBase model = PluginRegistry.findModel((IProject)changed);
                        if (model == null || !AcceleoWorkspaceUtil.this.workspaceInstalledBundles.keySet().contains(model)) continue;
                        AcceleoWorkspaceUtil.this.changedContributions.add(model);
                    }
                    for (String changedClass : visitor.getChangedClasses()) {
                        WorkspaceClassInstance workspaceInstance = AcceleoWorkspaceUtil.this.workspaceLoadedClasses.get(changedClass);
                        if (workspaceInstance == null) continue;
                        workspaceInstance.setStale(true);
                    }
                    break;
                }
                case 6: {
                    for (Map.Entry<IPluginModelBase, Bundle> entry : AcceleoWorkspaceUtil.this.workspaceInstalledBundles.entrySet()) {
                        IPluginModelBase model = entry.getKey();
                        if (model == null) continue;
                        AcceleoWorkspaceUtil.this.changedContributions.add(model);
                    }
                    for (WorkspaceClassInstance workspaceInstance : AcceleoWorkspaceUtil.this.workspaceLoadedClasses.values()) {
                        workspaceInstance.setStale(true);
                    }
                    break;
                }
                case 15: {
                    Iterator<Map.Entry<IPluginModelBase, Bundle>> workspaceBundleIterator = AcceleoWorkspaceUtil.this.workspaceInstalledBundles.entrySet().iterator();
                    while (workspaceBundleIterator.hasNext()) {
                        Map.Entry<IPluginModelBase, Bundle> entry = workspaceBundleIterator.next();
                        Bundle bundle = entry.getValue();
                        try {
                            AcceleoWorkspaceUtil.this.uninstallBundle(bundle);
                        }
                        catch (BundleException e) {
                            AcceleoCommonPlugin.log((IStatus)new Status(4, "org.eclipse.acceleo.common", AcceleoCommonMessages.getString(AcceleoWorkspaceUtil.UNINSTALLATION_FAILURE_KEY, bundle.getSymbolicName()), (Throwable)e));
                        }
                        workspaceBundleIterator.remove();
                    }
                    for (WorkspaceClassInstance workspaceInstance : AcceleoWorkspaceUtil.this.workspaceLoadedClasses.values()) {
                        workspaceInstance.setStale(true);
                    }
                    break;
                }
            }
        }
    }
}

