/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.acceleo.ui.interpreter.internal.InterpreterImages;
import org.eclipse.acceleo.ui.interpreter.internal.InterpreterMessages;
import org.eclipse.acceleo.ui.interpreter.internal.SWTUtil;
import org.eclipse.acceleo.ui.interpreter.internal.compatibility.view.FormMessageManagerFactory;
import org.eclipse.acceleo.ui.interpreter.internal.compatibility.view.IFormMessageManager;
import org.eclipse.acceleo.ui.interpreter.internal.language.DefaultLanguageInterpreter;
import org.eclipse.acceleo.ui.interpreter.internal.language.LanguageInterpreterDescriptor;
import org.eclipse.acceleo.ui.interpreter.internal.language.LanguageInterpreterRegistry;
import org.eclipse.acceleo.ui.interpreter.internal.optional.InterpreterDependencyChecks;
import org.eclipse.acceleo.ui.interpreter.internal.optional.debug.DebugViewHelper;
import org.eclipse.acceleo.ui.interpreter.internal.view.GeneratedTextDialog;
import org.eclipse.acceleo.ui.interpreter.internal.view.InterpreterFileStorage;
import org.eclipse.acceleo.ui.interpreter.internal.view.ResultDragListener;
import org.eclipse.acceleo.ui.interpreter.internal.view.StorageEditorInput;
import org.eclipse.acceleo.ui.interpreter.internal.view.VariableContentProvider;
import org.eclipse.acceleo.ui.interpreter.internal.view.VariableDropListener;
import org.eclipse.acceleo.ui.interpreter.internal.view.VariableLabelProvider;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.ClearExpressionViewerAction;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.ClearResultViewerAction;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.ClearVariableViewerAction;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.DeleteVariableOrValueAction;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.EvaluateAction;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.LinkWithEditorContextAction;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.NewVariableAction;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.NewVariableWizardAction;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.RenameVariableAction;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.ToggleRealTimeAction;
import org.eclipse.acceleo.ui.interpreter.internal.view.actions.ToggleVariableVisibilityAction;
import org.eclipse.acceleo.ui.interpreter.language.AbstractLanguageInterpreter;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationContext;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.acceleo.ui.interpreter.language.IInterpreterSourceViewer;
import org.eclipse.acceleo.ui.interpreter.language.InterpreterContext;
import org.eclipse.acceleo.ui.interpreter.view.InterpreterFile;
import org.eclipse.acceleo.ui.interpreter.view.ResultContentProvider;
import org.eclipse.acceleo.ui.interpreter.view.ResultLabelProvider;
import org.eclipse.acceleo.ui.interpreter.view.Variable;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class InterpreterView
extends ViewPart {
    protected static final String COMPILATION_MESSAGE_PREFIX = "compilation.message";
    protected static final String EVALUATION_MESSAGE_PREFIX = "evaluation.message";
    private static final String COMPILATION_INFO_MESSAGE_KEY = "interpreter.evaluation.info.message";
    private static final String EVALUATION_INFO_MESSAGE_KEY = "interpreter.evaluation.info.message";
    private static final String INTERPRETER_VIEW_CONTEXT_ID = "org.eclipse.acceleo.ui.interpreter.interpreterview";
    private static final String LANGUAGE_SPECIFIC_ACTION_GROUP = "LanguageSpecificActions";
    private static final String MEMENTO_CURRENT_LANGUAGE_KEY = "org.eclipse.acceleo.ui.interpreter.memento.current.language";
    private static final String MEMENTO_EXPRESSION_KEY = "org.eclipse.acceleo.ui.interpreter.memento.expression";
    private static final String MEMENTO_REAL_TIME_KEY = "org.eclipse.acceleo.ui.interpreter.memento.realtime";
    private static final String MEMENTO_VARIABLES_VISIBLE_KEY = "org.eclipse.acceleo.ui.interpreter.memento.variables.hide";
    private static final String MENU_ID = "#PopupMenu";
    private static final String WORKBENCH_CONSTANT_EDIT_REDO = "org.eclipse.ui.edit.redo";
    private static final String WORKBENCH_CONSTANT_EDIT_UNDO = "org.eclipse.ui.edit.undo";
    protected CompilationResult compilationResult;
    protected CompilationThread compilationThread;
    protected LinkWithEditorContextAction linkWithEditorContextAction;
    ExecutorService evaluationPool = Executors.newSingleThreadExecutor();
    RealTimeThread realTimeThread;
    private IHandlerActivation activationTokenContentAssist;
    private IHandlerActivation activationTokenRedo;
    private IHandlerActivation activationTokenUndo;
    private ExecutorService compilationPool = Executors.newSingleThreadExecutor();
    private IContextActivation contextActivationToken;
    private LanguageInterpreterDescriptor currentLanguage;
    private AbstractLanguageInterpreter currentLanguageInterpreter;
    private IPartListener2 editorPartListener = new InterpreterEditorPartListener();
    private ISelectionListener eobjectSelectionListener;
    private EvaluationThread evaluationThread;
    private Section expressionSection;
    private SourceViewer expressionViewer;
    private SashForm formBody;
    private FormToolkit formToolkit;
    private Form interpreterForm;
    private int messageCount;
    private IFormMessageManager messageManager;
    private IMemento partMemento;
    private boolean realTime;
    private Section resultSection;
    private Viewer resultViewer;
    private List<EObject> selectedEObjects;
    private Composite variableColumn;
    private TreeViewer variableViewer;
    private boolean variableVisible;

    protected static final ToolBarManager createSectionToolBar(Section section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        final ToolBar toolBar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(handCursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        section.setTextClient((Control)toolBar);
        toolBar.setData((Object)toolBarManager);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolBar.setData(null);
            }
        });
        return toolBarManager;
    }

    protected static final ToolBarManager getSectionToolBar(Section section) {
        ToolBar toolBar;
        Object data;
        Control textClient = section.getTextClient();
        if (textClient instanceof ToolBar && (data = (toolBar = (ToolBar)textClient).getData()) instanceof ToolBarManager) {
            return (ToolBarManager)data;
        }
        return null;
    }

    public void addVariables(Object variableValue) {
        NewVariableAction action = new NewVariableAction(this.variableViewer, variableValue);
        action.run();
    }

    public void compileExpression() {
        if (this.expressionViewer == null || this.expressionViewer.getTextWidget() == null || this.expressionViewer.getTextWidget().isDisposed()) {
            return;
        }
        InterpreterContext context = this.getInterpreterContext();
        Callable<CompilationResult> compilationTask = this.getCurrentLanguageInterpreter().getCompilationTask(context);
        if (this.compilationThread != null && !this.compilationThread.isInterrupted()) {
            this.compilationThread.interrupt();
        }
        if (this.evaluationThread != null && !this.evaluationThread.isInterrupted()) {
            this.evaluationThread.interrupt();
        }
        this.clearCompilationMessages();
        if (compilationTask != null) {
            Future<CompilationResult> compilationFuture = this.compilationPool.submit(compilationTask);
            this.compilationThread = new CompilationThread(compilationFuture);
            this.compilationThread.start();
        }
    }

    public void createPartControl(Composite parent) {
        SashForm rootContainer = new SashForm(parent, 256);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        rootContainer.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 1;
        rootContainer.setLayoutData((Object)gridData);
        this.formToolkit = new FormToolkit(rootContainer.getDisplay());
        this.createInterpreterForm(this.formToolkit, (Composite)rootContainer);
        this.partMemento = null;
    }

    public void dispose() {
        IWorkbenchWindow workbenchWindow;
        if (this.compilationThread != null && !this.compilationThread.isInterrupted()) {
            this.compilationThread.interrupt();
        }
        if (this.evaluationThread != null && !this.evaluationThread.isInterrupted()) {
            this.evaluationThread.interrupt();
        }
        if (this.contextActivationToken != null) {
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            contextService.deactivateContext(this.contextActivationToken);
        }
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (this.activationTokenContentAssist != null) {
            handlerService.deactivateHandler(this.activationTokenContentAssist);
        }
        if (this.activationTokenRedo != null) {
            handlerService.deactivateHandler(this.activationTokenRedo);
        }
        if (this.activationTokenUndo != null) {
            handlerService.deactivateHandler(this.activationTokenUndo);
        }
        if ((workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && workbenchWindow.getActivePage() != null && this.eobjectSelectionListener != null) {
            workbenchWindow.getActivePage().removeSelectionListener(this.eobjectSelectionListener);
        }
        this.clearSelection();
        IWorkbenchPage currentPage = this.getSite().getPage();
        if (currentPage != null) {
            currentPage.removePartListener(this.editorPartListener);
        }
        super.dispose();
    }

    public void evaluate() {
        if (this.evaluationThread != null && !this.evaluationThread.isInterrupted()) {
            this.evaluationThread.interrupt();
        }
        this.clearEvaluationMessages();
        this.evaluationThread = new EvaluationThread(this.getInterpreterContext());
        this.evaluationThread.start();
    }

    public final AbstractLanguageInterpreter getCurrentLanguageInterpreter() {
        if (this.currentLanguageInterpreter == null) {
            this.currentLanguageInterpreter = this.getCurrentLanguageDescriptor() != null ? this.getCurrentLanguageDescriptor().createLanguageInterpreter() : new DefaultLanguageInterpreter();
        }
        return this.currentLanguageInterpreter;
    }

    public InterpreterContext getInterpreterContext() {
        Object variableViewerInput;
        String fullExpression = this.expressionViewer.getTextWidget().getText();
        List<Object> targetEObjects = this.selectedEObjects;
        if (targetEObjects == null) {
            targetEObjects = Collections.emptyList();
        }
        List<Variable> variables = (variableViewerInput = this.variableViewer.getInput()) instanceof List ? new ArrayList((List)variableViewerInput) : Collections.emptyList();
        ISelection selection = this.expressionViewer.getSelection();
        if (selection == null || selection instanceof ITextSelection && ((ITextSelection)selection).getLength() == 0) {
            selection = new TextSelection(this.expressionViewer.getDocument(), 0, fullExpression.length());
        }
        if (InterpreterDependencyChecks.isDebugAccessible()) {
            List<Variable> debugVariables = DebugViewHelper.getCurrentDebugThreadVariables();
            for (Variable var : debugVariables) {
                boolean duplicate = false;
                int i = 0;
                while (i < variables.size() && !duplicate) {
                    duplicate = variables.get(i).getName().equals(var.getName());
                    ++i;
                }
                if (duplicate) continue;
                variables.addAll(debugVariables);
            }
        }
        return new InterpreterContext(fullExpression, selection, targetEObjects, variables);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.partMemento = memento;
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        this.contextActivationToken = contextService.activateContext(INTERPRETER_VIEW_CONTEXT_ID);
        this.eobjectSelectionListener = new EObjectSelectionListener();
        site.getPage().addSelectionListener(this.eobjectSelectionListener);
    }

    public boolean isVariableVisible() {
        return this.variableVisible;
    }

    public void linkWithEditorContext() {
        IWorkbenchPage page = this.getSite().getPage();
        if (!this.linkWithEditorContextAction.isEnabled() || page == null || page.getActiveEditor() == null) {
            return;
        }
        IEditorPart activeEditor = page.getActiveEditor();
        if (this.linkWithEditorContextAction.isChecked()) {
            this.getCurrentLanguageInterpreter().linkWithEditor(activeEditor);
            this.linkWithEditorContextAction.changeTooltip(activeEditor);
        } else {
            this.getCurrentLanguageInterpreter().linkWithEditor(null);
            this.linkWithEditorContextAction.changeTooltip(null);
            if (activeEditor == null) {
                this.linkWithEditorContextAction.setEnabled(false);
            } else {
                this.linkWithEditorContextAction.setEnabled(this.getCurrentLanguageInterpreter().canLinkWithEditor(activeEditor));
            }
        }
    }

    public void saveState(IMemento memento) {
        if (this.partMemento != null) {
            memento.putMemento(this.partMemento);
        } else {
            if (this.getCurrentLanguageDescriptor() != null) {
                memento.putString(MEMENTO_CURRENT_LANGUAGE_KEY, this.getCurrentLanguageDescriptor().getClassName());
            }
            memento.putString(MEMENTO_EXPRESSION_KEY, this.expressionViewer.getTextWidget().getText());
            memento.putBoolean(MEMENTO_REAL_TIME_KEY, Boolean.valueOf(this.realTime).booleanValue());
            memento.putBoolean(MEMENTO_VARIABLES_VISIBLE_KEY, Boolean.valueOf(this.variableViewer.getControl().isVisible()).booleanValue());
        }
    }

    public void setFocus() {
        if (this.expressionViewer != null) {
            this.expressionViewer.getControl().setFocus();
        }
    }

    public synchronized void toggleRealTime() {
        boolean bl = this.realTime = !this.realTime;
        if (this.realTime) {
            this.realTimeThread = new RealTimeThread();
            String text = this.expressionViewer.getTextWidget().getText();
            if (text != null && text.length() > 0) {
                this.compileExpression();
                this.evaluate();
            }
            this.realTimeThread.start();
        } else if (this.realTimeThread != null) {
            this.realTimeThread.interrupt();
            this.realTimeThread = null;
        }
    }

    public void toggleVariableVisibility() {
        if (this.variableColumn != null && !this.variableColumn.isDisposed()) {
            int[] newWeights;
            this.variableVisible = !this.variableVisible;
            this.variableColumn.setVisible(this.variableVisible);
            if (this.variableVisible) {
                newWeights = new int[]{3, 1};
            } else {
                int[] nArray = new int[2];
                nArray[0] = 1;
                newWeights = nArray;
            }
            this.formBody.setWeights(newWeights);
            this.getForm().layout();
        }
    }

    protected final void addMessage(String messageKey, String message, int messageType) {
        Section targetControl = null;
        if (messageType != 0 && messageKey.startsWith(COMPILATION_MESSAGE_PREFIX)) {
            targetControl = this.expressionSection;
        } else if (messageType != 0 && messageKey.startsWith(EVALUATION_MESSAGE_PREFIX)) {
            targetControl = this.resultSection;
        }
        if (!this.getForm().isDisposed()) {
            if (targetControl != null) {
                this.getMessageManager().addMessage(messageKey, message, messageType, (Control)targetControl);
            } else {
                this.getMessageManager().addMessage(messageKey, message, messageType);
            }
        }
    }

    protected final void addStatusMessages(IStatus status, String keyPrefix) {
        if (status instanceof MultiStatus) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.addStatusMessages(child, keyPrefix);
                ++n2;
            }
        } else {
            String messageKey = status.getSeverity() == 0 ? (keyPrefix.equals(COMPILATION_MESSAGE_PREFIX) ? "interpreter.evaluation.info.message" : "interpreter.evaluation.info.message") : String.valueOf(keyPrefix) + "." + this.messageCount++;
            this.addMessage(messageKey, status.getMessage(), this.convertStatusToMessageSeverity(status.getSeverity()));
        }
    }

    protected void addToSelection(EObject object) {
        if (this.selectedEObjects == null) {
            this.selectedEObjects = new ArrayList<EObject>(1);
        }
        this.selectedEObjects.add(object);
    }

    protected void clearCompilationMessages() {
        this.getMessageManager().addMessage("none", "", 3);
        this.getMessageManager().removeMessage(COMPILATION_MESSAGE_PREFIX);
        this.getMessageManager().removeMessages((Control)this.expressionSection);
        this.getMessageManager().addMessage("none", "", 0);
        this.getMessageManager().removeMessage("none");
    }

    protected void clearEvaluationMessages() {
        this.getMessageManager().addMessage("none", "", 3);
        this.getMessageManager().removeMessage("interpreter.evaluation.info.message");
        this.getMessageManager().removeMessages((Control)this.resultSection);
        this.getMessageManager().addMessage("none", "", 0);
        this.getMessageManager().removeMessage("none");
    }

    protected void clearSelection() {
        if (this.selectedEObjects != null) {
            this.selectedEObjects.clear();
            this.selectedEObjects = null;
        }
    }

    protected AdapterFactory createAdapterFactory() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return adapterFactory;
    }

    protected IMenuListener createExpressionMenuListener(SourceViewer viewer) {
        return new ExpressionMenuListener(viewer);
    }

    protected void createExpressionSection(FormToolkit toolkit, Composite leftColumn) {
        this.expressionSection = toolkit.createSection(leftColumn, 256);
        this.expressionSection.setText(InterpreterMessages.getString("interpreter.view.expression.section.name"));
        Composite expressionSectionBody = toolkit.createComposite((Composite)this.expressionSection);
        GridLayout expressionSectionLayout = new GridLayout();
        expressionSectionBody.setLayout((Layout)expressionSectionLayout);
        this.expressionViewer = this.createExpressionViewer(expressionSectionBody);
        GridData gridData = new GridData(1808);
        this.expressionViewer.getControl().setLayoutData((Object)gridData);
        InterpreterView.createSectionToolBar(this.expressionSection);
        this.populateExpressionSectionToolbar(this.expressionSection);
        toolkit.paintBordersFor(expressionSectionBody);
        this.expressionSection.setClient((Control)expressionSectionBody);
    }

    protected SourceViewer createExpressionViewer(Composite parent) {
        String expression;
        SourceViewer viewer = this.getCurrentLanguageInterpreter().createSourceViewer(parent);
        if (viewer == null) {
            viewer = SWTUtil.createScrollableSourceViewer(parent, 2816);
            viewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration());
            viewer.setDocument((IDocument)new Document());
        }
        this.getCurrentLanguageInterpreter().configureSourceViewer(viewer);
        if (viewer instanceof IInterpreterSourceViewer) {
            this.setUpContentAssist((IInterpreterSourceViewer)viewer);
        }
        this.setUpRealTimeCompilation(viewer);
        this.setUpDefaultTextAction(viewer);
        this.createExpressionMenu(viewer);
        if (this.partMemento != null && (expression = this.partMemento.getString(MEMENTO_EXPRESSION_KEY)) != null) {
            viewer.getTextWidget().setText(expression);
        }
        return viewer;
    }

    protected void createInterpreterForm(FormToolkit toolkit, Composite parent) {
        this.interpreterForm = toolkit.createForm(parent);
        this.messageManager = FormMessageManagerFactory.createFormMessageManager(this.interpreterForm);
        this.getMessageManager().setDecorationPosition(16512);
        toolkit.decorateFormHeading(this.getForm());
        this.populateLanguageMenu(this.getForm().getMenuManager());
        String languageName = "";
        ImageDescriptor titleImageDescriptor = null;
        if (this.getCurrentLanguageDescriptor() != null) {
            languageName = this.getCurrentLanguageDescriptor().getLabel();
            titleImageDescriptor = this.getCurrentLanguageDescriptor().getIcon();
        }
        this.getForm().setText(InterpreterMessages.getString("interpreter.view.title", languageName));
        Image titleImage = titleImageDescriptor != null ? titleImageDescriptor.createImage() : InterpreterImages.getImageDescriptor("view_icon.gif").createImage();
        this.setTitleImage(titleImage);
        this.getForm().setImage(titleImage);
        Composite mainBody = this.getForm().getBody();
        mainBody.setLayout((Layout)new GridLayout());
        this.formBody = new SashForm(mainBody, 65792);
        toolkit.adapt((Composite)this.formBody);
        this.formBody.setLayoutData((Object)new GridData(1808));
        SashForm leftColumn = new SashForm((Composite)this.formBody, 66048);
        toolkit.adapt((Composite)leftColumn);
        this.createExpressionSection(toolkit, (Composite)leftColumn);
        this.createResultSection(toolkit, (Composite)leftColumn);
        leftColumn.setWeights(new int[]{2, 3});
        this.variableColumn = toolkit.createComposite((Composite)this.formBody);
        this.variableColumn.setLayout((Layout)new FillLayout());
        this.variableColumn.setVisible(false);
        this.createVariableSection(toolkit, this.variableColumn);
        this.formBody.setWeights(new int[]{3, 1});
        this.createToolBar(this.getForm());
    }

    protected IMenuListener createResultMenuListener(Viewer viewer) {
        return new ResultMenuListener(viewer);
    }

    protected void createResultSection(FormToolkit toolkit, Composite leftColumn) {
        this.resultSection = toolkit.createSection(leftColumn, 256);
        this.resultSection.setText(InterpreterMessages.getString("interpreter.view.result.section.name"));
        Composite resultSectionBody = toolkit.createComposite((Composite)this.resultSection);
        GridLayout resultLayout = new GridLayout();
        resultSectionBody.setLayout((Layout)resultLayout);
        this.resultViewer = this.createResultViewer(resultSectionBody);
        GridData gridData = new GridData(1808);
        this.resultViewer.getControl().setLayoutData((Object)gridData);
        InterpreterView.createSectionToolBar(this.resultSection);
        this.populateResultSectionToolbar(this.resultSection);
        toolkit.paintBordersFor(resultSectionBody);
        this.resultSection.setClient((Control)resultSectionBody);
    }

    protected Viewer createResultViewer(Composite parent) {
        Viewer viewer = this.getCurrentLanguageInterpreter().createResultViewer(parent);
        if (viewer == null) {
            viewer = new TreeViewer(parent, 2818);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)((TreeViewer)viewer));
            AdapterFactory adapterFactory = this.createAdapterFactory();
            TreeViewer treeViewer = (TreeViewer)viewer;
            treeViewer.setContentProvider((IContentProvider)new ResultContentProvider(adapterFactory));
            treeViewer.setLabelProvider((IBaseLabelProvider)new ResultLabelProvider(adapterFactory));
        }
        if (viewer instanceof TreeViewer) {
            this.setUpResultDragSupport((TreeViewer)viewer);
            ((TreeViewer)viewer).addDoubleClickListener((IDoubleClickListener)new ResultDoubleClickListener());
        }
        this.createResultMenu(viewer);
        return viewer;
    }

    protected void createToolBar(Form form) {
        Boolean isVariableVisible;
        ToggleRealTimeAction realTimeAction = new ToggleRealTimeAction(this);
        if (this.partMemento != null) {
            Boolean isRealTime = this.partMemento.getBoolean(MEMENTO_REAL_TIME_KEY);
            if (isRealTime != null && isRealTime.booleanValue()) {
                this.toggleRealTime();
                realTimeAction.setChecked(this.realTime);
            }
        } else {
            this.toggleRealTime();
            realTimeAction.setChecked(this.realTime);
        }
        this.linkWithEditorContextAction = new LinkWithEditorContextAction(this);
        IWorkbenchPage currentPage = this.getSite().getPage();
        if (currentPage != null) {
            this.editorPartListener = new InterpreterEditorPartListener();
            this.getSite().getPage().addPartListener(this.editorPartListener);
            IEditorPart currentEditor = currentPage.getActiveEditor();
            if (currentEditor == null) {
                this.linkWithEditorContextAction.setEnabled(false);
            } else {
                this.linkWithEditorContextAction.setEnabled(this.getCurrentLanguageInterpreter().canLinkWithEditor(currentEditor));
            }
        } else {
            this.linkWithEditorContextAction.setEnabled(false);
        }
        ToggleVariableVisibilityAction variableVisibilityAction = new ToggleVariableVisibilityAction(this);
        if (this.partMemento != null && (isVariableVisible = this.partMemento.getBoolean(MEMENTO_VARIABLES_VISIBLE_KEY)) != null && isVariableVisible.booleanValue()) {
            this.toggleVariableVisibility();
            variableVisibilityAction.setChecked(this.variableVisible);
        }
        IToolBarManager toolBarManager = form.getToolBarManager();
        toolBarManager.add((IAction)this.linkWithEditorContextAction);
        toolBarManager.add((IAction)realTimeAction);
        toolBarManager.add((IAction)variableVisibilityAction);
        toolBarManager.add((IContributionItem)new Separator(LANGUAGE_SPECIFIC_ACTION_GROUP));
        this.getCurrentLanguageInterpreter().addToolBarActions(this, toolBarManager);
        toolBarManager.update(true);
    }

    protected IMenuListener createVariableMenuListener(TreeViewer viewer) {
        return new VariableMenuListener(viewer);
    }

    protected void createVariableSection(FormToolkit toolkit, Composite rightColumn) {
        Section variableSection = toolkit.createSection(rightColumn, 256);
        variableSection.setText(InterpreterMessages.getString("interpreter.view.variable.section.name"));
        Composite variableSectionBody = toolkit.createComposite((Composite)variableSection);
        variableSectionBody.setLayout((Layout)new FillLayout());
        this.variableViewer = this.createVariableViewer(toolkit, variableSectionBody);
        ToolBarManager toolBarManager = InterpreterView.createSectionToolBar(variableSection);
        toolBarManager.add((IAction)new ClearVariableViewerAction((Viewer)this.variableViewer));
        toolBarManager.update(true);
        toolkit.paintBordersFor(variableSectionBody);
        variableSection.setClient((Control)variableSectionBody);
    }

    protected TreeViewer createVariableViewer(FormToolkit toolkit, Composite sectionBody) {
        Tree variableTree = toolkit.createTree(sectionBody, 770);
        TreeViewer viewer = new TreeViewer(variableTree);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        AdapterFactory adapterFactory = this.createAdapterFactory();
        viewer.setContentProvider((IContentProvider)new VariableContentProvider(adapterFactory));
        viewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider(adapterFactory));
        this.setUpVariableDropSupport(viewer);
        this.createVariableMenu(viewer);
        this.setUpVariableActions(viewer);
        viewer.setInput(new ArrayList());
        return viewer;
    }

    protected Form getForm() {
        return this.interpreterForm;
    }

    protected IFormMessageManager getMessageManager() {
        return this.messageManager;
    }

    protected SourceViewer getSourceViewer() {
        return this.expressionViewer;
    }

    protected void populateExpressionSectionToolbar(Section section) {
        ToolBarManager toolBarManager = InterpreterView.getSectionToolBar(section);
        if (toolBarManager != null) {
            toolBarManager.removeAll();
            toolBarManager.add((IAction)new EvaluateAction(this));
            toolBarManager.add((IAction)new ClearExpressionViewerAction((Viewer)this.getSourceViewer()));
            toolBarManager.update(true);
        }
    }

    protected final void populateLanguageMenu(IMenuManager menuManager) {
        for (LanguageInterpreterDescriptor descriptor : LanguageInterpreterRegistry.getRegisteredInterpreters()) {
            ChangeLanguageAction action = new ChangeLanguageAction(descriptor);
            menuManager.add((IAction)action);
            if (this.getCurrentLanguageDescriptor() != null) continue;
            if (this.partMemento == null || this.partMemento.getString(MEMENTO_CURRENT_LANGUAGE_KEY) == null) {
                this.currentLanguage = descriptor;
                action.setChecked(true);
                continue;
            }
            if (!this.partMemento.getString(MEMENTO_CURRENT_LANGUAGE_KEY).equals(descriptor.getClassName())) continue;
            this.currentLanguage = descriptor;
            action.setChecked(true);
        }
    }

    protected void populateResultSectionToolbar(Section section) {
        ToolBarManager toolBarManager = InterpreterView.getSectionToolBar(section);
        if (toolBarManager != null) {
            toolBarManager.removeAll();
            toolBarManager.add((IAction)new ClearResultViewerAction(this.resultViewer));
            toolBarManager.update(true);
        }
    }

    protected void selectLanguage(LanguageInterpreterDescriptor selectedLanguage) {
        GridData gridData;
        if (this.currentLanguage == selectedLanguage) {
            return;
        }
        if (this.compilationThread != null && !this.compilationThread.isInterrupted()) {
            this.compilationThread.interrupt();
        }
        if (this.evaluationThread != null && !this.evaluationThread.isInterrupted()) {
            this.evaluationThread.interrupt();
        }
        IContributionItem[] changeLanguageActions = this.getForm().getMenuManager().getItems();
        this.getMessageManager().removeAllMessages();
        IToolBarManager toolBarManager = this.getForm().getToolBarManager();
        IContributionItem[] items = toolBarManager.getItems();
        boolean dispose = false;
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (dispose) {
                toolBarManager.remove(item);
                item.dispose();
            } else if (item instanceof Separator && LANGUAGE_SPECIFIC_ACTION_GROUP.equals(((Separator)item).getGroupName())) {
                dispose = true;
            }
            ++i;
        }
        this.getCurrentLanguageInterpreter().dispose();
        this.currentLanguageInterpreter = null;
        LanguageInterpreterDescriptor previousLanguage = this.getCurrentLanguageDescriptor();
        this.currentLanguage = selectedLanguage;
        this.getForm().setText(InterpreterMessages.getString("interpreter.view.title", this.getCurrentLanguageDescriptor().getLabel()));
        Image previousImage = null;
        if (previousLanguage != null && previousLanguage.getIcon() != null || this.getCurrentLanguageDescriptor().getIcon() != null) {
            previousImage = this.getTitleImage();
        }
        if (this.getCurrentLanguageDescriptor().getIcon() != null) {
            this.setTitleImage(this.getCurrentLanguageDescriptor().getIcon().createImage());
        } else if (previousLanguage != null && previousLanguage.getIcon() != null) {
            this.setTitleImage(InterpreterImages.getImageDescriptor("view_icon.gif").createImage());
        }
        if (previousImage != null) {
            previousImage.dispose();
        }
        this.getForm().setImage(this.getTitleImage());
        if (this.expressionSection != null) {
            Composite expressionSectionBody = (Composite)this.expressionSection.getClient();
            this.expressionViewer.getControl().dispose();
            this.expressionViewer = this.createExpressionViewer(expressionSectionBody);
            gridData = new GridData(1808);
            gridData.heightHint = 80;
            this.expressionViewer.getControl().setLayoutData((Object)gridData);
            this.formToolkit.paintBordersFor(expressionSectionBody);
            expressionSectionBody.layout();
        }
        if (this.resultSection != null) {
            Composite resultSectionBody = (Composite)this.resultSection.getClient();
            this.resultViewer.getControl().dispose();
            this.resultViewer = this.createResultViewer(resultSectionBody);
            gridData = new GridData(1808);
            this.resultViewer.getControl().setLayoutData((Object)gridData);
            this.formToolkit.paintBordersFor(resultSectionBody);
            resultSectionBody.layout();
        }
        IContributionItem[] iContributionItemArray = changeLanguageActions;
        int n = changeLanguageActions.length;
        int gridData2 = 0;
        while (gridData2 < n) {
            IContributionItem action = iContributionItemArray[gridData2];
            this.getForm().getMenuManager().add(action);
            ++gridData2;
        }
        this.populateExpressionSectionToolbar(this.expressionSection);
        this.populateResultSectionToolbar(this.resultSection);
        IWorkbenchPage currentPage = this.getSite().getPage();
        if (currentPage != null) {
            IEditorPart currentEditor = currentPage.getActiveEditor();
            if (currentEditor == null) {
                this.linkWithEditorContextAction.setEnabled(false);
            } else {
                this.linkWithEditorContextAction.setEnabled(this.getCurrentLanguageInterpreter().canLinkWithEditor(currentEditor));
            }
        } else {
            this.linkWithEditorContextAction.setEnabled(false);
        }
        this.getCurrentLanguageInterpreter().addToolBarActions(this, toolBarManager);
        toolBarManager.update(true);
    }

    protected final void setCompilationResult(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    protected final void setEvaluationResult(EvaluationResult result) {
        ArrayList<Object> input = new ArrayList<Object>();
        Object evaluationResult = result.getEvaluationResult();
        if (evaluationResult instanceof Collection) {
            for (Object child : (Collection)evaluationResult) {
                if (child == null) continue;
                input.add(child);
            }
        } else if (evaluationResult != null) {
            input.add(evaluationResult);
        }
        this.resultViewer.setInput(input);
    }

    protected final void setUpContentAssist(final IInterpreterSourceViewer viewer) {
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (this.activationTokenContentAssist != null) {
            service.deactivateHandler(this.activationTokenContentAssist);
        }
        Action contentAssistAction = new Action(){

            public void run() {
                viewer.showContentAssist(InterpreterView.this.getInterpreterContext());
            }
        };
        ActionHandler contentAssistHandler = new ActionHandler((IAction)contentAssistAction);
        this.activationTokenContentAssist = service.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)contentAssistHandler);
    }

    protected void setUpRealTimeCompilation(SourceViewer viewer) {
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (InterpreterView.this.realTimeThread != null) {
                    InterpreterView.this.realTimeThread.reset();
                    InterpreterView.this.realTimeThread.setDirty();
                }
            }
        });
    }

    protected void setUpResultDragSupport(TreeViewer viewer) {
        int operations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(operations, transfers, (DragSourceListener)new ResultDragListener(viewer));
    }

    protected void setUpVariableActions(TreeViewer viewer) {
        Tree tree = viewer.getTree();
        final RenameVariableAction renameAction = new RenameVariableAction(viewer);
        final DeleteVariableOrValueAction deleteAction = new DeleteVariableOrValueAction(viewer);
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 && event.stateMask == 0) {
                    if (deleteAction.isEnabled()) {
                        deleteAction.run();
                    }
                } else if (event.keyCode == 0x100000B && event.stateMask == 0 && renameAction.isEnabled()) {
                    renameAction.run();
                }
            }
        });
    }

    protected void setUpVariableDropSupport(TreeViewer viewer) {
        int operations = 23;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        viewer.addDropSupport(operations, transfers, (DropTargetListener)new VariableDropListener(viewer));
    }

    private int convertStatusToMessageSeverity(int statusSeverity) {
        int severity = 0;
        switch (statusSeverity) {
            case 1: {
                severity = 1;
                break;
            }
            case 2: {
                severity = 2;
                break;
            }
            case 4: {
                severity = 3;
                break;
            }
            default: {
                severity = 0;
            }
        }
        return severity;
    }

    private void createExpressionMenu(SourceViewer viewer) {
        MenuManager menuManager = new MenuManager(MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.createExpressionMenuListener(viewer));
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private void createResultMenu(Viewer viewer) {
        MenuManager menuManager = new MenuManager(MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.createResultMenuListener(viewer));
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private void createVariableMenu(TreeViewer viewer) {
        MenuManager menuManager = new MenuManager(MENU_ID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(this.createVariableMenuListener(viewer));
        Menu menu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private LanguageInterpreterDescriptor getCurrentLanguageDescriptor() {
        return this.currentLanguage;
    }

    private void setUpDefaultTextAction(final SourceViewer viewer) {
        IHandlerService service = (IHandlerService)this.getSite().getService(IHandlerService.class);
        if (this.activationTokenRedo != null) {
            service.deactivateHandler(this.activationTokenRedo);
        }
        if (this.activationTokenUndo != null) {
            service.deactivateHandler(this.activationTokenUndo);
        }
        Action redoAction = new Action(){

            public void run() {
                viewer.doOperation(2);
            }
        };
        ActionHandler redoHandler = new ActionHandler((IAction)redoAction);
        Action undoAction = new Action(){

            public void run() {
                viewer.doOperation(1);
            }
        };
        ActionHandler undoHandler = new ActionHandler((IAction)undoAction);
        this.activationTokenRedo = service.activateHandler(WORKBENCH_CONSTANT_EDIT_REDO, (IHandler)redoHandler);
        this.activationTokenUndo = service.activateHandler(WORKBENCH_CONSTANT_EDIT_UNDO, (IHandler)undoHandler);
    }

    private class ChangeLanguageAction
    extends Action {
        private final LanguageInterpreterDescriptor language;

        public ChangeLanguageAction(LanguageInterpreterDescriptor language) {
            super(language.getLabel(), 8);
            this.language = language;
        }

        public void run() {
            InterpreterView.this.selectLanguage(this.language);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompilationThread
    extends Thread {
        private boolean cancelled;
        private Future<CompilationResult> compilationTask;

        public CompilationThread(Future<CompilationResult> compilationTask) {
            super("InterpreterCompilationThread");
            this.compilationTask = compilationTask;
        }

        @Override
        public void interrupt() {
            this.cancelled = true;
            this.compilationTask.cancel(true);
            super.interrupt();
        }

        @Override
        public void run() {
            try {
                final CompilationResult result = this.compilationTask.get();
                this.checkCancelled();
                if (result != null && result.getStatus() != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            InterpreterView.this.clearCompilationMessages();
                            CompilationThread.this.checkCancelled();
                            InterpreterView.this.addStatusMessages(result.getStatus(), InterpreterView.COMPILATION_MESSAGE_PREFIX);
                        }
                    });
                }
                InterpreterView.this.setCompilationResult(result);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException e) {
                this.checkCancelled();
                String message = e.getMessage();
                if (e.getCause() != null) {
                    message = e.getCause().getMessage();
                }
                Status status = new Status(4, "org.eclipse.acceleo.ui.interpreter", message);
                CompilationResult result = new CompilationResult((IStatus)status);
                Display.getDefault().asyncExec(new Runnable((IStatus)status){
                    private final /* synthetic */ IStatus val$status;
                    {
                        this.val$status = iStatus;
                    }

                    public void run() {
                        InterpreterView.this.clearCompilationMessages();
                        CompilationThread.this.checkCancelled();
                        InterpreterView.this.addStatusMessages(this.val$status, InterpreterView.COMPILATION_MESSAGE_PREFIX);
                    }
                });
                InterpreterView.this.setCompilationResult(result);
            }
        }

        protected void checkCancelled() {
            if (this.cancelled) {
                throw new CancellationException();
            }
        }
    }

    private class EObjectSelectionListener
    implements ISelectionListener {
        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                boolean cleared = false;
                for (Object next : (IStructuredSelection)selection) {
                    EObject nextEObject = next instanceof EObject ? (EObject)next : (next instanceof IAdaptable ? (EObject)((IAdaptable)next).getAdapter(EObject.class) : (EObject)Platform.getAdapterManager().getAdapter(next, EObject.class));
                    if (nextEObject == null) continue;
                    if (!cleared) {
                        InterpreterView.this.clearSelection();
                        cleared = true;
                    }
                    InterpreterView.this.addToSelection(nextEObject);
                }
                if (cleared && InterpreterView.this.realTimeThread != null) {
                    InterpreterView.this.realTimeThread.setDirty();
                }
            }
        }
    }

    private class EvaluationThread
    extends Thread {
        private boolean cancelled;
        private Future<EvaluationResult> evaluationTask;
        private final InterpreterContext interpreterContext;

        public EvaluationThread(InterpreterContext interpreterContext) {
            super("InterpreterEvaluationThread");
            this.interpreterContext = interpreterContext;
        }

        public void interrupt() {
            this.cancelled = true;
            if (this.evaluationTask != null) {
                this.evaluationTask.cancel(true);
            }
            super.interrupt();
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            block11: {
                try {
                    this.checkCancelled();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            InterpreterView.this.getForm().setBusy(true);
                        }
                    });
                    if (InterpreterView.this.compilationThread != null) {
                        InterpreterView.this.compilationThread.join();
                    }
                    this.checkCancelled();
                    evaluationCallable = InterpreterView.this.getCurrentLanguageInterpreter().getEvaluationTask(new EvaluationContext(this.interpreterContext, InterpreterView.this.compilationResult));
                    this.evaluationTask = InterpreterView.this.evaluationPool.submit(evaluationCallable);
                    result = this.evaluationTask.get();
                    this.checkCancelled();
                    if (result != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                InterpreterView.this.clearEvaluationMessages();
                                if (result.getStatus() != null) {
                                    InterpreterView.this.addStatusMessages(result.getStatus(), InterpreterView.EVALUATION_MESSAGE_PREFIX);
                                }
                                InterpreterView.this.setEvaluationResult(result);
                            }
                        });
                    }
                }
                catch (InterruptedException v0) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            InterpreterView.this.getForm().setBusy(false);
                        }
                    });
                    break block11;
                }
                catch (CancellationException v1) {
                    ** try [egrp 2[TRYBLOCK] [4 : 145->146)] { 
lbl20:
                    // 1 sources

                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                    break block11;
                }
                catch (ExecutionException e) {
                    message = e.getMessage();
                    if (e.getCause() != null) {
                        message = e.getCause().getMessage();
                    }
                    message = String.valueOf(e.getClass().getName()) + ' ' + message;
                    status = new Status(4, "org.eclipse.acceleo.ui.interpreter", message);
                    result = new EvaluationResult((IStatus)status);
                    Display.getDefault().asyncExec(new Runnable((IStatus)status, result){
                        private final /* synthetic */ IStatus val$status;
                        private final /* synthetic */ EvaluationResult val$result;
                        {
                            this.val$status = iStatus;
                            this.val$result = evaluationResult;
                        }

                        public void run() {
                            InterpreterView.this.clearEvaluationMessages();
                            InterpreterView.this.addStatusMessages(this.val$status, InterpreterView.EVALUATION_MESSAGE_PREFIX);
                            InterpreterView.this.setEvaluationResult(this.val$result);
                        }
                    });
lbl-1000:
                    // 3 sources

                    {
                        catch (Throwable var5_7) {
                            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                            throw var5_7;
                        }
                    }
                    Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
                    break block11;
                }
                Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
            }
        }

        protected void checkCancelled() {
            if (this.cancelled) {
                throw new CancellationException();
            }
        }
    }

    protected class ExpressionMenuListener
    implements IMenuListener {
        private final SourceViewer sourceViewer;

        public ExpressionMenuListener(SourceViewer sourceViewer) {
            this.sourceViewer = sourceViewer;
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IAction)new EvaluateAction(InterpreterView.this));
            manager.add((IAction)new ClearExpressionViewerAction((Viewer)this.sourceViewer));
            manager.add((IContributionItem)new Separator("additions"));
        }
    }

    protected class InterpreterEditorPartListener
    implements IPartListener2 {
        protected InterpreterEditorPartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (!InterpreterView.this.linkWithEditorContextAction.isChecked() && partRef instanceof IEditorReference) {
                InterpreterView.this.linkWithEditorContextAction.setEnabled(InterpreterView.this.getCurrentLanguageInterpreter().canLinkWithEditor(((IEditorReference)partRef).getEditor(false)));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (!InterpreterView.this.linkWithEditorContextAction.isChecked() && partRef instanceof IEditorReference && InterpreterView.this.getSite().getPage() != null) {
                IEditorPart editorPart = InterpreterView.this.getSite().getPage().getActiveEditor();
                if (editorPart == null) {
                    InterpreterView.this.linkWithEditorContextAction.setEnabled(false);
                } else {
                    InterpreterView.this.linkWithEditorContextAction.setEnabled(InterpreterView.this.getCurrentLanguageInterpreter().canLinkWithEditor(editorPart));
                }
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    }

    private class RealTimeThread
    extends Thread {
        private static final int DELAY = 500;
        private boolean dirty;
        private final Object lock;
        private boolean reset;

        public RealTimeThread() {
            super("InterpreterRealTimeThread");
            this.lock = new Object();
            this.setPriority(1);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            RealTimeThread realTimeThread = this;
            synchronized (realTimeThread) {
                this.reset = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.interrupted()) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                object = this;
                synchronized (object) {
                    if (this.reset) {
                        this.reset = false;
                        continue;
                    }
                    if (!this.dirty) {
                        continue;
                    }
                    this.dirty = false;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        InterpreterView.this.compileExpression();
                        InterpreterView.this.evaluate();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDirty() {
            RealTimeThread realTimeThread = this;
            synchronized (realTimeThread) {
                this.dirty = true;
            }
        }
    }

    protected class ResultDoubleClickListener
    implements IDoubleClickListener {
        protected ResultDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (event.getSelection().isEmpty() || !(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            Object target = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (target instanceof InterpreterFile) {
                this.showGeneratedFile((InterpreterFile)target);
            } else if (target instanceof String && (((String)target).indexOf(10) >= 0 || ((String)target).indexOf(13) >= 0)) {
                GeneratedTextDialog dialog = new GeneratedTextDialog(Display.getCurrent().getActiveShell(), "Evaluation result", (String)target);
                dialog.open();
            }
        }

        private void showGeneratedFile(InterpreterFile file) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench.getActiveWorkbenchWindow() == null || workbench.getActiveWorkbenchWindow().getActivePage() == null) {
                return;
            }
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            InterpreterFileStorage storage = new InterpreterFileStorage(file);
            IEditorDescriptor editor = workbench.getEditorRegistry().getDefaultEditor(file.getFileName());
            StorageEditorInput input = new StorageEditorInput(storage);
            try {
                String editorID = editor == null ? "org.eclipse.ui.DefaultTextEditor" : editor.getId();
                page.openEditor((IEditorInput)input, editorID);
            }
            catch (PartInitException partInitException) {}
        }
    }

    protected class ResultMenuListener
    implements IMenuListener {
        private Viewer resultViewer;

        public ResultMenuListener(Viewer resultViewer) {
            this.resultViewer = resultViewer;
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IAction)new ClearResultViewerAction(this.resultViewer));
            manager.add((IContributionItem)new Separator("additions"));
        }
    }

    protected class VariableMenuListener
    implements IMenuListener {
        private TreeViewer variableViewer;

        public VariableMenuListener(TreeViewer variableViewer) {
            this.variableViewer = variableViewer;
        }

        public void menuAboutToShow(IMenuManager manager) {
            Variable variable = this.getCurrentVariable();
            manager.add((IAction)new NewVariableWizardAction(this.variableViewer, variable));
            manager.add((IAction)new ClearVariableViewerAction((Viewer)this.variableViewer));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new DeleteVariableOrValueAction(this.variableViewer));
            manager.add((IAction)new RenameVariableAction(this.variableViewer));
            manager.add((IContributionItem)new Separator("additions"));
        }

        private Variable getCurrentVariable() {
            if (this.variableViewer == null || this.variableViewer.getTree() == null || this.variableViewer.getTree().isDisposed()) {
                return null;
            }
            Tree tree = this.variableViewer.getTree();
            TreeItem[] selectedItems = tree.getSelection();
            Variable selectedVariable = null;
            if (selectedItems != null && selectedItems.length > 0) {
                TreeItem item;
                int i = 0;
                while (i < selectedItems.length && selectedVariable == null) {
                    item = selectedItems[i];
                    if (item.getData() instanceof Variable) {
                        selectedVariable = (Variable)item.getData();
                    }
                    ++i;
                }
                i = 0;
                while (i < selectedItems.length && selectedVariable == null) {
                    item = selectedItems[i].getParentItem();
                    while (item != null && selectedVariable == null) {
                        if (item.getData() instanceof Variable) {
                            selectedVariable = (Variable)item.getData();
                        }
                        item = item.getParentItem();
                    }
                    ++i;
                }
            }
            return selectedVariable;
        }
    }
}

