/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser.ast;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.core.parser.ast.BodyElement;
import org.eclipse.jet.core.parser.ast.BodyElements;
import org.eclipse.jet.core.parser.ast.JETAST;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.Problem;
import org.eclipse.jet.taglib.TagLibraryReference;

public final class JETCompilationUnit
extends JETASTElement {
    private BodyElements bodyElements = null;
    private final List problems = new ArrayList();
    private String outputJavaPackage = null;
    private String outputJavaClassName;
    private boolean errors = false;
    private boolean warnings = false;
    private TagLibraryReference[] tagLibraryReferences;
    private Set imports = new LinkedHashSet();
    private final URI baseLocation;
    private final String templatePath;
    private final String encoding;

    JETCompilationUnit(JETAST ast, URI baseLocation, String templatePath, String encoding) {
        super(ast, -1, -1, -1, -1);
        this.baseLocation = baseLocation;
        this.templatePath = templatePath;
        this.encoding = encoding;
    }

    public void setPredefinedTagLibraries(Map predefinedLibraryMap) {
    }

    BodyElements getInternalBodyElements() {
        if (this.bodyElements == null) {
            this.bodyElements = new BodyElements(this);
        }
        return this.bodyElements;
    }

    public final List getBodyElements() {
        if (this.bodyElements == null) {
            return Collections.EMPTY_LIST;
        }
        return this.bodyElements.getBodyElements();
    }

    public final void addBodyElement(BodyElement bodyElement) {
        this.getInternalBodyElements().addBodyElement(bodyElement);
    }

    protected final void accept0(JETASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            Iterator i = this.getBodyElements().iterator();
            while (i.hasNext()) {
                JETASTElement element = (JETASTElement)i.next();
                element.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public List getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public boolean hasWarnings() {
        return this.warnings;
    }

    public void createProblem(ProblemSeverity error, int problemId, String message, Object[] messageArgs, int start, int end, int line, int colOffset) {
        if (error == ProblemSeverity.ERROR) {
            this.errors = true;
        } else if (error == ProblemSeverity.WARNING) {
            this.warnings = true;
        }
        this.problems.add(new Problem(this.baseLocation, this.templatePath, error, problemId, message, messageArgs, start, end, line, colOffset));
    }

    public String getOutputJavaPackage() {
        return this.outputJavaPackage;
    }

    public String getOutputJavaClassName() {
        return this.outputJavaClassName;
    }

    public void setOutputJavaClassName(String outputJavaClassName) {
        this.outputJavaClassName = outputJavaClassName;
    }

    public void setOutputJavaPackage(String outputJavaPackage) {
        this.outputJavaPackage = outputJavaPackage;
    }

    public boolean removeLineWhenOtherwiseEmpty() {
        return false;
    }

    public TagLibraryReference[] getTagLibraryReferences() {
        return this.tagLibraryReferences == null ? new TagLibraryReference[]{} : this.tagLibraryReferences;
    }

    public void addImports(List list) {
        this.imports.addAll(list);
    }

    public Set getImports() {
        return Collections.unmodifiableSet(this.imports);
    }

    public void setTagLibraryReferences(TagLibraryReference[] tagLibraryReferences) {
        this.tagLibraryReferences = tagLibraryReferences;
    }

    public String getOutputEncoding() {
        return this.encoding;
    }

    public JETASTElement elementAfter(JETASTElement element) {
        return this.bodyElements.elementAfter(element);
    }

    public BodyElement elementBefore(JETASTElement element) {
        return this.bodyElements.elementBefore(element);
    }
}

