/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.JET2TemplateStatus;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagFactory;
import org.eclipse.jet.taglib.TagInfo;

public final class JET2Context {
    private Object source;
    private BasicDiagnostic stati = new BasicDiagnostic("", 0, "", null);
    private final Map extendedContextData = new HashMap();
    private TagFactory tagFactory = null;
    private final Map globalVariables = new HashMap();
    private String templatePath = "";
    private String jetBundleId;
    private static final Pattern validVariableNamePattern = Pattern.compile("(?:_|\\p{L})(?:_|-|\\.|\\p{L}|\\d)*");

    public JET2Context(Object source, Map variables) {
        this.source = source;
        this.globalVariables.putAll(variables);
    }

    public JET2Context(Object source) {
        this(source, Collections.EMPTY_MAP);
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    private void log(int severity, String templatePath, TagInfo tagInfo, String message, Throwable throwable) {
        if (!(message != null && message.length() != 0 || throwable == null || (message = throwable.getLocalizedMessage()) != null && message.length() != 0)) {
            message = throwable.toString();
        }
        JET2TemplateStatus status = new JET2TemplateStatus(severity, this.getJETBundleId() != null ? this.getJETBundleId() : "org.eclipse.jet", message == null ? "" : message, templatePath, tagInfo, throwable);
        this.stati.add((Diagnostic)status);
        RuntimeLoggerContextExtender.log(this, message, tagInfo, templatePath, this.getLevel(severity));
    }

    private int getLevel(int severity) {
        switch (severity) {
            case 4: {
                return 5;
            }
            case 2: {
                return 4;
            }
            case 1: {
                return 3;
            }
        }
        return 4;
    }

    public String getJETBundleId() {
        return this.jetBundleId;
    }

    public void setJETBundleId(String jetBundleId) {
        this.jetBundleId = jetBundleId;
    }

    public void logInfo(String message) {
        this.log(1, this.getTemplatePath(), null, message, null);
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public void logWarning(String message) {
        this.log(2, this.getTemplatePath(), null, message, null);
    }

    public void logError(String message) {
        this.log(4, this.getTemplatePath(), null, message, null);
    }

    public void logError(Throwable e) {
        this.log(4, this.getTemplatePath(), null, null, e);
    }

    public void logError(String message, Throwable e) {
        this.log(4, this.getTemplatePath(), null, message, e);
    }

    public Diagnostic getLogAsMultiStatus() {
        String message = "";
        int worstSeverity = this.stati.recomputeSeverity();
        if (worstSeverity == 0) {
            message = JET2Messages.JET2Context_SuccessfulExecution;
        } else if (worstSeverity == 1) {
            message = JET2Messages.JET2Context_SuccessfulWithMessages;
        } else if (worstSeverity == 2) {
            message = JET2Messages.JET2Context_SuccessfulWithWarnings;
        } else if (worstSeverity == 4) {
            message = JET2Messages.JET2Context_ErrorsInExecution;
        }
        BasicDiagnostic summary = new BasicDiagnostic("org.eclipse.jet", 0, this.stati.getChildren(), message, null);
        summary.recomputeSeverity();
        return summary;
    }

    public void logError(TagInfo tagInfo, String message, Throwable exception) {
        this.log(4, this.getTemplatePath(), tagInfo, message, exception);
    }

    private String getContextExtenderId(Class clazz) {
        return clazz.getName();
    }

    public boolean hasContextExtender(Class extenderClass) {
        return this.extendedContextData.containsKey(this.getContextExtenderId(extenderClass));
    }

    void registerContextExtender(Class extenderClass, Object extenderData) {
        String extenderId = this.getContextExtenderId(extenderClass);
        if (this.extendedContextData.containsKey(extenderClass)) {
            throw new IllegalStateException(String.valueOf(extenderId) + "already registered");
        }
        this.extendedContextData.put(extenderId, extenderData);
    }

    Object getContextExtenderData(Class extenderClass) {
        return this.extendedContextData.get(this.getContextExtenderId(extenderClass));
    }

    public void logError(String templatePath, TagInfo tagInfo, String message, Throwable e) {
        this.log(4, templatePath, tagInfo, message, e);
    }

    public void setVariable(String var, Object value) throws JET2TagException {
        if (!validVariableNamePattern.matcher(var).matches()) {
            throw new JET2TagException(MessageFormat.format(JET2Messages.JET2Context_InvalidVariableName, var));
        }
        this.globalVariables.put(var, value);
    }

    public Object getVariable(String var) throws JET2TagException {
        if (!this.hasVariable(var)) {
            String msg = JET2Messages.JET2Context_VariableNotFound;
            throw new JET2TagException(MessageFormat.format(msg, var));
        }
        return this.globalVariables.get(var);
    }

    public Map getVariables() {
        return new HashMap(this.globalVariables);
    }

    public void removeVariable(String var) throws JET2TagException {
        this.globalVariables.remove(var);
    }

    public boolean hasVariable(String var) {
        return this.globalVariables.containsKey(var);
    }

    public final TagFactory getTagFactory() {
        return this.tagFactory;
    }

    public final void setTagFactory(TagFactory tagFactory) {
        this.tagFactory = tagFactory;
    }

    public Map extractVariables(String variableNames) throws JET2TagException {
        HashMap<String, Object> savedVariableValues = null;
        if (variableNames != null) {
            savedVariableValues = new HashMap<String, Object>();
            StringTokenizer tokenizer = new StringTokenizer(variableNames, ",");
            while (tokenizer.hasMoreTokens()) {
                String varName = tokenizer.nextToken();
                varName = varName.trim();
                savedVariableValues.put(varName, this.getVariable(varName));
            }
        }
        return savedVariableValues;
    }

    public void restoreVariables(Map savedVariableValues) throws JET2TagException {
        if (savedVariableValues != null) {
            Iterator i = savedVariableValues.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void setVariables(Map variablesToPass) throws JET2TagException {
        this.globalVariables.clear();
        Iterator i = variablesToPass.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String varName = (String)entry.getKey();
            this.setVariable(varName, entry.getValue());
        }
    }
}

