/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jet.compiler.ASTCompilerParseListener;
import org.eclipse.jet.compiler.BodyElements;
import org.eclipse.jet.compiler.JET2AST;
import org.eclipse.jet.compiler.JET2ASTElement;
import org.eclipse.jet.compiler.JET2ASTVisitor;
import org.eclipse.jet.compiler.Problem;
import org.eclipse.jet.internal.parser.JETReader;
import org.eclipse.jet.internal.parser.ParseProblemSeverity;
import org.eclipse.jet.taglib.TagLibraryReference;

public final class JET2CompilationUnit
extends JET2ASTElement {
    private BodyElements bodyElements = null;
    private final List problems = new ArrayList();
    private final String fileName;
    private String outputJavaPackage = null;
    private String outputJavaClassName;
    private boolean errors = false;
    private boolean warnings = false;
    private final IFile file;
    private Map predefinedLibraryMap = Collections.EMPTY_MAP;
    private TagLibraryReference[] tagLibraryReferences;
    private Set imports = new LinkedHashSet();

    public JET2CompilationUnit() {
        super(new JET2AST(), -1, -1, -1, -1);
        this.fileName = "";
        this.file = null;
    }

    public JET2CompilationUnit(IFile file) {
        super(new JET2AST(), -1, -1, -1, -1);
        this.file = file;
        this.fileName = file.getFullPath().toString();
    }

    public void setPredefinedTagLibraries(Map predefinedLibraryMap) {
        this.predefinedLibraryMap = predefinedLibraryMap;
    }

    public void parse(String document) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(document.getBytes("UTF-8"));
            this.internalParse(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Should not have happened", e);
        }
    }

    public void parse() throws CoreException {
        if (this.file == null) {
            throw new IllegalStateException();
        }
        InputStream contents = this.file.getContents();
        String charset = this.file.getCharset();
        this.internalParse(contents, charset);
    }

    public void parse(InputStream contents, String charset) {
        this.internalParse(contents, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalParse(InputStream contents, String charset) {
        block10: {
            this.problems.clear();
            this.errors = false;
            this.warnings = false;
            this.bodyElements = null;
            this.outputJavaPackage = null;
            this.outputJavaClassName = null;
            try {
                try {
                    JETReader reader = new JETReader(this.fileName, contents, charset);
                    ASTCompilerParseListener listener = new ASTCompilerParseListener(this, reader, this.predefinedLibraryMap != null ? this.predefinedLibraryMap : Collections.EMPTY_MAP);
                    listener.parse(reader);
                    this.tagLibraryReferences = listener.getTagLibraryReferences();
                    Object var5_6 = null;
                }
                catch (JETException e) {
                    this.createProblem(ParseProblemSeverity.ERROR, 9, e.getLocalizedMessage(), null, 0, 0, 1, 1);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    contents.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            contents.close();
            return;
        }
        Object var5_8 = null;
        try {}
        catch (IOException iOException) {
            return;
        }
        contents.close();
    }

    BodyElements getInternalBodyElements() {
        if (this.bodyElements == null) {
            this.bodyElements = new BodyElements(this);
        }
        return this.bodyElements;
    }

    public final List getBodyElements() {
        if (this.bodyElements == null) {
            return Collections.EMPTY_LIST;
        }
        return this.bodyElements.getBodyElements();
    }

    public void accept(JET2ASTVisitor visitor) {
        visitor.visit(this);
        Iterator i = this.getBodyElements().iterator();
        while (i.hasNext()) {
            JET2ASTElement element = (JET2ASTElement)i.next();
            element.accept(visitor);
        }
        visitor.endVisit(this);
    }

    public List getProblems() {
        return Collections.unmodifiableList(this.problems);
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public boolean hasWarnings() {
        return this.warnings;
    }

    public void createProblem(ParseProblemSeverity error, int problemId, String message, Object[] messageArgs, int start, int end, int line, int colOffset) {
        if (error == ParseProblemSeverity.ERROR) {
            this.errors = true;
        } else if (error == ParseProblemSeverity.WARNING) {
            this.warnings = true;
        }
        this.problems.add(new Problem(this.fileName, error, problemId, message, messageArgs, start, end, line, colOffset));
    }

    public String getOutputJavaPackage() {
        return this.outputJavaPackage;
    }

    public String getOutputJavaClassName() {
        return this.outputJavaClassName;
    }

    public void setOutputJavaClassName(String outputJavaClassName) {
        this.outputJavaClassName = outputJavaClassName;
    }

    public void setOutputJavaPackage(String outputJavaPackage) {
        this.outputJavaPackage = outputJavaPackage;
    }

    public boolean removeLineWhenOtherwiseEmpty() {
        return false;
    }

    public TagLibraryReference[] getTagLibraryReferences() {
        return this.tagLibraryReferences;
    }

    public void addImports(List list) {
        this.imports.addAll(list);
    }

    public Set getImports() {
        return Collections.unmodifiableSet(this.imports);
    }
}

