/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import java.util.Iterator;
import org.eclipse.jet.internal.xpath.NodeSetImpl;
import org.eclipse.jet.internal.xpath.ast.Axis;
import org.eclipse.jet.internal.xpath.ast.NodeSetExpr;
import org.eclipse.jet.internal.xpath.ast.NodeTest;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.NodeSet;

public class Step
extends NodeSetExpr {
    private final Axis axis;
    private final NodeTest nodeTest;
    private final NodeSetExpr leftLocationPath;

    public Step(NodeSetExpr leftLocationPath, Axis axis, NodeTest nodeTest) {
        this.leftLocationPath = leftLocationPath;
        this.axis = axis;
        this.nodeTest = nodeTest;
    }

    public NodeSet evalAsNodeSet(Context context) {
        NodeSet leftNodeSet = this.leftLocationPath.evalAsNodeSet(context);
        NodeSet result = NodeSetImpl.EMPTY_SET;
        int contextSize = leftNodeSet.size();
        int contextPosition = 1;
        Iterator i = leftNodeSet.iterator();
        while (i.hasNext()) {
            Object contextNode = i.next();
            Context subContext = context.newSubContext(contextNode, contextPosition, contextSize);
            NodeSet subResult = this.axis.evaluate(this.nodeTest, subContext);
            if (result.size() == 0 && subResult.size() > 0) {
                result = subResult;
            } else if (subResult.size() > 0) {
                result.addAll(subResult);
            }
            ++contextPosition;
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.leftLocationPath.toString()) + "/" + this.axis.toString() + this.nodeTest.toString();
    }
}

