/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.xpath;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jet.xpath.IAnnotationManager;
import org.eclipse.jet.xpath.XPathVariableResolver;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public final class Context {
    private final Object contextNode;
    private final int contextPosition;
    private final int contextSize;
    private final InspectorManager inspectorManager;
    private final XPathVariableResolver variableResolver;
    private final IAnnotationManager annotationManager;

    private Context(Object contextNode, int contextPosition, int contextSize, XPathVariableResolver variableResolver, IAnnotationManager annotationManager) {
        this.contextNode = contextNode;
        this.contextPosition = contextPosition;
        this.contextSize = contextSize;
        this.variableResolver = variableResolver;
        this.annotationManager = annotationManager;
        this.inspectorManager = InspectorManager.getInstance();
    }

    public Context(Object contextNode, final Map variables, IAnnotationManager annotationManager) {
        this(contextNode, new XPathVariableResolver(){

            public Object resolveVariable(String variableName) {
                return variables != null ? variables.get(variableName) : null;
            }
        }, annotationManager);
    }

    public Context(Object contextNode, XPathVariableResolver variableResolver, IAnnotationManager annotationManager) {
        this(contextNode, 1, 1, variableResolver, annotationManager);
    }

    public Context(Object contextNode, IAnnotationManager annotationManager) {
        this(contextNode, Collections.EMPTY_MAP, annotationManager);
    }

    public int getContextPosition() {
        return this.contextPosition;
    }

    public int getContextSize() {
        return this.contextSize;
    }

    public Object getContextNode() {
        return this.contextNode;
    }

    public Context newSubContext(Object contextNode2, int contextPosition2, int contextSize2) {
        return new Context(contextNode2, contextPosition2, contextSize2, this.variableResolver, this.annotationManager);
    }

    public INodeInspector getContextNodeInspector() {
        return this.inspectorManager.getInspector(this.contextNode);
    }

    public XPathVariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public String toString() {
        return "Context(" + this.contextNode.toString() + "," + this.contextPosition + "," + this.contextSize + ")";
    }

    public boolean hasAnnotationManager() {
        return this.annotationManager != null;
    }

    public IAnnotationManager getAnnotationManager() {
        if (this.annotationManager == null) {
            throw new IllegalStateException();
        }
        return this.annotationManager;
    }
}

