/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.format;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jet.internal.taglib.format.FormatNowTag;
import org.eclipse.jet.internal.taglib.format.IndentTag;
import org.eclipse.jet.internal.taglib.format.LowerCaseTag;
import org.eclipse.jet.internal.taglib.format.MillisecondsTag;
import org.eclipse.jet.internal.taglib.format.ReplaceAllTag;
import org.eclipse.jet.internal.taglib.format.StripTag;
import org.eclipse.jet.internal.taglib.format.UniqueTag;
import org.eclipse.jet.internal.taglib.format.UpperCaseTag;
import org.eclipse.jet.internal.taglib.format.UuidTag;
import org.eclipse.jet.internal.taglib.format.XPathTag;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInstanceFactory;

public class TagFactory
implements TagInstanceFactory {
    private final Map tagOrdinalByName = new HashMap(10);

    public TagFactory() {
        this.tagOrdinalByName.put("formatNow", new Integer(1));
        this.tagOrdinalByName.put("indent", new Integer(2));
        this.tagOrdinalByName.put("lc", new Integer(3));
        this.tagOrdinalByName.put("milliseconds", new Integer(4));
        this.tagOrdinalByName.put("replaceAll", new Integer(5));
        this.tagOrdinalByName.put("strip", new Integer(6));
        this.tagOrdinalByName.put("uc", new Integer(7));
        this.tagOrdinalByName.put("unique", new Integer(8));
        this.tagOrdinalByName.put("uuid", new Integer(9));
        this.tagOrdinalByName.put("xpath", new Integer(10));
    }

    public CustomTag createCustomTag(String name) {
        Integer ordinal = (Integer)this.tagOrdinalByName.get(name);
        switch (ordinal == null ? 0 : ordinal) {
            case 1: {
                return new FormatNowTag();
            }
            case 2: {
                return new IndentTag();
            }
            case 3: {
                return new LowerCaseTag();
            }
            case 4: {
                return new MillisecondsTag();
            }
            case 5: {
                return new ReplaceAllTag();
            }
            case 6: {
                return new StripTag();
            }
            case 7: {
                return new UpperCaseTag();
            }
            case 8: {
                return new UniqueTag();
            }
            case 9: {
                return new UuidTag();
            }
            case 10: {
                return new XPathTag();
            }
        }
        throw new JET2TagException("Unknown Tag: " + name);
    }
}

