/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.xpath;

import org.eclipse.jet.internal.extensionpoints.XPathFunctionLazyLoadWrapper;
import org.eclipse.jet.xpath.XPathFunction;

public final class XPathFunctionMetaData {
    private XPathFunction function;
    private final int minArgs;
    private final int maxArgs;
    private final String name;
    private final String namespace;

    public final String getNamespace() {
        return this.namespace;
    }

    public XPathFunctionMetaData(String name, String namespace, XPathFunction function, int minArgs, int maxArgs) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (function == null) {
            throw new NullPointerException("function");
        }
        if (minArgs < 0) {
            throw new IllegalArgumentException("minArgs < 0");
        }
        if (maxArgs < 0 && maxArgs != -1) {
            throw new IllegalArgumentException("maxArgs < 0 && maxArgs != -1");
        }
        if (maxArgs < minArgs && maxArgs != -1) {
            throw new IllegalArgumentException("maxArgs < minArgs");
        }
        this.name = name;
        this.namespace = namespace;
        this.function = function;
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
    }

    public synchronized XPathFunction getFunction() {
        if (this.function instanceof XPathFunctionLazyLoadWrapper) {
            XPathFunctionLazyLoadWrapper wrapper = (XPathFunctionLazyLoadWrapper)this.function;
            this.function = wrapper.resolveFunction();
        }
        return this.function;
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    public int getMaxArgs() {
        return this.maxArgs;
    }

    public String getName() {
        return this.name;
    }
}

