/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.profiler.profilermodel.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtend.profiler.profilermodel.CallGroup;
import org.eclipse.xtend.profiler.profilermodel.Cycle;
import org.eclipse.xtend.profiler.profilermodel.Item;
import org.eclipse.xtend.profiler.profilermodel.ModelPackage;
import org.eclipse.xtend.profiler.profilermodel.ProfilingResult;
import org.eclipse.xtend.profiler.profilermodel.impl.CallableImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CycleImpl
extends CallableImpl
implements Cycle {
    protected EList<Item> items;
    protected static final int CALL_COUNT_INBOUND_EDEFAULT = 0;
    protected static final int CALL_COUNT_REENTRANT_EDEFAULT = 0;

    protected CycleImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.CYCLE;
    }

    @Override
    public EList<Item> getItems() {
        if (this.items == null) {
            this.items = new EObjectWithInverseResolvingEList(Item.class, (InternalEObject)this, 5, 10);
        }
        return this.items;
    }

    @Override
    public int getCallCountInbound() {
        int result = 0;
        for (Item i : this.getItems()) {
            for (CallGroup invocation : i.getInvocations()) {
                if (this.equals(invocation.getInvoker().getCycle())) continue;
                result += invocation.getCount();
            }
        }
        return result;
    }

    @Override
    public long getSelfTime() {
        long result = 0L;
        for (Item i : this.getItems()) {
            result += i.getSelfTime();
        }
        return result;
    }

    @Override
    public int getCallCountReentrant() {
        int result = 0;
        for (Item i : this.getItems()) {
            for (CallGroup sub : i.getSubroutines()) {
                if (!this.equals(sub.getSubroutine().getCycle())) continue;
                result += sub.getCount();
            }
        }
        return result;
    }

    @Override
    public String getName() {
        int index = ((ProfilingResult)this.eContainer()).getCycles().indexOf((Object)this) + 1;
        return "cycle " + index;
    }

    @Override
    public long getTime() {
        long result = 0L;
        for (Item i : this.getItems()) {
            result += i.getSelfTime() + i.getOutboundChildTime();
        }
        return result;
    }

    @Override
    protected long getBruttoTime() {
        return this.getTime();
    }

    @Override
    public long getOutboundChildTime() {
        return this.getChildTime();
    }

    @Override
    public EList<CallGroup> getOutgoingCallGroups() {
        BasicEList result = new BasicEList();
        for (Item i : this.getItems()) {
            for (CallGroup sub : i.getSubroutines()) {
                if (this.equals(sub.getSubroutine().getCycle())) continue;
                result.add((Object)sub);
            }
        }
        return result;
    }

    @Override
    public long getChildTime() {
        long result = 0L;
        for (CallGroup sub : this.getOutgoingCallGroups()) {
            result += sub.getTime();
        }
        return result;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getItems()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getItems()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getItems();
            }
            case 6: {
                return this.getCallCountInbound();
            }
            case 7: {
                return this.getCallCountReentrant();
            }
            case 8: {
                return this.getOutgoingCallGroups();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.getItems().clear();
                this.getItems().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.getItems().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.items != null && !this.items.isEmpty();
            }
            case 6: {
                return this.getCallCountInbound() != 0;
            }
            case 7: {
                return this.getCallCountReentrant() != 0;
            }
            case 8: {
                return !this.getOutgoingCallGroups().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

