/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.common.util.URI;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginFinder {
    private final Set<String> requiredMappings;
    private final Map<String, URI> resolvedMappings = new HashMap<String, URI>();

    public PluginFinder(String ... requiredProjects) {
        this.requiredMappings = new HashSet<String>();
        String[] stringArray = requiredProjects;
        int n = requiredProjects.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredProject = stringArray[n2];
            this.addRequiredProject(requiredProject);
            ++n2;
        }
    }

    public void addRequiredProject(String requiredProject) {
        if (!this.resolvedMappings.isEmpty()) {
            throw new IllegalStateException("Cannot addRequiredProject to PluginFinder after resolve()");
        }
        this.requiredMappings.add(requiredProject);
    }

    public String get(String pluginId) {
        URI uri = this.getURI(pluginId);
        return uri == null ? null : (uri.isFile() ? uri.toFileString() : uri.toString());
    }

    public URI getURI(String pluginId) {
        return this.resolvedMappings.get(pluginId);
    }

    private boolean registerBundle(File f) throws IOException {
        JarFile jarFile = new JarFile(f);
        try {
            String project;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (project = manifest.getMainAttributes().getValue("Bundle-SymbolicName")) != null) {
                int indexOf = project.indexOf(59);
                if (indexOf > 0) {
                    project = project.substring(0, indexOf);
                }
                if (this.requiredMappings.contains(project)) {
                    this.resolvedMappings.put(project, URI.createURI((String)("archive:" + f.toURI() + "!/")));
                    return true;
                }
            }
            return false;
        }
        finally {
            jarFile.close();
        }
    }

    private boolean registerProject(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            String project = document.getDocumentElement().getElementsByTagName("name").item(0).getTextContent();
            if (this.requiredMappings.contains(project)) {
                this.resolvedMappings.put(project, URI.createFileURI((String)(String.valueOf(file.getParentFile().getCanonicalPath()) + File.separator)));
                return true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public void resolve() {
        String[] entries;
        String property = System.getProperty("java.class.path");
        if (property == null) {
            return;
        }
        String separator = System.getProperty("path.separator");
        String[] stringArray = entries = property.split(separator);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            File fileEntry = new File(entry);
            try {
                File f = fileEntry.getCanonicalFile();
                if (f.getPath().endsWith(".jar")) {
                    this.registerBundle(f);
                } else if (!this.scanFolder(f, new HashSet<String>(), 0)) {
                    while ((f = f.getParentFile()) != null) {
                        File dotProject = new File(f, ".project");
                        if (!dotProject.exists()) continue;
                        this.registerProject(dotProject);
                        break;
                    }
                }
                if (this.resolvedMappings.size() >= this.requiredMappings.size()) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    private boolean scanFolder(File f, Set<String> alreadyVisited, int depth) throws IOException {
        if (!alreadyVisited.add(f.getCanonicalPath())) {
            return true;
        }
        File[] files = f.listFiles();
        boolean containsProject = false;
        File dotProject = null;
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists() && file.isDirectory() && depth < 2 && !file.getName().startsWith(".")) {
                    containsProject |= this.scanFolder(file, alreadyVisited, depth + 1);
                } else if (".project".equals(file.getName())) {
                    dotProject = file;
                } else if (file.getName().endsWith(".jar")) {
                    this.registerBundle(file);
                }
                ++n2;
            }
        }
        if (!containsProject && dotProject != null) {
            this.registerProject(dotProject);
        }
        return containsProject || dotProject != null;
    }
}

