/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.CardinalityVariable;
import org.eclipse.ocl.examples.xtext.build.analysis.GrammarAnalysis;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationRuleAnalysis;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.DynamicRuleMatch;
import org.eclipse.ocl.examples.xtext.serializer.EnumerationValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleVector;
import org.eclipse.ocl.examples.xtext.serializer.Nameable;
import org.eclipse.ocl.examples.xtext.serializer.SerializationMatchTerm;
import org.eclipse.ocl.examples.xtext.serializer.SerializationRule;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;

public abstract class CardinalityExpression
implements Nameable {
    protected final @NonNull String name;
    private final @NonNull List<@NonNull CardinalityProduct> sumOfProducts = new ArrayList<CardinalityProduct>();

    protected CardinalityExpression(@NonNull String name) {
        this.name = name;
    }

    public void addMultiplicityProduct(@NonNull Iterable<@NonNull CardinalityVariable> variables, @NonNull GrammarRuleVector grammarRuleVector) {
        ArrayList<@NonNull CardinalityVariable> prunedList = new ArrayList<CardinalityVariable>();
        for (CardinalityVariable variable : variables) {
            assert (!variable.isOne());
            prunedList.add(variable);
        }
        this.sumOfProducts.add(new CardinalityProduct(prunedList, grammarRuleVector));
    }

    protected void appendSumOfProducts(@NonNull DiagnosticStringBuilder s) {
        boolean isFirst = true;
        for (CardinalityProduct product : this.sumOfProducts) {
            if (!isFirst) {
                s.append(" + ");
            }
            product.toString(s);
            isFirst = false;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Set<@NonNull CardinalityVariable> computeUnsolvedCommonFactors(@NonNull SerializationRuleAnalysis serializationRuleAnalysis) {
        HashSet<@NonNull E> intersection = null;
        for (CardinalityProduct products : this.sumOfProducts) {
            Object resolution = this.resolveProduct(serializationRuleAnalysis, products);
            if (resolution instanceof Integer || !(resolution instanceof Set)) continue;
            @NonNull Set resolutions = (Set)resolution;
            if (intersection == null) {
                intersection = new HashSet(resolutions);
                continue;
            }
            intersection.retainAll(resolutions);
        }
        return intersection != null && !intersection.isEmpty() ? intersection : null;
    }

    protected abstract @NonNull SerializationMatchTerm createSizeCardinalityMatchTerm();

    public @NonNull SerializationMatchTerm createMatchTerm(@NonNull SerializationRuleAnalysis serializationRuleAnalysis, @Nullable CardinalityVariable solvedVariable, boolean mayBeMany, @NonNull GrammarRuleVector grammarRuleVector) {
        SerializationMatchTerm.SerializationMatchTermVariable termMatchTerm;
        SerializationMatchTerm.SerializationMatchTermInteger sumMatchTerm;
        ArrayList<@NonNull CardinalityProduct> constantSumOfProducts = new ArrayList<CardinalityProduct>();
        ArrayList<@NonNull CardinalityProduct> factorSumOfProducts = new ArrayList<CardinalityProduct>();
        for (CardinalityProduct product : this.sumOfProducts) {
            boolean isFactor = false;
            ArrayList<@NonNull CardinalityVariable> residualProducts = new ArrayList<CardinalityVariable>();
            for (CardinalityVariable term : product.getVariables()) {
                if (solvedVariable != null && term == solvedVariable) {
                    assert (!isFactor);
                    isFactor = true;
                    continue;
                }
                residualProducts.add(term);
            }
            if (isFactor) {
                factorSumOfProducts.add(new CardinalityProduct(residualProducts, grammarRuleVector));
                continue;
            }
            constantSumOfProducts.add(new CardinalityProduct(residualProducts, grammarRuleVector));
        }
        Set<@NonNull CardinalityVariable> factorCommonVariables = this.getKnownCommonVariables(serializationRuleAnalysis, factorSumOfProducts);
        if (factorCommonVariables != null) {
            Set<@NonNull CardinalityVariable> constantCommonVariables = this.getKnownCommonVariables(serializationRuleAnalysis, constantSumOfProducts);
            for (CardinalityVariable commonVariable : factorCommonVariables) {
                if (!mayBeMany && commonVariable.mayBeMany() || !constantSumOfProducts.isEmpty() && (constantCommonVariables == null || !constantCommonVariables.contains(commonVariable))) continue;
                for (CardinalityProduct constantProduct : constantSumOfProducts) {
                    constantProduct.getVariables().remove(commonVariable);
                }
                for (CardinalityProduct factorProduct : factorSumOfProducts) {
                    factorProduct.getVariables().remove(commonVariable);
                }
            }
        }
        SerializationMatchTerm resultMatchTerm = this.createSizeCardinalityMatchTerm();
        for (CardinalityProduct constantProduct : constantSumOfProducts) {
            sumMatchTerm = null;
            for (CardinalityVariable constantTerm : constantProduct.getVariables()) {
                termMatchTerm = new SerializationMatchTerm.SerializationMatchTermVariable(constantTerm.getIndex());
                Object object = sumMatchTerm = sumMatchTerm != null ? new SerializationMatchTerm.SerializationMatchTermMultiply((SerializationMatchTerm)sumMatchTerm, (SerializationMatchTerm)termMatchTerm) : termMatchTerm;
            }
            resultMatchTerm = new SerializationMatchTerm.SerializationMatchTermSubtract(resultMatchTerm, (SerializationMatchTerm)(sumMatchTerm != null ? sumMatchTerm : new SerializationMatchTerm.SerializationMatchTermInteger(1)));
        }
        for (CardinalityProduct factorProduct : factorSumOfProducts) {
            sumMatchTerm = null;
            for (CardinalityVariable factorTerm : factorProduct.getVariables()) {
                termMatchTerm = new SerializationMatchTerm.SerializationMatchTermVariable(factorTerm.getIndex());
                Object object = sumMatchTerm = sumMatchTerm != null ? new SerializationMatchTerm.SerializationMatchTermMultiply((SerializationMatchTerm)sumMatchTerm, (SerializationMatchTerm)termMatchTerm) : termMatchTerm;
            }
            if (sumMatchTerm == null) continue;
            resultMatchTerm = new SerializationMatchTerm.SerializationMatchTermDivide(resultMatchTerm, (SerializationMatchTerm)sumMatchTerm);
        }
        return resultMatchTerm;
    }

    public boolean generateLinear(@NonNull SerializationRuleAnalysis serializationRuleAnalysis, boolean mayBeMany) {
        CardinalityVariable linearVariable = null;
        GrammarRuleVector grammarRuleVector = null;
        for (CardinalityProduct product : this.sumOfProducts) {
            List<@NonNull CardinalityVariable> unknownVariables = this.getUnknownVariables(serializationRuleAnalysis, product);
            if (unknownVariables == null) continue;
            if (unknownVariables.size() > 1) {
                return false;
            }
            CardinalityVariable unknownVariable = (CardinalityVariable)SerializationUtils.nonNullState((Object)unknownVariables.get(0));
            if (linearVariable == null) {
                linearVariable = unknownVariable;
                grammarRuleVector = product.getGrammarRuleVector();
                continue;
            }
            if (linearVariable == unknownVariable) continue;
            return false;
        }
        if (grammarRuleVector == null) {
            grammarRuleVector = this.sumOfProducts.get(0).getGrammarRuleVector();
        }
        assert (grammarRuleVector != null);
        SerializationMatchTerm resultsMatchTerm = this.createMatchTerm(serializationRuleAnalysis, linearVariable, mayBeMany, grammarRuleVector);
        serializationRuleAnalysis.addMatchTerm(linearVariable, resultsMatchTerm);
        return true;
    }

    public boolean generateMayBeZeroCommonFactors(@NonNull SerializationRuleAnalysis serializationRuleAnalysis, boolean mayBeMany) {
        Set<@NonNull CardinalityVariable> intersection = this.getUnknownCommonVariables(serializationRuleAnalysis, this.sumOfProducts);
        if (intersection != null) {
            ArrayList<@NonNull CardinalityVariable> intersectionList = new ArrayList<CardinalityVariable>(intersection);
            Collections.sort(intersectionList, SerializationUtils.INDEXED_COMPARATOR);
            for (CardinalityVariable cardinalityVariable : intersectionList) {
                if (!mayBeMany) continue;
                SerializationMatchTerm solution = this.createSizeCardinalityMatchTerm();
                solution = new SerializationMatchTerm.SerializationMatchTermGreaterThan(solution, (SerializationMatchTerm)new SerializationMatchTerm.SerializationMatchTermInteger(0));
                serializationRuleAnalysis.addMatchTerm(cardinalityVariable, solution);
                return true;
            }
        }
        return false;
    }

    public boolean generateRedundantProducts(@NonNull SerializationRuleAnalysis serializationRuleAnalysis) {
        Set<@NonNull CardinalityVariable> intersection = this.computeUnsolvedCommonFactors(serializationRuleAnalysis);
        if (intersection != null) {
            return false;
        }
        CardinalityProduct manyProducts = null;
        CardinalityVariable manyVariable = null;
        for (CardinalityProduct products : this.sumOfProducts) {
            boolean mayBeNone = false;
            for (CardinalityVariable variable : products.getVariables()) {
                if (variable.mayBeNone()) {
                    mayBeNone = true;
                }
                if (manyVariable != null || !variable.mayBeMany()) continue;
                manyVariable = variable;
                manyProducts = products;
            }
            if (mayBeNone) continue;
            return false;
        }
        for (CardinalityProduct products : this.sumOfProducts) {
            ArrayList<@NonNull CardinalityVariable> variableList = new ArrayList<CardinalityVariable>(products.getVariables());
            Collections.sort(variableList, SerializationUtils.INDEXED_COMPARATOR);
            for (CardinalityVariable variable : variableList) {
                SerializationMatchTerm solution;
                if (serializationRuleAnalysis.basicGetMatchTerm(variable) != null) continue;
                if (products != manyProducts) {
                    serializationRuleAnalysis.addMatchTerm(variable, (SerializationMatchTerm)new SerializationMatchTerm.SerializationMatchTermInteger(0));
                    continue;
                }
                if (variable == manyVariable) {
                    solution = this.createSizeCardinalityMatchTerm();
                    serializationRuleAnalysis.addMatchTerm(variable, solution);
                    continue;
                }
                solution = this.createSizeCardinalityMatchTerm();
                solution = new SerializationMatchTerm.SerializationMatchTermGreaterThan(solution, (SerializationMatchTerm)new SerializationMatchTerm.SerializationMatchTermInteger(0));
                serializationRuleAnalysis.addMatchTerm(variable, solution);
            }
        }
        return true;
    }

    public @NonNull CardinalityExpression getCardinalityExpression(@NonNull GrammarAnalysis grammarAnalysis, @NonNull EnumerationValue enumerationValue) {
        throw new IllegalStateException();
    }

    public @NonNull CardinalityExpression getCardinalityExpression(@NonNull GrammarAnalysis grammarAnalysis, @NonNull GrammarRuleVector grammarRuleVector) {
        throw new IllegalStateException();
    }

    public abstract @Nullable Iterable<@NonNull CardinalityExpression> getCardinalityExpressions();

    public abstract @NonNull EStructuralFeature getEStructuralFeature();

    protected @Nullable Set<@NonNull CardinalityVariable> getKnownCommonVariables(@NonNull SerializationRuleAnalysis serializationRuleAnalysis, @NonNull Iterable<? extends @NonNull CardinalityProduct> sumOfProducts2) {
        HashSet<@NonNull CardinalityVariable> intersection = null;
        for (CardinalityProduct cardinalityProduct : sumOfProducts2) {
            List<@NonNull CardinalityVariable> knownVariables = this.getKnownVariables(serializationRuleAnalysis, cardinalityProduct);
            if (knownVariables == null) {
                return null;
            }
            if (intersection == null) {
                intersection = new HashSet<CardinalityVariable>(knownVariables);
                continue;
            }
            intersection.retainAll(knownVariables);
            if (!intersection.isEmpty()) continue;
            return null;
        }
        return intersection;
    }

    protected @Nullable List<@NonNull CardinalityVariable> getKnownVariables(@NonNull SerializationRuleAnalysis serializationRuleAnalysis, @NonNull CardinalityProduct product) {
        ArrayList<@NonNull CardinalityVariable> knownVariables = null;
        for (CardinalityVariable variable : product.getVariables()) {
            SerializationMatchTerm solution = serializationRuleAnalysis.basicGetMatchTerm(variable);
            if (solution == null) continue;
            if (knownVariables == null) {
                knownVariables = new ArrayList<CardinalityVariable>();
            }
            if (knownVariables.contains(variable)) {
                return null;
            }
            knownVariables.add(variable);
        }
        return knownVariables;
    }

    public @NonNull String getName() {
        return this.name;
    }

    protected @Nullable Set<@NonNull CardinalityVariable> getUnknownCommonVariables(@NonNull SerializationRuleAnalysis serializationRuleAnalysis, @NonNull Iterable<? extends @NonNull CardinalityProduct> sumOfProducts2) {
        HashSet<@NonNull CardinalityVariable> intersection = null;
        for (CardinalityProduct cardinalityProduct : sumOfProducts2) {
            List<@NonNull CardinalityVariable> unknownVariables = this.getUnknownVariables(serializationRuleAnalysis, cardinalityProduct);
            if (unknownVariables == null) {
                return null;
            }
            if (intersection == null) {
                intersection = new HashSet<CardinalityVariable>(unknownVariables);
                continue;
            }
            intersection.retainAll(unknownVariables);
            if (!intersection.isEmpty()) continue;
            return null;
        }
        return intersection;
    }

    public @Nullable List<@NonNull CardinalityVariable> getUnknownVariables(@NonNull SerializationRuleAnalysis serializationRuleAnalysis) {
        ArrayList<@NonNull CardinalityVariable> unknownVariables = null;
        for (CardinalityProduct products : this.sumOfProducts) {
            for (CardinalityVariable variable : products.getVariables()) {
                SerializationMatchTerm solution = serializationRuleAnalysis.basicGetMatchTerm(variable);
                if (solution != null) continue;
                if (unknownVariables == null) {
                    unknownVariables = new ArrayList<CardinalityVariable>();
                }
                if (unknownVariables.contains(variable)) {
                    return null;
                }
                unknownVariables.add(variable);
            }
        }
        return unknownVariables;
    }

    public @Nullable List<@NonNull CardinalityVariable> getUnknownVariables(@NonNull SerializationRuleAnalysis serializationRuleAnalysis, @NonNull CardinalityProduct product) {
        ArrayList<@NonNull CardinalityVariable> unknownVariables = null;
        for (CardinalityVariable variable : product.getVariables()) {
            SerializationMatchTerm solution = serializationRuleAnalysis.basicGetMatchTerm(variable);
            if (solution != null) continue;
            if (unknownVariables == null) {
                unknownVariables = new ArrayList<CardinalityVariable>();
            }
            if (unknownVariables.contains(variable)) {
                return null;
            }
            unknownVariables.add(variable);
        }
        return unknownVariables;
    }

    public boolean isOne() {
        return this.sumOfProducts.size() == 1 && this.sumOfProducts.get(0).size() == 0;
    }

    public boolean isOrderedAndHeterogeneous() {
        EStructuralFeature eStructuralFeature;
        HashMap<@NonNull CardinalityVariable, @NonNull HashSet<@NonNull Integer>> variablesToRuleIndexes = new HashMap<CardinalityVariable, HashSet<Integer>>();
        int nonConstantProducts = 0;
        for (CardinalityProduct product : this.sumOfProducts) {
            List<@NonNull CardinalityVariable> variables = product.getVariables();
            if (variables.size() != 1) continue;
            ++nonConstantProducts;
            for (CardinalityVariable variable : variables) {
                HashSet<@NonNull Integer> ruleIndexes = (HashSet<Integer>)SerializationUtils.maybeNull((Object)((Set)variablesToRuleIndexes.get(variable)));
                if (ruleIndexes == null) {
                    ruleIndexes = new HashSet<Integer>();
                    variablesToRuleIndexes.put(variable, ruleIndexes);
                }
                ruleIndexes.add(variable.getIndex());
            }
        }
        if (nonConstantProducts > 1 && variablesToRuleIndexes.size() > 1) {
            boolean allUnity = true;
            for (Set ruleIndexes : variablesToRuleIndexes.values()) {
                if (ruleIndexes.size() == 1) continue;
                allUnity = false;
                break;
            }
            if (allUnity) {
                return true;
            }
        }
        if (!(eStructuralFeature = this.getEStructuralFeature()).isMany()) {
            return false;
        }
        if (!eStructuralFeature.isOrdered()) {
            return false;
        }
        if (this.sumOfProducts.size() <= 1) {
            return false;
        }
        GrammarRuleVector homogeneousGrammarRuleVector = null;
        for (CardinalityProduct cardinalityProduct : this.sumOfProducts) {
            GrammarRuleVector grammarRuleVector = cardinalityProduct.getGrammarRuleVector();
            if (homogeneousGrammarRuleVector == null) {
                homogeneousGrammarRuleVector = grammarRuleVector;
                continue;
            }
            if (homogeneousGrammarRuleVector.equals((Object)grammarRuleVector)) continue;
            homogeneousGrammarRuleVector = null;
            break;
        }
        return homogeneousGrammarRuleVector == null;
    }

    public Object resolveProduct(@NonNull SerializationRuleAnalysis serializationRuleAnalysis, @NonNull CardinalityProduct product) {
        HashSet<@NonNull CardinalityVariable> productVariables = null;
        int constantProduct = 1;
        for (CardinalityVariable variable : product.getVariables()) {
            Integer integerSolution = serializationRuleAnalysis.basicGetIntegerSolution(variable.getIndex());
            if (integerSolution != null) {
                constantProduct *= integerSolution.intValue();
                continue;
            }
            if (productVariables == null) {
                productVariables = new HashSet<CardinalityVariable>();
            }
            productVariables.add(variable);
        }
        if (productVariables != null) {
            return productVariables;
        }
        return constantProduct;
    }

    public int solve(@NonNull DynamicRuleMatch dynamicRuleMatch) {
        int sum = 0;
        for (CardinalityProduct products : this.sumOfProducts) {
            int product = 1;
            for (CardinalityVariable variable : products.getVariables()) {
                Integer value = dynamicRuleMatch.basicGetIntegerSolution(variable.getIndex());
                int intValue = value != null ? value : 1;
                product *= intValue;
            }
            sum += product;
        }
        return sum;
    }

    public void solveAtRuntime(@NonNull SerializationRule serializationRule) {
    }

    public @NonNull String toString() {
        DiagnosticStringBuilder s = new DiagnosticStringBuilder();
        this.toString(s);
        return s.toString();
    }

    public abstract void toString(@NonNull DiagnosticStringBuilder var1);

    public static class CardinalityProduct {
        private final @NonNull List<@NonNull CardinalityVariable> variables;
        private final @NonNull GrammarRuleVector grammarRuleVector;

        public CardinalityProduct(@NonNull List<@NonNull CardinalityVariable> variables, @NonNull GrammarRuleVector grammarRuleVector) {
            this.variables = variables;
            this.grammarRuleVector = grammarRuleVector;
        }

        public @NonNull GrammarRuleVector getGrammarRuleVector() {
            return this.grammarRuleVector;
        }

        public @NonNull List<@NonNull CardinalityVariable> getVariables() {
            return this.variables;
        }

        public @NonNull String toString() {
            DiagnosticStringBuilder s = new DiagnosticStringBuilder();
            this.toString(s);
            return s.toString();
        }

        public void toString(@NonNull DiagnosticStringBuilder s) {
            boolean gotOne = false;
            boolean isFirst = true;
            for (CardinalityVariable variable : this.variables) {
                if (variable.isOne()) continue;
                if (!isFirst) {
                    s.append(" * ");
                }
                assert (!variable.isOne());
                s.appendVariableName(variable.getIndex());
                gotOne = true;
                isFirst = false;
            }
            if (!gotOne) {
                s.append("1");
            }
            s.append(":");
            s.append("{");
            this.grammarRuleVector.toString(s);
            s.append("}");
        }

        public int size() {
            return this.variables.size();
        }
    }

    public static class EAttributeCardinalityExpression
    extends CardinalityExpression {
        protected final @NonNull EAttribute eAttribute;
        protected final @Nullable EnumerationValue enumerationValue;
        private final @NonNull Map<@NonNull EnumerationValue, @NonNull CardinalityExpression> enumerationValue2cardinalityExpression = new HashMap<EnumerationValue, CardinalityExpression>();

        public EAttributeCardinalityExpression(@NonNull String name, @NonNull EAttribute eAttribute) {
            super(name);
            assert (eAttribute != null);
            this.eAttribute = eAttribute;
            this.enumerationValue = null;
        }

        private EAttributeCardinalityExpression(@NonNull EAttributeCardinalityExpression parentCardinalityExpression, @NonNull EnumerationValue enumerationValue) {
            super(String.valueOf(parentCardinalityExpression.name) + "." + parentCardinalityExpression.enumerationValue2cardinalityExpression.size());
            this.eAttribute = parentCardinalityExpression.eAttribute;
            this.enumerationValue = enumerationValue;
        }

        protected // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SerializationMatchTerm.SerializationMatchTermEAttributeSize createSizeCardinalityMatchTerm() {
            assert (this.enumerationValue != null);
            return new SerializationMatchTerm.SerializationMatchTermEAttributeSize(this.eAttribute, this.enumerationValue);
        }

        @Override
        public @NonNull CardinalityExpression getCardinalityExpression(@NonNull GrammarAnalysis grammarAnalysis, @NonNull EnumerationValue enumerationValue) {
            assert (this.enumerationValue == null);
            CardinalityExpression cardinalityExpression = (CardinalityExpression)SerializationUtils.maybeNull((Object)this.enumerationValue2cardinalityExpression.get(enumerationValue));
            if (cardinalityExpression == null) {
                grammarAnalysis.addEnumeration(this.eAttribute, enumerationValue);
                cardinalityExpression = new EAttributeCardinalityExpression(this, enumerationValue);
                this.enumerationValue2cardinalityExpression.put(enumerationValue, cardinalityExpression);
            }
            return cardinalityExpression;
        }

        @Override
        public @Nullable Iterable<@NonNull CardinalityExpression> getCardinalityExpressions() {
            return this.enumerationValue2cardinalityExpression.values();
        }

        public @NonNull EAttribute getEAttribute() {
            return this.eAttribute;
        }

        public @NonNull EAttribute getEStructuralFeature() {
            return this.eAttribute;
        }

        public @NonNull EnumerationValue getEnumerationValue() {
            assert (this.enumerationValue != null);
            return this.enumerationValue;
        }

        public @Nullable Map<@NonNull EnumerationValue, @NonNull CardinalityExpression> getEnumerationValue2cardinalityExpression() {
            return this.enumerationValue2cardinalityExpression;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append(this.name);
            s.append(": |");
            s.append(SerializationUtils.getName((ENamedElement)this.eAttribute));
            EnumerationValue enumerationValue2 = this.enumerationValue;
            if (enumerationValue2 != null) {
                s.append(".'");
                s.append(enumerationValue2.getName());
                s.append("'");
            }
            s.append("| = ");
            this.appendSumOfProducts(s);
            ArrayList<@NonNull CardinalityExpression> sortedExpressions = new ArrayList<CardinalityExpression>(this.enumerationValue2cardinalityExpression.values());
            Collections.sort(sortedExpressions, SerializationUtils.NAMEABLE_COMPARATOR);
            for (CardinalityExpression cardinalityExpression : sortedExpressions) {
                cardinalityExpression.toString(s);
            }
        }
    }

    public static class EReferenceCardinalityExpression
    extends CardinalityExpression {
        protected final @NonNull EReference eReference;
        protected final @NonNull GrammarRuleVector grammarRuleVector;
        private @NonNull Map<@NonNull GrammarRuleVector, @NonNull CardinalityExpression> grammarRuleVector2cardinalityExpression = new HashMap<GrammarRuleVector, CardinalityExpression>();

        private EReferenceCardinalityExpression(@NonNull String name, @NonNull EReference eReference, @NonNull GrammarRuleVector grammarRuleVector) {
            super(name);
            this.eReference = eReference;
            this.grammarRuleVector = grammarRuleVector;
        }

        protected // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SerializationMatchTerm.SerializationMatchTermEReferenceSize createSizeCardinalityMatchTerm() {
            return new SerializationMatchTerm.SerializationMatchTermEReferenceSize(this.eReference, this.grammarRuleVector);
        }

        @Override
        public @NonNull CardinalityExpression getCardinalityExpression(@NonNull GrammarAnalysis grammarAnalysis, @NonNull GrammarRuleVector grammarRuleVector) {
            CardinalityExpression cardinalityExpression = (CardinalityExpression)SerializationUtils.maybeNull((Object)this.grammarRuleVector2cardinalityExpression.get(grammarRuleVector));
            if (cardinalityExpression == null) {
                String subName = String.valueOf(this.name) + "." + this.grammarRuleVector2cardinalityExpression.size();
                cardinalityExpression = new EReferenceCardinalityExpression(subName, this.eReference, grammarRuleVector);
                this.grammarRuleVector2cardinalityExpression.put(grammarRuleVector, cardinalityExpression);
            }
            return cardinalityExpression;
        }

        @Override
        public @Nullable Iterable<@NonNull CardinalityExpression> getCardinalityExpressions() {
            return this.grammarRuleVector2cardinalityExpression.values();
        }

        public @NonNull EReference getEReference() {
            return this.eReference;
        }

        public @NonNull EReference getEStructuralFeature() {
            return this.eReference;
        }

        public @NonNull GrammarRuleVector getGrammarRuleVector() {
            assert (this.grammarRuleVector != null);
            return this.grammarRuleVector;
        }

        public @Nullable Map<@NonNull GrammarRuleVector, @NonNull CardinalityExpression> getGrammarRuleVector2cardinalityExpression() {
            return this.grammarRuleVector2cardinalityExpression;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append(this.name);
            s.append(": |");
            s.append(SerializationUtils.getName((ENamedElement)this.eReference));
            s.append(":{");
            this.grammarRuleVector.toString(s);
            s.append("}| = ");
            this.appendSumOfProducts(s);
            ArrayList<@NonNull CardinalityExpression> sortedExpressions = new ArrayList<CardinalityExpression>(this.grammarRuleVector2cardinalityExpression.values());
            Collections.sort(sortedExpressions, SerializationUtils.NAMEABLE_COMPARATOR);
            for (CardinalityExpression cardinalityExpression : sortedExpressions) {
                cardinalityExpression.toString(s);
            }
        }
    }

    public static class EStructuralFeatureCardinalityExpression
    extends CardinalityExpression {
        protected final @NonNull EStructuralFeature eStructuralFeature;

        public EStructuralFeatureCardinalityExpression(@NonNull String name, @NonNull EStructuralFeature eStructuralFeature) {
            super(name);
            this.eStructuralFeature = eStructuralFeature;
        }

        protected // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SerializationMatchTerm.SerializationMatchTermEStructuralFeatureSize createSizeCardinalityMatchTerm() {
            return new SerializationMatchTerm.SerializationMatchTermEStructuralFeatureSize(this.eStructuralFeature);
        }

        @Override
        public @Nullable Iterable<@NonNull CardinalityExpression> getCardinalityExpressions() {
            return null;
        }

        @Override
        public @NonNull EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append(this.name);
            s.append(": |");
            s.append(SerializationUtils.getName((ENamedElement)this.eStructuralFeature));
            s.append("| = ");
            this.appendSumOfProducts(s);
        }
    }
}

