/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.idioms.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.idioms.EPackageImport;
import org.eclipse.ocl.examples.xtext.idioms.Idiom;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsImport;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsModel;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsPackage;
import org.eclipse.ocl.examples.xtext.idioms.LocatorDeclaration;
import org.eclipse.ocl.examples.xtext.idioms.SegmentDeclaration;
import org.eclipse.ocl.examples.xtext.idioms.impl.IdiomsElementImpl;

public class IdiomsModelImpl
extends IdiomsElementImpl
implements IdiomsModel {
    public static final int IDIOMS_MODEL_FEATURE_COUNT = 7;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<String> names;
    protected EList<Idiom> ownedIdioms;
    protected EList<EPackageImport> ownedImports;
    protected EList<LocatorDeclaration> ownedLocatorDeclarations;
    protected EList<SegmentDeclaration> ownedSegmentDeclarations;
    protected EList<IdiomsImport> ownedWiths;
    private @Nullable List<@NonNull IdiomsModel> idiomsModels = null;

    protected IdiomsModelImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return IdiomsPackage.Literals.IDIOMS_MODEL;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            StringBuilder s = new StringBuilder();
            for (String n : this.names) {
                if (s.length() > 0) {
                    s.append(".");
                }
                s.append(n);
            }
            this.name = s.toString();
        }
        return this.name;
    }

    @Override
    public EList<String> getNames() {
        if (this.names == null) {
            this.names = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 1);
        }
        return this.names;
    }

    @Override
    public EList<EPackageImport> getOwnedImports() {
        if (this.ownedImports == null) {
            this.ownedImports = new EObjectContainmentEList(EPackageImport.class, (InternalEObject)this, 3);
        }
        return this.ownedImports;
    }

    @Override
    public EList<LocatorDeclaration> getOwnedLocatorDeclarations() {
        if (this.ownedLocatorDeclarations == null) {
            this.ownedLocatorDeclarations = new EObjectContainmentWithInverseEList(LocatorDeclaration.class, (InternalEObject)this, 4, 2);
        }
        return this.ownedLocatorDeclarations;
    }

    @Override
    public EList<SegmentDeclaration> getOwnedSegmentDeclarations() {
        if (this.ownedSegmentDeclarations == null) {
            this.ownedSegmentDeclarations = new EObjectContainmentWithInverseEList(SegmentDeclaration.class, (InternalEObject)this, 5, 2);
        }
        return this.ownedSegmentDeclarations;
    }

    @Override
    public EList<Idiom> getOwnedIdioms() {
        if (this.ownedIdioms == null) {
            this.ownedIdioms = new EObjectContainmentEList(Idiom.class, (InternalEObject)this, 2);
        }
        return this.ownedIdioms;
    }

    @Override
    public EList<IdiomsImport> getOwnedWiths() {
        if (this.ownedWiths == null) {
            this.ownedWiths = new EObjectContainmentEList(IdiomsImport.class, (InternalEObject)this, 6);
        }
        return this.ownedWiths;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getOwnedLocatorDeclarations()).basicAdd((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getOwnedSegmentDeclarations()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getOwnedIdioms()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getOwnedImports()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getOwnedLocatorDeclarations()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getOwnedSegmentDeclarations()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getOwnedWiths()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getNames();
            }
            case 2: {
                return this.getOwnedIdioms();
            }
            case 3: {
                return this.getOwnedImports();
            }
            case 4: {
                return this.getOwnedLocatorDeclarations();
            }
            case 5: {
                return this.getOwnedSegmentDeclarations();
            }
            case 6: {
                return this.getOwnedWiths();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getNames().clear();
                this.getNames().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedIdioms().clear();
                this.getOwnedIdioms().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedImports().clear();
                this.getOwnedImports().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getOwnedLocatorDeclarations().clear();
                this.getOwnedLocatorDeclarations().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getOwnedSegmentDeclarations().clear();
                this.getOwnedSegmentDeclarations().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getOwnedWiths().clear();
                this.getOwnedWiths().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getNames().clear();
                return;
            }
            case 2: {
                this.getOwnedIdioms().clear();
                return;
            }
            case 3: {
                this.getOwnedImports().clear();
                return;
            }
            case 4: {
                this.getOwnedLocatorDeclarations().clear();
                return;
            }
            case 5: {
                this.getOwnedSegmentDeclarations().clear();
                return;
            }
            case 6: {
                this.getOwnedWiths().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return this.names != null && !this.names.isEmpty();
            }
            case 2: {
                return this.ownedIdioms != null && !this.ownedIdioms.isEmpty();
            }
            case 3: {
                return this.ownedImports != null && !this.ownedImports.isEmpty();
            }
            case 4: {
                return this.ownedLocatorDeclarations != null && !this.ownedLocatorDeclarations.isEmpty();
            }
            case 5: {
                return this.ownedSegmentDeclarations != null && !this.ownedSegmentDeclarations.isEmpty();
            }
            case 6: {
                return this.ownedWiths != null && !this.ownedWiths.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", names: ");
        result.append(this.names);
        result.append(')');
        return result.toString();
    }

    @Override
    public IdiomsModel getIdiomsModel(@Nullable String name) {
        if (name != null) {
            for (IdiomsModel idiomsModel : this.getIdiomsModels()) {
                if (!name.equals(idiomsModel.getName())) continue;
                return idiomsModel;
            }
        }
        return null;
    }

    @Override
    public @NonNull Iterable<@NonNull IdiomsModel> getIdiomsModels() {
        List<@NonNull IdiomsModel> idiomsModels2 = this.idiomsModels;
        if (idiomsModels2 == null) {
            this.idiomsModels = idiomsModels2 = new ArrayList<IdiomsModel>();
            idiomsModels2.add(this);
            this.gatherIdiomsModels(this, idiomsModels2);
        }
        return idiomsModels2;
    }

    private void gatherIdiomsModels(@NonNull IdiomsModel idiomsModel, @NonNull List<@NonNull IdiomsModel> idiomsModels) {
        for (IdiomsImport idiomsImport : idiomsModel.getOwnedWiths()) {
            IdiomsModel importedIdiomsModel = idiomsImport.getIdiomsModel();
            assert (importedIdiomsModel != null);
            if (idiomsModels.contains(importedIdiomsModel)) continue;
            idiomsModels.add(importedIdiomsModel);
            this.gatherIdiomsModels(importedIdiomsModel, idiomsModels);
        }
    }

    @Override
    public LocatorDeclaration getOwnedLocator(@Nullable String name) {
        if (name != null) {
            for (LocatorDeclaration locator : this.getOwnedLocatorDeclarations()) {
                if (!name.equals(locator.getName())) continue;
                return locator;
            }
        }
        return null;
    }

    @Override
    public SegmentDeclaration getOwnedSegment(@Nullable String name) {
        if (name != null) {
            for (SegmentDeclaration segment : this.getOwnedSegmentDeclarations()) {
                if (!name.equals(segment.getName())) continue;
                return segment;
            }
        }
        return null;
    }
}

