/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.uml.ExpressionInOCL;
import org.eclipse.ocl.uml.UMLEnvironment;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;

public class OCLDocumentTest
extends AbstractTestSuite {
    private Package instancePackage;
    private Map<String, Constraint> constraints;

    public void test_multipleInvariants() {
        Constraint notBlack = this.getConstraint("not_black");
        Constraint notFoo = this.getConstraint("not_foo");
        this.assertMatchingContextVariables((Classifier)this.fruit, notBlack);
        this.assertMatchingContextVariables((Classifier)this.fruit, notFoo);
        InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anApple, this.fruit_color, this.color_black);
        this.setValue(anApple, this.apple_label, "Foo");
        OCLDocumentTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)notFoo));
        OCLDocumentTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)notBlack));
        this.setValue(anApple, this.fruit_color, this.color_red);
        this.setValue(anApple, this.apple_label, "Bar");
        OCLDocumentTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)notFoo));
        OCLDocumentTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)notBlack));
    }

    public void test_multipleDefExpressions() {
        this.assertMatchingContextVariables((Classifier)this.fruit, this.getConstraint("property_helper"));
        this.assertMatchingContextVariables((Classifier)this.fruit, this.getConstraint("operation_helper"));
        InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anApple, this.fruit_color, this.color_black);
        this.setValue(anApple, this.apple_label, "Foo");
        InstanceSpecification anotherApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anotherApple, this.fruit_color, this.color_red);
        this.setValue(anotherApple, this.apple_label, "Bar");
        HashSet<InstanceSpecification> apples = new HashSet<InstanceSpecification>();
        apples.add(anApple);
        apples.add(anotherApple);
        HashMap<Class, HashSet<InstanceSpecification>> extentMap = new HashMap<Class, HashSet<InstanceSpecification>>();
        extentMap.put(this.apple, apples);
        extentMap.put(this.fruit, apples);
        this.ocl.setExtentMap(extentMap);
        this.helper = this.ocl.createOCLHelper();
        this.helper.setContext((Object)this.apple);
        try {
            Object value = this.evaluate(this.helper, anApple, "self.otherFruits");
            OCLDocumentTest.assertEquals(Collections.singleton(anotherApple), (Object)value);
            value = this.evaluate(this.helper, anotherApple, "self.getOtherFruits(false)");
            OCLDocumentTest.assertEquals(Collections.singleton(anApple), (Object)value);
        }
        catch (ParserException e) {
            OCLDocumentTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_multipleInvariantsAndDefExpressions() {
        Constraint notBlack = this.getConstraint("not_black1");
        Constraint notFoo = this.getConstraint("not_foo1");
        this.assertMatchingContextVariables((Classifier)this.fruit, notBlack);
        this.assertMatchingContextVariables((Classifier)this.fruit, notFoo);
        this.assertMatchingContextVariables((Classifier)this.fruit, this.getConstraint("property_helper"));
        this.assertMatchingContextVariables((Classifier)this.fruit, this.getConstraint("operation_helper"));
        InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anApple, this.fruit_color, this.color_black);
        this.setValue(anApple, this.apple_label, "Foo");
        OCLDocumentTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)notFoo));
        OCLDocumentTest.assertFalse((boolean)this.ocl.check((Object)anApple, (Object)notBlack));
        this.setValue(anApple, this.fruit_color, this.color_red);
        this.setValue(anApple, this.apple_label, "Bar");
        OCLDocumentTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)notFoo));
        OCLDocumentTest.assertTrue((boolean)this.ocl.check((Object)anApple, (Object)notBlack));
        this.setValue(anApple, this.fruit_color, this.color_black);
        this.setValue(anApple, this.apple_label, "Foo");
        InstanceSpecification anotherApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
        this.setValue(anotherApple, this.fruit_color, this.color_red);
        this.setValue(anotherApple, this.apple_label, "Bar");
        HashSet<InstanceSpecification> apples = new HashSet<InstanceSpecification>();
        apples.add(anApple);
        apples.add(anotherApple);
        HashMap<Class, HashSet<InstanceSpecification>> extentMap = new HashMap<Class, HashSet<InstanceSpecification>>();
        extentMap.put(this.apple, apples);
        extentMap.put(this.fruit, apples);
        this.ocl.setExtentMap(extentMap);
        this.helper = this.ocl.createOCLHelper();
        this.helper.setContext((Object)this.apple);
        try {
            Object value = this.evaluate(this.helper, anApple, "self.otherFruits1");
            OCLDocumentTest.assertEquals(Collections.singleton(anotherApple), (Object)value);
            value = this.evaluate(this.helper, anotherApple, "self.getOtherFruits1(false)");
            OCLDocumentTest.assertEquals(Collections.singleton(anApple), (Object)value);
        }
        catch (ParserException e) {
            OCLDocumentTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    public void test_multipleMixedOperationConstraints() {
        Constraint textNotNull = this.getConstraint("text_not_null");
        Constraint textNotLabel = this.getConstraint("text_not_label");
        Constraint labelIsChanged = this.getConstraint("label_is_changed");
        Constraint labelIsSet = this.getConstraint("label_is_set");
        OCLDocumentTest.assertEquals((int)1, (int)textNotNull.getConstrainedElements().size());
        Operation oper = (Operation)textNotNull.getConstrainedElements().get(0);
        OCLDocumentTest.assertNotNull((Object)oper);
        OCLDocumentTest.assertTrue((boolean)textNotNull.getKeywords().contains((Object)"precondition"));
        OCLDocumentTest.assertNotNull((Object)this.getBodyExpression(textNotNull));
        this.assertMatchingContextVariables(oper, textNotNull);
        OCLDocumentTest.assertEquals((int)1, (int)textNotLabel.getConstrainedElements().size());
        OCLDocumentTest.assertSame((Object)oper, (Object)textNotLabel.getConstrainedElements().get(0));
        OCLDocumentTest.assertTrue((boolean)textNotLabel.getKeywords().contains((Object)"precondition"));
        OCLDocumentTest.assertNotNull((Object)this.getBodyExpression(textNotLabel));
        this.assertMatchingContextVariables(oper, textNotLabel);
        OCLDocumentTest.assertEquals((int)1, (int)labelIsChanged.getConstrainedElements().size());
        OCLDocumentTest.assertSame((Object)oper, (Object)labelIsChanged.getConstrainedElements().get(0));
        OCLDocumentTest.assertTrue((boolean)labelIsChanged.getKeywords().contains((Object)"postcondition"));
        OCLDocumentTest.assertNotNull((Object)this.getBodyExpression(labelIsChanged));
        this.assertMatchingContextVariables(oper, labelIsChanged);
        OCLDocumentTest.assertEquals((int)1, (int)labelIsSet.getConstrainedElements().size());
        OCLDocumentTest.assertSame((Object)oper, (Object)labelIsSet.getConstrainedElements().get(0));
        OCLDocumentTest.assertTrue((boolean)labelIsSet.getKeywords().contains((Object)"postcondition"));
        OCLDocumentTest.assertNotNull((Object)this.getBodyExpression(labelIsSet));
        this.assertMatchingContextVariables(oper, labelIsSet);
    }

    public void test_initAndDerConstraints() {
        this.helper.setContext((Object)this.apple);
        try {
            InstanceSpecification anApple = this.instantiate(this.instancePackage, (Classifier)this.apple);
            this.setValue(anApple, this.apple_label, "Foo");
            OCLDocumentTest.assertEquals((Object)"Foo", (Object)this.evaluate(this.helper, anApple, "self.name"));
            this.clearValue(anApple, this.apple_label);
            OCLDocumentTest.assertEquals((Object)"", (Object)this.evaluate(this.helper, anApple, "self.name"));
        }
        catch (ParserException e) {
            OCLDocumentTest.fail((String)("Failed to parse or evaluate: " + e.getLocalizedMessage()));
        }
    }

    protected void setUp() {
        super.setUp();
        this.instancePackage = umlf.createPackage();
        this.constraints = new HashMap<String, Constraint>();
        URI uri = this.getTestModelURI("/model/test_constraints.ocl");
        try {
            InputStream is = resourceSet.getURIConverter().createInputStream(uri);
            List parsed = this.ocl.parse(new OCLInput(is));
            is.close();
            for (Constraint ct : parsed) {
                this.validate(ct);
                this.constraints.put(ct.getName(), ct);
            }
        }
        catch (Exception e) {
            OCLDocumentTest.fail((String)("Failed to parse " + uri + " : " + e.getMessage()));
        }
    }

    public void tearDown_constraints() throws Exception {
        this.unload(this.constraints.values());
        this.constraints = null;
    }

    public void tearDown_instancePackage() throws Exception {
        this.unload((EObject)this.instancePackage);
        this.instancePackage = null;
    }

    Constraint getConstraint(String name) {
        Constraint result = this.constraints.get(name);
        OCLDocumentTest.assertNotNull((String)("Did not find constraint " + name), (Object)result);
        return result;
    }

    void assertMatchingContextVariables(Classifier context, Constraint constraint) {
        ExpressionInOCL spec = (ExpressionInOCL)constraint.getSpecification();
        UMLEnvironment env = (UMLEnvironment)this.ocl.getEnvironment();
        Variable selfVar = spec.getContextVariable();
        OCLDocumentTest.assertNotNull((Object)selfVar);
        OCLDocumentTest.assertEquals((String)"self", (String)selfVar.getName());
        OCLDocumentTest.assertEquals((Object)selfVar.getType(), (Object)env.getUMLReflection().getOCLType((Object)context));
    }

    void assertMatchingContextVariables(Operation operation, Constraint constraint) {
        ExpressionInOCL spec = (ExpressionInOCL)constraint.getSpecification();
        UMLEnvironment env = (UMLEnvironment)this.ocl.getEnvironment();
        if (operation.getClass_() != null) {
            Variable selfVar = spec.getContextVariable();
            OCLDocumentTest.assertNotNull((Object)selfVar);
            OCLDocumentTest.assertEquals((String)"self", (String)selfVar.getName());
            OCLDocumentTest.assertEquals((Object)selfVar.getType(), (Object)env.getUMLReflection().getOCLType((Object)operation.getClass_()));
        }
        if (operation.getType() != null && !constraint.getKeywords().contains((Object)"precondition")) {
            Variable resultVar = spec.getResultVariable();
            OCLDocumentTest.assertNotNull((Object)resultVar);
            OCLDocumentTest.assertEquals((String)"result", (String)resultVar.getName());
            OCLDocumentTest.assertEquals((Object)resultVar.getType(), (Object)env.getUMLReflection().getOCLType((Object)operation));
        }
        BasicEList.FastCompare parms = new BasicEList.FastCompare((Collection)operation.getOwnedParameters());
        Iterator iter = parms.iterator();
        while (iter.hasNext()) {
            if (((Parameter)iter.next()).getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            iter.remove();
        }
        EList vars = spec.getParameterVariable();
        OCLDocumentTest.assertEquals((int)parms.size(), (int)vars.size());
        int i = 0;
        while (i < parms.size()) {
            Variable var = (Variable)vars.get(i);
            Parameter parm = (Parameter)parms.get(i);
            OCLDocumentTest.assertEquals((Object)var.getType(), (Object)env.getUMLReflection().getOCLType((Object)parm));
            ++i;
        }
    }
}

