/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.transformation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.internal.Scheduler;
import org.eclipse.papyrus.uml.m2m.qvto.common.internal.TransformationWrapper;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IDependencyAnalysisHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IImportTransformation;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IImportTransformationLauncher;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractImportTransformationLauncher
implements IImportTransformationLauncher {
    protected static final long SECOND = 1000000000L;
    protected static final long MILLIS = 1000000L;
    protected final ThreadConfig config;
    protected final Control baseControl;
    protected long ownExecutionTime;
    protected long ownLoadingTime;
    protected long ownRepairStereotypesTime;
    protected long ownRepairLibrariesTime;
    protected long resolveAllDependencies;
    protected Job importDependenciesJob;
    protected long transformationsExecutionTime = 0L;
    protected IDependencyAnalysisHelper analysisHelper;
    public static final String IMPORT_MODELS_JOB_NAME = "Import Models";
    protected static final String CONSOLE_NAME = "Model Import Results";
    protected final Map<IImportTransformation, Long> loadingTimeV2 = new HashMap<IImportTransformation, Long>();
    protected final Map<IImportTransformation, Long> proxiesTime = new HashMap<IImportTransformation, Long>();
    protected final Map<IImportTransformation, Long> stereoTime = new HashMap<IImportTransformation, Long>();
    protected final Map<IImportTransformation, Long> totalTimeV2 = new HashMap<IImportTransformation, Long>();

    public AbstractImportTransformationLauncher(ThreadConfig config) {
        this(config, null);
    }

    public AbstractImportTransformationLauncher(ThreadConfig config, Control baseControl) {
        this.config = config;
        this.baseControl = baseControl;
    }

    @Override
    public void run(List<URI> urisToImport) {
        LinkedList<IImportTransformation> transformations = new LinkedList<IImportTransformation>();
        this.analysisHelper = this.createDependencyAnalysisHelper(this.config);
        for (URI uri : urisToImport) {
            IImportTransformation transformation = this.createTransformation(uri, this.config, this.analysisHelper);
            transformations.add(transformation);
        }
        this.importModels(transformations);
    }

    protected abstract IDependencyAnalysisHelper createDependencyAnalysisHelper(ThreadConfig var1);

    protected abstract IImportTransformation createTransformation(URI var1, ThreadConfig var2, IDependencyAnalysisHelper var3);

    protected void importModels(final List<IImportTransformation> transformations) {
        this.importDependenciesJob = new Job(IMPORT_MODELS_JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = AbstractImportTransformationLauncher.this.importModels(monitor, transformations);
                if (monitor.isCanceled()) {
                    return new Status(8, "org.eclipse.papyrus.uml.m2m.qvto.common", "Operation Canceled");
                }
                long cumulatedLoadingTime = 0L;
                long cumulatedTransformationTime = 0L;
                long cumulatedHandleDanglingTime = 0L;
                long cumulatedImportExtensionsTime = 0L;
                for (IImportTransformation transformation : transformations) {
                    cumulatedLoadingTime += transformation.getLoadingTime();
                    cumulatedImportExtensionsTime += transformation.getImportExtensionsTime();
                    cumulatedHandleDanglingTime += transformation.getHandleDanglingRefTime();
                    cumulatedTransformationTime += transformation.getExecutionTime();
                    AbstractImportTransformationLauncher.this.log("Import " + transformation.getModelName());
                    AbstractImportTransformationLauncher.this.log("First phase (0-50%):");
                    AbstractImportTransformationLauncher.this.log("\tTotal loading time: " + AbstractImportTransformationLauncher.this.timeFormat(transformation.getLoadingTime()));
                    AbstractImportTransformationLauncher.this.log("\tTotal Import Extensions time: " + AbstractImportTransformationLauncher.this.timeFormat(transformation.getImportExtensionsTime()));
                    AbstractImportTransformationLauncher.this.log("\tTotal Handle Dangling References time: " + AbstractImportTransformationLauncher.this.timeFormat(transformation.getHandleDanglingRefTime()));
                    AbstractImportTransformationLauncher.this.log("\tTotal execution time: " + AbstractImportTransformationLauncher.this.timeFormat(transformation.getExecutionTime()));
                    Long loadingTime = AbstractImportTransformationLauncher.this.loadingTimeV2.get(transformation);
                    Long repairProxiesTime = AbstractImportTransformationLauncher.this.proxiesTime.get(transformation);
                    Long repairStereoTime = AbstractImportTransformationLauncher.this.stereoTime.get(transformation);
                    Long totalPhase2 = AbstractImportTransformationLauncher.this.totalTimeV2.get(transformation);
                    AbstractImportTransformationLauncher.this.log("Second phase (50-100%):");
                    AbstractImportTransformationLauncher.this.log("\tTotal loading time: " + AbstractImportTransformationLauncher.this.timeFormat(loadingTime));
                    AbstractImportTransformationLauncher.this.log("\tTotal fix proxies time: " + AbstractImportTransformationLauncher.this.timeFormat(repairProxiesTime));
                    AbstractImportTransformationLauncher.this.log("\tTotal fix stereotypes time: " + AbstractImportTransformationLauncher.this.timeFormat(repairStereoTime));
                    AbstractImportTransformationLauncher.this.log("\tTotal execution time: " + AbstractImportTransformationLauncher.this.timeFormat(totalPhase2));
                    AbstractImportTransformationLauncher.this.log("Total");
                    AbstractImportTransformationLauncher.this.log("\tTotal execution time: " + AbstractImportTransformationLauncher.this.timeFormat(transformation.getExecutionTime() + (totalPhase2 == null ? 0L : totalPhase2)));
                    AbstractImportTransformationLauncher.this.log("\n");
                }
                int nbThreads = Math.max(1, AbstractImportTransformationLauncher.this.config.getMaxThreads());
                AbstractImportTransformationLauncher.this.log("First phase (0-50%) / " + nbThreads + " Threads");
                AbstractImportTransformationLauncher.this.log("\tCumulated Transformation Time: " + AbstractImportTransformationLauncher.this.timeFormat(cumulatedTransformationTime));
                AbstractImportTransformationLauncher.this.log("\tCumulated Loading Time: " + AbstractImportTransformationLauncher.this.timeFormat(cumulatedLoadingTime));
                AbstractImportTransformationLauncher.this.log("\tCumulated Handle Dangling Refs Time: " + AbstractImportTransformationLauncher.this.timeFormat(cumulatedHandleDanglingTime));
                AbstractImportTransformationLauncher.this.log("\tCumulated Import Extensions Time: " + AbstractImportTransformationLauncher.this.timeFormat(cumulatedImportExtensionsTime));
                AbstractImportTransformationLauncher.this.log("\tTotal Transformation Time: " + AbstractImportTransformationLauncher.this.timeFormat(AbstractImportTransformationLauncher.this.transformationsExecutionTime));
                AbstractImportTransformationLauncher.this.log("Second phase (50-100%) / " + nbThreads + " Threads");
                AbstractImportTransformationLauncher.this.log("\tTotal Handle all Dangling References: " + AbstractImportTransformationLauncher.this.timeFormat(AbstractImportTransformationLauncher.this.resolveAllDependencies));
                AbstractImportTransformationLauncher.this.log("\tCumulated Loading Time: " + AbstractImportTransformationLauncher.this.timeFormat(AbstractImportTransformationLauncher.this.ownLoadingTime));
                AbstractImportTransformationLauncher.this.log("\tCumulated Fix Libraries Time: " + AbstractImportTransformationLauncher.this.timeFormat(AbstractImportTransformationLauncher.this.ownRepairLibrariesTime));
                AbstractImportTransformationLauncher.this.log("\tCumulated Fix Stereotypes Time: " + AbstractImportTransformationLauncher.this.timeFormat(AbstractImportTransformationLauncher.this.ownRepairStereotypesTime));
                AbstractImportTransformationLauncher.this.log("\tTotal Fix Dependencies Time: " + AbstractImportTransformationLauncher.this.timeFormat(AbstractImportTransformationLauncher.this.ownExecutionTime));
                AbstractImportTransformationLauncher.this.log("Total");
                AbstractImportTransformationLauncher.this.log("\tCumulated Total time: " + AbstractImportTransformationLauncher.this.timeFormat(AbstractImportTransformationLauncher.this.ownExecutionTime + cumulatedTransformationTime));
                AbstractImportTransformationLauncher.this.log("\tTotal time: " + AbstractImportTransformationLauncher.this.timeFormat(AbstractImportTransformationLauncher.this.ownExecutionTime + AbstractImportTransformationLauncher.this.transformationsExecutionTime));
                AbstractImportTransformationLauncher.this.log("Import Complete");
                AbstractImportTransformationLauncher.this.log("");
                return result;
            }
        };
        this.importDependenciesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                String message;
                MultiStatus multiStatus = new MultiStatus("org.eclipse.papyrus.uml.m2m.qvto.common", 0, "", null);
                multiStatus.merge(event.getResult());
                for (IImportTransformation transformation : transformations) {
                    multiStatus.merge(transformation.getStatus());
                }
                int severity = multiStatus.getSeverity();
                switch (severity) {
                    case 0: {
                        message = "The selected models have been successfully imported";
                        break;
                    }
                    case 8: {
                        message = "Operation canceled";
                        break;
                    }
                    case 2: {
                        message = "The selected models have been imported; some warnings have been reported";
                        break;
                    }
                    default: {
                        message = "Some errors occurred during model import";
                    }
                }
                this.handle((IStatus)new MultiStatus("org.eclipse.papyrus.uml.m2m.qvto.common", severity, multiStatus.getChildren(), message, null));
            }

            protected void handle(final IStatus status) {
                if (AbstractImportTransformationLauncher.this.baseControl == null) {
                    int severity = status.getSeverity();
                    if (severity == 0 || severity == 8) {
                        return;
                    }
                    StatusManager.getManager().handle(status, 1);
                    return;
                }
                Display display = AbstractImportTransformationLauncher.this.baseControl.getDisplay();
                if (status.getSeverity() == 0) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)(this).AbstractImportTransformationLauncher.this.baseControl.getShell(), (String)"Import models", (String)status.getMessage());
                        }
                    });
                } else if (status.getSeverity() == 8) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)(this).AbstractImportTransformationLauncher.this.baseControl.getShell(), (String)"Import models", (String)status.getMessage());
                        }
                    });
                } else {
                    StatusManager.getManager().handle(status, 4);
                }
            }
        });
        this.importDependenciesJob.setUser(true);
        this.importDependenciesJob.schedule();
    }

    protected void log(String message) {
        System.out.println(message);
        MessageConsole console = this.getConsole();
        MessageConsoleStream out = console.newMessageStream();
        out.println(message);
    }

    protected MessageConsole getConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        IConsole[] existing = consoleManager.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (CONSOLE_NAME.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole rsaConsole = new MessageConsole(CONSOLE_NAME, null);
        consoleManager.addConsoles(new IConsole[]{rsaConsole});
        return rsaConsole;
    }

    protected String timeFormat(Long nano) {
        if (nano == null) {
            return "?";
        }
        long seconds = nano / 1000000000L;
        if (seconds < 1L) {
            long millis = nano / 1000000L;
            return String.format("%s ms", millis);
        }
        return String.format("%d:%02d:%02d", seconds / 3600L, seconds % 3600L / 60L, seconds % 60L);
    }

    protected IStatus importModels(IProgressMonitor monitor, List<IImportTransformation> transformations) {
        long begin = System.nanoTime();
        monitor.setTaskName("Waiting for import tasks to complete...");
        int numTasks = transformations.size() * 2;
        monitor.beginTask("Importing Models...", numTasks);
        LinkedList<TransformationWrapper> tasks = new LinkedList<TransformationWrapper>();
        for (IImportTransformation transformation : transformations) {
            tasks.add(new TransformationWrapper(transformation));
        }
        Scheduler scheduler = new Scheduler(this.config.getMaxThreads());
        scheduler.schedule(monitor, tasks);
        long end = System.nanoTime();
        this.transformationsExecutionTime = end - begin;
        if (monitor.isCanceled()) {
            return new Status(8, "org.eclipse.papyrus.uml.m2m.qvto.common", "Operation canceled");
        }
        this.handleModelDependencies(transformations, monitor);
        return Status.OK_STATUS;
    }

    protected void handleModelDependencies(List<IImportTransformation> transformations, IProgressMonitor monitor) {
    }

    @Override
    public void waitForCompletion() throws Exception {
        this.importDependenciesJob.join();
    }

    @Override
    public IStatus getResult() {
        return this.importDependenciesJob.getResult();
    }
}

