/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.editorsfactory;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IPageModelFactory;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.editorsfactory.IEditorFactory;

public class PageModelFactoryRegistry
implements IPageModelFactory {
    protected List<IEditorFactory> editorFactories = new ArrayList<IEditorFactory>();

    public IPageModel createIPageModel(Object pageIdentifier) {
        return this.createIPageModel(pageIdentifier, null);
    }

    public IPageModel createIPageModel(Object pageIdentifier, String favoriteEditorID) {
        IEditorFactory factory = this.getFactoryFor(pageIdentifier, favoriteEditorID);
        if (factory == null) {
            return null;
        }
        return factory.createIPageModel(pageIdentifier);
    }

    private IEditorFactory getFactoryFor(Object pageIdentifier, String favoriteEditorID) {
        LinkedList<IEditorFactory> matchingFactories = new LinkedList<IEditorFactory>();
        for (IEditorFactory factory : this.getEditorFactories()) {
            if (!factory.isPageModelFactoryFor(pageIdentifier)) continue;
            matchingFactories.add(factory);
        }
        if (matchingFactories.isEmpty()) {
            return null;
        }
        if (matchingFactories.size() == 1) {
            return (IEditorFactory)matchingFactories.get(0);
        }
        if (favoriteEditorID != null) {
            for (IEditorFactory matchingFactory : matchingFactories) {
                if (!favoriteEditorID.equals(matchingFactory.getFactoryID())) continue;
                return matchingFactory;
            }
        }
        return (IEditorFactory)matchingFactories.get(0);
    }

    public Map<String, String> getEditorIDsFor(Object pageIdentifier) {
        return this.getEditorFactories().stream().filter(f -> f.isPageModelFactoryFor(pageIdentifier)).collect(Collectors.toMap(f -> f.getFactoryID(), f -> f.getLabel(), (v1, v2) -> {
            Activator.log.warn(String.format("Several editors are declared with the same ID: '%s', '%s'", v1, v2));
            return v1;
        }, LinkedHashMap::new));
    }

    protected List<IEditorFactory> getEditorFactories() {
        return this.editorFactories;
    }

    public void add(IEditorFactory editorFactory) {
        if (editorFactory == null) {
            throw new IllegalArgumentException("Parameter should not be null.");
        }
        this.editorFactories.add(editorFactory);
    }

    public void remove(IEditorFactory editorFactory) {
        this.editorFactories.remove(editorFactory);
    }
}

