/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.LinkedList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityNodeHelper
extends ElementEditHelper {
    public static final String IN_PARTITION = "IN_PARTITION";
    public static final String IN_INTERRUPTIBLE_ACTIVITY_REGION = "IN_INTERRUPTIBLE_ACTIVITY_REGION";
    public static final String OUT_FROM_PARTITION = "OUT_FROM_PARTITION";
    public static final String OUT_FROM_INTERRUPTIBLE_REGION = "OUT_FROM_REGION";

    protected ICommand getBasicDestroyElementCommand(DestroyElementRequest req) {
        DestroyElementCommand result = req.getBasicDestroyCommand();
        if (result == null) {
            result = new DestroyActivityOwnedElementCommand(req);
        } else {
            req.setBasicDestroyCommand(null);
        }
        return result;
    }

    @Override
    protected ICommand getConfigureCommand(ConfigureRequest req) {
        if (req.getParameter(IN_PARTITION) != null) {
            return new SetValueCommand(new SetRequest((EObject)req.getParameter(IN_PARTITION), (EStructuralFeature)UMLPackage.eINSTANCE.getActivityPartition_Node(), (Object)req.getElementToConfigure()));
        }
        if (req.getParameter(IN_INTERRUPTIBLE_ACTIVITY_REGION) != null) {
            return new SetValueCommand(new SetRequest((EObject)req.getParameter(IN_INTERRUPTIBLE_ACTIVITY_REGION), (EStructuralFeature)UMLPackage.eINSTANCE.getInterruptibleActivityRegion_Node(), (Object)req.getElementToConfigure()));
        }
        return super.getConfigureCommand(req);
    }

    public static ICommand getMoveOutFromPartitionCommand(MoveRequest req) {
        if (req.getParameter(OUT_FROM_PARTITION) != null) {
            CompositeCommand cc = new CompositeCommand("Move Out From Parition");
            ActivityPartition outFromPartition = (ActivityPartition)req.getParameter(OUT_FROM_PARTITION);
            for (Object elementToMove : req.getElementsToMove().keySet()) {
                ActivityNode node;
                LinkedList inPartitions;
                if (!(elementToMove instanceof ActivityNode) || !(inPartitions = new LinkedList((node = (ActivityNode)elementToMove).getInPartitions())).contains(outFromPartition)) continue;
                inPartitions.remove(outFromPartition);
                cc.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)node, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityNode_InPartition(), inPartitions)));
            }
            return cc.isEmpty() ? null : cc.reduce();
        }
        return null;
    }

    public static ICommand getMoveOutFromInterruptibleActivityRegionCommand(MoveRequest req) {
        if (req.getParameter(OUT_FROM_INTERRUPTIBLE_REGION) != null) {
            CompositeCommand cc = new CompositeCommand("Move Out From InterruptibleActivityRegion");
            InterruptibleActivityRegion outFromRegion = (InterruptibleActivityRegion)req.getParameter(OUT_FROM_INTERRUPTIBLE_REGION);
            for (Object elementToMove : req.getElementsToMove().keySet()) {
                ActivityNode node;
                LinkedList inRegion;
                if (!(elementToMove instanceof ActivityNode) || !(inRegion = new LinkedList((node = (ActivityNode)elementToMove).getInInterruptibleRegions())).contains(outFromRegion)) continue;
                inRegion.remove(outFromRegion);
                cc.add((IUndoableOperation)new SetValueCommand(new SetRequest((EObject)node, (EStructuralFeature)UMLPackage.eINSTANCE.getActivityNode_InInterruptibleRegion(), inRegion)));
            }
            return cc.isEmpty() ? null : cc.reduce();
        }
        return null;
    }

    static class DestroyActivityOwnedElementCommand
    extends DestroyElementCommand {
        DestroyActivityOwnedElementCommand(DestroyElementRequest request) {
            super(request);
        }

        protected void tearDownIncomingReferences(EObject destructee) {
            Activity activity = (Activity)TypeUtils.as((Object)destructee.eContainer(), Activity.class);
            if (activity != null) {
                activity.getNodes().remove((Object)destructee);
                activity.getGroups().remove((Object)destructee);
            }
            super.tearDownIncomingReferences(destructee);
        }
    }
}

