/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.filters.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.filters.CompoundFilter;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.filters.FiltersPackage;
import org.eclipse.papyrus.infra.filters.OperatorKind;
import org.eclipse.papyrus.infra.filters.internal.operations.CompoundFilterOperations;
import org.eclipse.uml2.common.util.SubsetSupersetEObjectContainmentEList;
import org.eclipse.uml2.common.util.SubsetSupersetEObjectResolvingEList;

public class CompoundFilterImpl
extends MinimalEObjectImpl.Container
implements CompoundFilter {
    protected int _flags = 0;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<Filter> filters;
    protected EList<Filter> ownedFilters;
    protected static final OperatorKind OPERATOR_EDEFAULT = OperatorKind.AND;
    protected static final int OPERATOR_EFLAG_OFFSET = 0;
    protected static final int OPERATOR_EFLAG_DEFAULT = OPERATOR_EDEFAULT.ordinal() << 0;
    private static final OperatorKind[] OPERATOR_EFLAG_VALUES = OperatorKind.values();
    protected static final int OPERATOR_EFLAG = 3;
    protected static final int[] FILTER_ESUBSETS = new int[]{2};
    protected static final int[] OWNED_FILTER_ESUPERSETS = new int[]{1};

    protected CompoundFilterImpl() {
    }

    protected EClass eStaticClass() {
        return FiltersPackage.Literals.COMPOUND_FILTER;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        newName = newName == null ? NAME_EDEFAULT : newName;
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SubsetSupersetEObjectResolvingEList(Filter.class, (InternalEObject)this, 1, null, FILTER_ESUBSETS);
        }
        return this.filters;
    }

    @Override
    public Filter getFilter(String name) {
        return this.getFilter(name, false, null);
    }

    @Override
    public Filter getFilter(String name, boolean ignoreCase, EClass eClass) {
        for (Filter filter : this.getFilters()) {
            if (eClass != null && !eClass.isInstance((Object)filter) || name != null && (ignoreCase ? !name.equalsIgnoreCase(filter.getName()) : !name.equals(filter.getName()))) continue;
            return filter;
        }
        return null;
    }

    @Override
    public EList<Filter> getOwnedFilters() {
        if (this.ownedFilters == null) {
            this.ownedFilters = new SubsetSupersetEObjectContainmentEList(Filter.class, (InternalEObject)this, 2, OWNED_FILTER_ESUPERSETS, null);
        }
        return this.ownedFilters;
    }

    @Override
    public Filter createOwnedFilter(String name, EClass eClass) {
        Filter newOwnedFilter = (Filter)this.create(eClass);
        this.getOwnedFilters().add((Object)newOwnedFilter);
        if (name != null) {
            newOwnedFilter.setName(name);
        }
        return newOwnedFilter;
    }

    @Override
    public Filter getOwnedFilter(String name) {
        return this.getOwnedFilter(name, false, null, false);
    }

    @Override
    public Filter getOwnedFilter(String name, boolean ignoreCase, EClass eClass, boolean createOnDemand) {
        for (Filter ownedFilter : this.getOwnedFilters()) {
            if (eClass != null && !eClass.isInstance((Object)ownedFilter) || name != null && (ignoreCase ? !name.equalsIgnoreCase(ownedFilter.getName()) : !name.equals(ownedFilter.getName()))) continue;
            return ownedFilter;
        }
        return createOnDemand && eClass != null ? this.createOwnedFilter(name, eClass) : null;
    }

    @Override
    public OperatorKind getOperator() {
        return OPERATOR_EFLAG_VALUES[(this._flags & 3) >>> 0];
    }

    @Override
    public void setOperator(OperatorKind newOperator) {
        OperatorKind oldOperator = OPERATOR_EFLAG_VALUES[(this._flags & 3) >>> 0];
        if (newOperator == null) {
            newOperator = OPERATOR_EDEFAULT;
        }
        this._flags = this._flags & 0xFFFFFFFC | newOperator.ordinal() << 0;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldOperator, (Object)newOperator));
        }
    }

    @Override
    public boolean matches(Object input) {
        return CompoundFilterOperations.matches(this, input);
    }

    @Override
    public boolean validateAcyclic(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return CompoundFilterOperations.validateAcyclic(this, diagnostics, context);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getOwnedFilters()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getFilters();
            }
            case 2: {
                return this.getOwnedFilters();
            }
            case 3: {
                return this.getOperator();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.getFilters().clear();
                this.getFilters().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedFilters().clear();
                this.getOwnedFilters().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setOperator((OperatorKind)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.getFilters().clear();
                return;
            }
            case 2: {
                this.getOwnedFilters().clear();
                return;
            }
            case 3: {
                this.setOperator(OPERATOR_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return this.filters != null && !this.filters.isEmpty();
            }
            case 2: {
                return this.ownedFilters != null && !this.ownedFilters.isEmpty();
            }
            case 3: {
                return (this._flags & 3) != OPERATOR_EFLAG_DEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.matches(arguments.get(0));
            }
            case 1: {
                return this.validateAcyclic((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", operator: ");
        result.append((Object)OPERATOR_EFLAG_VALUES[(this._flags & 3) >>> 0]);
        result.append(')');
        return result.toString();
    }

    protected EObject create(EClass eClass) {
        return EcoreUtil.create((EClass)eClass);
    }
}

