/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.emf.gmf.command.INonDirtying;
import org.eclipse.papyrus.infra.services.validation.IPapyrusDiagnostician;
import org.eclipse.papyrus.infra.services.validation.Messages;
import org.eclipse.papyrus.infra.services.validation.ValidationTool;
import org.eclipse.papyrus.infra.services.validation.ValidationUtils;
import org.eclipse.papyrus.infra.services.validation.commands.ValidationOperation;
import org.eclipse.papyrus.infra.services.validation.internal.ValidationRegistry;
import org.eclipse.papyrus.infra.services.validation.preferences.PreferenceUtils;
import org.eclipse.papyrus.infra.ui.util.TransactionUIHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractValidateCommand
extends AbstractTransactionalCommand
implements INonDirtying {
    final String modelValidationViewID = "org.eclipse.papyrus.views.validation.ModelValidationView";
    protected TransactionalEditingDomain domain;
    protected EObject selectedElement;
    protected Diagnostic diagnostic;
    protected IPapyrusDiagnostician diagnostician;
    protected boolean showUIfeedback;

    public AbstractValidateCommand(String label, TransactionalEditingDomain domain, EObject selectedElement) {
        this(label, domain, selectedElement, null);
    }

    public AbstractValidateCommand(String label, TransactionalEditingDomain domain, EObject selectedElement, IPapyrusDiagnostician diagnostician) {
        super(domain, label, Collections.EMPTY_LIST);
        this.domain = domain;
        this.selectedElement = selectedElement;
        this.diagnostician = diagnostician;
        this.showUIfeedback = true;
    }

    public void disableUIFeedback() {
        this.showUIfeedback = false;
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    protected Resource getValidationResource() {
        return ValidationUtils.getValidationResource(this.selectedElement);
    }

    protected void runValidation(final EObject validateElement) {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ValidationRegistry.executeHooks(this.selectedElement, ValidationRegistry.HookType.BEFORE);
        if (this.diagnostician == null) {
            this.diagnostician = ValidationRegistry.getDiagnostician(this.selectedElement);
        }
        ValidationOperation runValidationWithProgress = new ValidationOperation(validateElement, this);
        IRunnableWithProgress createMarkersWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    AbstractValidateCommand.this.handleDiagnostic(progressMonitor, AbstractValidateCommand.this.diagnostic, validateElement, shell);
                }
                finally {
                    progressMonitor.done();
                    ValidationRegistry.executeHooks(AbstractValidateCommand.this.selectedElement, ValidationRegistry.HookType.AFTER);
                }
            }
        };
        createMarkersWithProgress = new ValidationTool(validateElement).wrap(createMarkersWithProgress);
        try {
            try {
                if (this.showUIfeedback) {
                    IRunnableWithProgress privileged = TransactionUIHelper.createPrivilegedRunnableWithProgress((TransactionalEditingDomain)this.getEditingDomain(), (IRunnableWithProgress)runValidationWithProgress);
                    new ProgressMonitorDialog(shell).run(true, true, privileged);
                } else {
                    runValidationWithProgress.run((IProgressMonitor)new NullProgressMonitor());
                }
            }
            finally {
                this.diagnostic = runValidationWithProgress.getDiagnostics();
                runValidationWithProgress.dispose();
            }
            if (this.diagnostic != null) {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWindow;
                IWorkbench workbench;
                int markersToCreate = this.diagnostic.getChildren().size();
                if (markersToCreate > 0 && PreferenceUtils.getAutoShowValidation() && this.showUIfeedback && PlatformUI.isWorkbenchRunning() && (workbench = PlatformUI.getWorkbench()) != null && (activeWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = activeWindow.getActivePage()) != null) {
                    activePage.showView("org.eclipse.papyrus.views.validation.ModelValidationView");
                }
                if (this.showUIfeedback) {
                    new ProgressMonitorDialog(shell).run(false, true, createMarkersWithProgress);
                } else {
                    createMarkersWithProgress.run((IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
        }
    }

    protected Diagnostic validate(IProgressMonitor progressMonitor, EObject validateElement) {
        int validationSteps = 0;
        TreeIterator i = validateElement.eAllContents();
        while (i.hasNext()) {
            ++validationSteps;
            i.next();
        }
        progressMonitor.beginTask("", validationSteps);
        AdapterFactory adapterFactory = this.domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory() : null;
        this.diagnostician.initialize(adapterFactory, progressMonitor);
        BasicDiagnostic diagnostic = this.diagnostician.createDefaultDiagnostic(validateElement);
        Map<Object, Object> context = this.diagnostician.createDefaultContext();
        progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{this.diagnostician.getObjectLabel(validateElement)}));
        this.diagnostician.validate(validateElement, (DiagnosticChain)diagnostic, context);
        if (progressMonitor.isCanceled()) {
            return null;
        }
        return diagnostic;
    }

    protected void handleDiagnostic(IProgressMonitor monitor, Diagnostic diagnostic, EObject validateElement, Shell shell) {
        Resource resource = this.getValidationResource();
        if (resource != null && validateElement != null) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            ValidationTool vt = new ValidationTool(validateElement, resource);
            int markersToCreate = diagnostic.getChildren().size();
            sub.beginTask(Messages.AbstractValidateCommand_DeleteExistingMarkers, 1);
            this.flushDisplayEvents(shell.getDisplay());
            vt.deleteSubMarkers((IProgressMonitor)sub.newChild(1));
            monitor.setTaskName(String.format(Messages.AbstractValidateCommand_CreateNMarkers, markersToCreate));
            this.flushDisplayEvents(shell.getDisplay());
            vt.createMarkers(diagnostic, (IProgressMonitor)sub.newChild(1));
            sub.done();
        }
    }

    protected void flushDisplayEvents(Display display) {
        while (display.readAndDispatch()) {
        }
    }

    public boolean canExecute() {
        return this.selectedElement != null;
    }
}

