/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.documentation.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.properties.ui.widgets.TabbedPropertyTitle;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.util.PapyrusSelectionService;
import org.eclipse.papyrus.uml.tools.commands.ApplyStereotypeCommand;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.papyrus.uml.types.core.commands.SetStereotypeValueCommand;
import org.eclipse.papyrus.uml.types.core.requests.SetStereotypeValueRequest;
import org.eclipse.papyrus.uml.ui.editors.UMLRichtextEditorWithReferences;
import org.eclipse.papyrus.uml.ui.editors.UMLToolbarConfiguration;
import org.eclipse.papyrus.views.documentation.Activator;
import org.eclipse.papyrus.views.documentation.messages.Messages;
import org.eclipse.papyrus.views.documentation.widgets.DocumentationResourceEditor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class DocumentationView
extends ViewPart {
    private static final String ASSOCIATED_RESOURCE_PROPERTY_LABEL = "associatedResource";
    private static final String DOCUMENT_PROFILE_QUALIFY_NAME = "Documentation::Documentation";
    public static final String ID = "org.eclipse.papyrus.views.documentation.DocumentationView";
    private boolean linkingEnabled;
    private UMLRichtextEditorWithReferences richtextEditor;
    private Comment comment;
    private Element commentOwner;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite topComposite;
    private TabbedPropertyTitle nameTitle;
    private ILabelProvider titleLabelProvider = new LabelProviderServiceImpl().getLabelProvider();
    private UMLToolbarConfiguration toolbarConfig;
    private ISelection lastSelection;
    private StackLayout parentStackLayout;
    private Composite mainComposite;
    private Composite noEditorComposite;
    private Composite parent;
    private ISelectionListener selectionListener;
    private ISelectionChangedListener selectionChangeListener;
    private String text;
    protected boolean useRichText;
    private StackLayout editorStackLayout;
    private Composite editorsComposite;
    private Text stringEditor;
    private boolean readOnly;
    private boolean useDocumentationProfile;
    private Composite resourcesComposite;
    private CTabFolder tabFolderComposite;
    private DocumentationResourceEditor resourceTableComposite;
    private Adapter listener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier().equals(DocumentationView.this.commentOwner) && msg.getFeature() != null && msg.getFeature().equals(UMLPackage.eINSTANCE.getNamedElement_Name())) {
                DocumentationView.this.refreshNameTitle();
            } else if (msg.getNotifier().equals(DocumentationView.this.comment) && msg.getFeature() != null && msg.getFeature().equals(UMLPackage.eINSTANCE.getComment_Body()) && !DocumentationView.this.richtextEditor.getText().equals(DocumentationView.this.comment.getBody()) && DocumentationView.this.richtextEditor != null && !DocumentationView.this.richtextEditor.isDisposed()) {
                DocumentationView.this.refreshEditors();
            }
        }
    };
    IPropertyChangeListener richTextPreferenceListener = event -> {
        if ("useCkEditor" == event.getProperty()) {
            this.useRichText = org.eclipse.papyrus.infra.ui.Activator.getDefault().getPreferenceStore().getBoolean("useCkEditor");
            if (this.useRichText) {
                if (this.richtextEditor != null && !this.richtextEditor.isDisposed()) {
                    this.richtextEditor.setText(this.text);
                }
                this.editorStackLayout.topControl = this.richtextEditor;
            } else {
                if (this.stringEditor != null && !this.stringEditor.isDisposed()) {
                    this.stringEditor.setText(this.text);
                }
                this.editorStackLayout.topControl = this.stringEditor;
            }
            if (this.editorsComposite != null && !this.editorsComposite.isDisposed()) {
                this.editorsComposite.layout(true);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.parentStackLayout = new StackLayout();
        parent.setLayout((Layout)this.parentStackLayout);
        CTabItem createTabItemComment = null;
        CTabItem createTabItemRessources = null;
        if (this.useDocumentationProfile) {
            this.tabFolderComposite = this.widgetFactory.createTabFolder(parent, 0);
            createTabItemComment = this.widgetFactory.createTabItem(this.tabFolderComposite, 0);
            createTabItemComment.setText(Messages.DocumentationView_CommentTabLabel);
            createTabItemRessources = this.widgetFactory.createTabItem(this.tabFolderComposite, 0);
            createTabItemRessources.setText(Messages.DocumentationView_ResourcesTabLabel);
            this.tabFolderComposite.setSelection(createTabItemComment);
        }
        this.noEditorComposite = this.widgetFactory.createComposite(parent, 0);
        this.parentStackLayout.topControl = this.noEditorComposite;
        this.createMainComposite((Composite)(this.useDocumentationProfile ? this.tabFolderComposite : parent));
        if (this.useDocumentationProfile) {
            this.resourcesComposite = this.widgetFactory.createComposite((Composite)this.tabFolderComposite);
            GridLayoutFactory.fillDefaults().equalWidth(false).spacing(0, 0).applyTo(this.resourcesComposite);
            this.resourceTableComposite = new DocumentationResourceEditor(this.resourcesComposite);
            createTabItemComment.setControl((Control)this.mainComposite);
            createTabItemRessources.setControl((Control)this.resourcesComposite);
        }
        parent.layout(true);
        this.createAction();
    }

    protected void createAction() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add(this.createToggleLinkingAction());
        }
    }

    protected void createRichTextEditor(Composite parent) {
        this.toolbarConfig = new UMLToolbarConfiguration();
        this.toolbarConfig.toolbarCollapsible = true;
        this.toolbarConfig.removeFormat = false;
        this.toolbarConfig.toolbarInitialExpanded = Activator.getToolbarInitialExpendedPreference();
        this.richtextEditor = new UMLRichtextEditorWithReferences(parent, this.toolbarConfig);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.nameTitle, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.richtextEditor.setLayoutData((Object)formData);
        this.richtextEditor.addModifyListener(event -> {
            if (!this.readOnly && this.useRichText) {
                this.text = this.richtextEditor.getText();
            }
        });
    }

    protected void save() {
        if (this.commentOwner != null) {
            TransactionalEditingDomain editingDomain = this.getDomain();
            CompoundCommand cc = new CompoundCommand("Edit Documentation");
            if (this.text != null) {
                if (this.comment != null) {
                    if (!this.text.equals(this.comment.getBody())) {
                        cc.append((Command)new SetCommand((EditingDomain)editingDomain, (EObject)this.comment, (EStructuralFeature)UMLPackage.eINSTANCE.getComment_Body(), (Object)this.text));
                    }
                } else if (!this.text.isEmpty() || this.resourceTableComposite != null && !this.resourceTableComposite.getResources().isEmpty()) {
                    cc.append((Command)this.getCreateNewCommentCommand());
                }
            }
            if (this.useDocumentationProfile && this.comment != null && this.resourceTableComposite != null) {
                SetStereotypeValueRequest requestSetResources = new SetStereotypeValueRequest(editingDomain, this.getDocumentationStereotype(), (Element)this.comment, ASSOCIATED_RESOURCE_PROPERTY_LABEL, this.resourceTableComposite.getResources());
                cc.append((Command)new GMFtoEMFCommandWrapper((ICommand)new SetStereotypeValueCommand(requestSetResources, editingDomain, "")));
            }
            if (cc != null && cc.canExecute()) {
                editingDomain.getCommandStack().execute((Command)cc);
            }
            if (this.useRichText) {
                this.richtextEditor.configureEdition((EObject)this.comment, (EStructuralFeature)UMLPackage.eINSTANCE.getComment_Body());
            }
        }
    }

    private TransactionalEditingDomain getDomain() {
        return TransactionUtil.getEditingDomain((EObject)this.commentOwner);
    }

    protected CompoundCommand getCreateNewCommentCommand() {
        TransactionalEditingDomain editingDomain = this.getDomain();
        this.comment = UMLFactory.eINSTANCE.createComment();
        this.comment.setBody(this.text);
        CompoundCommand cc = new CompoundCommand("Create new Comment");
        cc.append((Command)new AddCommand((EditingDomain)editingDomain, (EObject)this.commentOwner, (EStructuralFeature)UMLPackage.eINSTANCE.getElement_OwnedComment(), (Object)this.comment));
        if (this.useDocumentationProfile) {
            Stereotype documentationStereotype = this.getDocumentationStereotype();
            if (documentationStereotype != null) {
                ApplyStereotypeCommand applyStereotypeCommand = new ApplyStereotypeCommand((Element)this.comment, documentationStereotype, editingDomain);
                cc.append((Command)applyStereotypeCommand);
            } else {
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.DocumentationView_notProfileAppliedDialogTitle, (String)Messages.DocumentationView_notProfileAppliedDialogMessage);
            }
        }
        return cc;
    }

    public Stereotype getDocumentationStereotype() {
        Package package_;
        Stereotype docStereotype = null;
        if (this.commentOwner != null && (package_ = this.commentOwner.getNearestPackage()) != null) {
            Iterator iterator = package_.getAllProfileApplications().iterator();
            while (docStereotype == null && iterator.hasNext()) {
                ProfileApplication profileApplication = (ProfileApplication)iterator.next();
                Profile appliedProfile = profileApplication.getAppliedProfile();
                if (appliedProfile == null) continue;
                Iterator iterator2 = appliedProfile.allApplicableStereotypes().iterator();
                while (docStereotype == null && iterator2.hasNext()) {
                    Stereotype stereotype = (Stereotype)iterator2.next();
                    ENamedElement appliedDefinition = profileApplication.getAppliedDefinition((NamedElement)stereotype);
                    if (!(appliedDefinition instanceof EClass) || ((EClass)appliedDefinition).isAbstract() || !DOCUMENT_PROFILE_QUALIFY_NAME.equals(stereotype.getQualifiedName())) continue;
                    docStereotype = stereotype;
                }
            }
        }
        return docStereotype;
    }

    protected void createEditorTitle() {
        this.nameTitle = new TabbedPropertyTitle(this.topComposite, this.widgetFactory);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        this.nameTitle.setLayoutData((Object)data);
    }

    protected void createTopComposite(Composite parent) {
        this.topComposite = this.widgetFactory.createComposite(parent, 0);
        this.topComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.topComposite.setLayoutData((Object)formData);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.topComposite);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.linkingEnabled = Activator.getDefault().getToogleLinkingSetting();
        this.useRichText = Activator.getDefault().getUseRichTextSetting();
        this.useDocumentationProfile = Activator.getUseDocumentationProfilePreference();
        this.widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.selectionListener = this.createSelectionListener();
        site.getPage().addSelectionListener(this.selectionListener);
        this.selectionChangeListener = this.createSelectionChangedListener();
        PapyrusSelectionService.getInstance().addSelectionChangedListener(this.selectionChangeListener);
        this.getViewSite().getPage().addPartListener((IPartListener)new SaveAtPartFocusLostListener());
        org.eclipse.papyrus.infra.ui.Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.richTextPreferenceListener);
    }

    private ISelectionListener createSelectionListener() {
        return (part, selection) -> {
            if (!(part instanceof DocumentationView)) {
                this.lastSelection = selection;
                if (this.linkingEnabled) {
                    this.setSelectedElement(selection);
                }
            }
        };
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return event -> {
            ISelection selection;
            this.lastSelection = selection = event.getSelection();
            if (this.linkingEnabled) {
                this.setSelectedElement(selection);
            }
        };
    }

    public void setSelectedElement(ISelection selection) {
        Object firstElement;
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && this.parent != null && !this.parent.isDisposed() && 1 == (structuredSelection = (IStructuredSelection)selection).size() && !((firstElement = structuredSelection.getFirstElement()) instanceof String)) {
            this.setSelectedElement(UMLUtil.resolveUMLElement((Object)firstElement));
        }
    }

    protected void createMainComposite(Composite parent) {
        this.mainComposite = this.widgetFactory.createPlainComposite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.mainComposite);
        this.createTopComposite(this.mainComposite);
        this.createEditorTitle();
        this.createEditorsComposite();
        this.createRichTextEditor(this.editorsComposite);
        this.createStringEditorComposite();
        this.editorsComposite.layout(true);
        this.editorStackLayout.topControl = this.useRichText ? this.richtextEditor : this.stringEditor;
    }

    protected void createStringEditorComposite() {
        this.stringEditor = this.widgetFactory.createText(this.editorsComposite, "", 2818);
        this.stringEditor.addModifyListener(event -> {
            if (!this.readOnly) {
                this.text = this.stringEditor.getText();
            }
        });
    }

    protected void createEditorsComposite() {
        this.editorsComposite = this.widgetFactory.createComposite(this.topComposite);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.nameTitle, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.editorsComposite.setLayoutData((Object)formData);
        this.editorStackLayout = new StackLayout();
        this.editorsComposite.setLayout((Layout)this.editorStackLayout);
    }

    protected void setSelectedElement(Element element) {
        this.parentStackLayout.topControl = element != null ? (this.useDocumentationProfile ? this.tabFolderComposite : this.mainComposite) : this.noEditorComposite;
        this.removeListener();
        this.commentOwner = element;
        this.comment = null;
        boolean isReadOnly = true;
        if (this.commentOwner != null) {
            TransactionalEditingDomain editingDomain;
            this.commentOwner.eAdapters().add((Object)this.listener);
            EList ownedComments = this.commentOwner.getOwnedComments();
            if (!ownedComments.isEmpty()) {
                this.comment = this.getDocumentationComment((EList<Comment>)ownedComments);
                if (this.comment != null) {
                    this.comment.eAdapters().add((Object)this.listener);
                }
            }
            if (this.commentOwner.eResource() != null && (editingDomain = this.getDomain()) != null) {
                isReadOnly = editingDomain.isReadOnly(this.commentOwner.eResource());
            }
        }
        this.setReadOnly(isReadOnly);
        this.refreshNameTitle();
        this.refreshEditors();
        this.refreshResources();
        this.parent.layout(true);
    }

    protected void refreshResources() {
        ArrayList<String> resources = new ArrayList<String>();
        if (this.resourceTableComposite != null) {
            Object value;
            Stereotype appliedStereotype;
            if (this.useDocumentationProfile && this.comment != null && (appliedStereotype = this.comment.getAppliedStereotype(DOCUMENT_PROFILE_QUALIFY_NAME)) != null && (value = this.comment.getValue(appliedStereotype, ASSOCIATED_RESOURCE_PROPERTY_LABEL)) instanceof List) {
                resources.addAll((List)value);
            }
            this.resourceTableComposite.setResources(resources);
            this.resourceTableComposite.refresh();
        }
    }

    protected Comment getDocumentationComment(EList<Comment> ownedComments) {
        Comment docComment = null;
        this.useDocumentationProfile = Activator.getUseDocumentationProfilePreference();
        if (this.useDocumentationProfile) {
            Iterator iterator = ownedComments.iterator();
            while (iterator.hasNext() && docComment == null) {
                Comment comment = (Comment)iterator.next();
                if (comment.getAppliedStereotype(DOCUMENT_PROFILE_QUALIFY_NAME) == null) continue;
                docComment = comment;
            }
        } else {
            docComment = (Comment)ownedComments.get(0);
        }
        return docComment;
    }

    protected void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected void refreshEditors() {
        this.text = this.comment != null && this.comment.getBody() != null ? this.comment.getBody() : "";
        if (this.useRichText && this.richtextEditor != null && !this.richtextEditor.isDisposed()) {
            this.richtextEditor.configureEdition((EObject)this.comment, (EStructuralFeature)(this.comment != null ? UMLPackage.eINSTANCE.getComment_Body() : null));
            try {
                this.richtextEditor.setText(this.text);
                this.richtextEditor.setEditable(!this.readOnly);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.stringEditor != null && !this.stringEditor.isDisposed()) {
            this.stringEditor.setText(this.text);
            this.stringEditor.setEditable(!this.readOnly);
        }
    }

    protected void refreshNameTitle() {
        if (this.nameTitle != null && !this.nameTitle.isDisposed()) {
            this.nameTitle.setTitle(this.titleLabelProvider.getText((Object)this.commentOwner), this.titleLabelProvider.getImage((Object)this.commentOwner));
        }
    }

    protected void removeListener() {
        if (this.commentOwner != null) {
            this.commentOwner.eAdapters().remove((Object)this.listener);
        }
        if (this.comment != null) {
            this.comment.eAdapters().remove((Object)this.listener);
        }
    }

    protected IAction createToggleLinkingAction() {
        Action toggleLinkingAction = new Action(Messages.DocumentationView_SyncActionTooltip, 2){

            public void run() {
                DocumentationView.this.linkingEnabled = this.isChecked();
                Activator.getDefault().setToggleEditorSetting(DocumentationView.this.linkingEnabled);
                if (DocumentationView.this.linkingEnabled && DocumentationView.this.lastSelection != null) {
                    DocumentationView.this.setSelectedElement(DocumentationView.this.lastSelection);
                }
            }
        };
        toggleLinkingAction.setChecked(this.linkingEnabled);
        toggleLinkingAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"icons/full/elcl16/synced.png"));
        return toggleLinkingAction;
    }

    public void setFocus() {
        if (this.richtextEditor != null) {
            try {
                this.richtextEditor.setEditable(!this.readOnly);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.richtextEditor.setFocus();
        } else {
            this.parent.setFocus();
        }
    }

    public void dispose() {
        this.removeListener();
        if (this.selectionListener != null) {
            this.getSite().getPage().removeSelectionListener(this.selectionListener);
        }
        if (this.selectionChangeListener != null) {
            PapyrusSelectionService.getInstance().removeSelectionChangedListener(this.selectionChangeListener);
        }
        if (this.richTextPreferenceListener != null) {
            org.eclipse.papyrus.infra.ui.Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.richTextPreferenceListener);
        }
        super.dispose();
    }

    private final class SaveAtPartFocusLostListener
    implements IPartListener {
        private SaveAtPartFocusLostListener() {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part.equals((Object)DocumentationView.this)) {
                DocumentationView.this.save();
            }
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    }
}

