/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.operation;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.eclipse.core.commands.operations.IUndoContext;

public class DelegatingUndoContext
implements IUndoContext {
    private IUndoContext delegate;

    public String getLabel() {
        IUndoContext delegate = this.getDelegate();
        return delegate == null ? "" : delegate.getLabel();
    }

    public boolean matches(IUndoContext context) {
        IUndoContext delegate = this.getDelegate();
        return delegate == null ? false : delegate.matches(context);
    }

    public void setDelegate(IUndoContext delegate) {
        this.delegate = delegate;
    }

    public IUndoContext getDelegate() {
        return this.delegate;
    }

    public static class Dynamic
    extends DelegatingUndoContext {
        private Supplier<IUndoContext> delegateSupplier;

        public Dynamic(Supplier<IUndoContext> delegateSupplier) {
            this.delegateSupplier = delegateSupplier;
        }

        @Override
        public IUndoContext getDelegate() {
            return (IUndoContext)this.delegateSupplier.get();
        }

        @Override
        public void setDelegate(IUndoContext delegate) {
            this.delegateSupplier = Suppliers.ofInstance((Object)delegate);
        }
    }
}

