/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.references.utils;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.views.references.utils.ReferencesViewUtil;
import org.eclipse.papyrus.views.references.views.ReferencesView;

public class HandleReferences {
    public static HandleReferences INSTANCE = new HandleReferences();
    private EObject objectToSearch;
    private ReferencesView referencesView;
    private LabelProviderService labelProviderService;

    public LabelProviderService getLabelProviderService() {
        if (this.labelProviderService == null) {
            this.labelProviderService = new LabelProviderServiceImpl();
        }
        return this.labelProviderService;
    }

    public void openViewAndLaunchSearch(IStructuredSelection structuredSelection) {
        Object firstElement;
        this.referencesView = ReferencesViewUtil.openReferencesView();
        if (1 == structuredSelection.size() && (firstElement = structuredSelection.getFirstElement()) != null) {
            this.objectToSearch = EMFHelper.getEObject((Object)firstElement);
        }
        this.launchFindReferences();
    }

    public void getViewAndLaunch(EObject objectToSearch) {
        this.referencesView = ReferencesViewUtil.getOpenedReferencesView();
        this.objectToSearch = objectToSearch;
        this.launchFindReferences();
    }

    public void launchFindReferences() {
        ECrossReferenceAdapter crossReferenceAdapter;
        if (this.referencesView != null && this.objectToSearch != null && (crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)this.objectToSearch)) != null) {
            Collection results = crossReferenceAdapter.getNonNavigableInverseReferences(this.objectToSearch);
            this.referencesView.showResult(results, this.objectToSearch);
        }
    }
}

