/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.importt.handlers;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.uml.importt.handlers.AbstractImportHandler;
import org.eclipse.papyrus.uml.importt.ui.PackageImportDialog;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ElementImportTreeSelectionDialog;
import org.eclipse.papyrus.uml.tools.importsources.PackageImportSourceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Package;

public class ImportPackageFromUserModelHandler
extends AbstractImportHandler {
    protected ICommand getGMFCommand(IEvaluationContext context) {
        return new ImportFromFileCommand(context);
    }

    public class ImportFromFileCommand
    extends AbstractImportHandler.AbstractImportCommand {
        public ImportFromFileCommand(IEvaluationContext context) {
            super(new Runnable(){

                public void run() {
                    PackageImportDialog dialog;
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    LinkedHashMap<String, String> extensionFilters = new LinkedHashMap<String, String>();
                    extensionFilters.put("*.uml", "UML (*.uml)");
                    extensionFilters.put("*.profile.uml", "UML Profiles (*.profile.uml)");
                    extensionFilters.put("*", "All (*)");
                    Collection packages = PackageImportSourceDialog.open((Shell)shell, (String)"Select the models to import", (Collection)ImportPackageFromUserModelHandler.this.getSelection(), extensionFilters);
                    if (packages == null) {
                        return;
                    }
                    if (!packages.isEmpty() && (dialog = new PackageImportDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), packages)).open() == 0) {
                        Collection result = dialog.getResult();
                        for (ElementImportTreeSelectionDialog.ImportSpec resultElement : result) {
                            Package selectedPackage = (Package)resultElement.getElement();
                            switch (resultElement.getAction()) {
                                case COPY: {
                                    ImportPackageFromUserModelHandler.this.handleCopyPackage(selectedPackage);
                                    break;
                                }
                                case IMPORT: {
                                    ImportPackageFromUserModelHandler.this.handleImportPackage(selectedPackage);
                                    break;
                                }
                                default: {
                                    ImportPackageFromUserModelHandler.this.handleLoadPackage(selectedPackage);
                                }
                            }
                        }
                    }
                }
            }, context, "Import Libraries", "Import Libraries from Workspace");
        }
    }
}

