/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.editor;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.operation.DelegatingUndoContext;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.ui.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.editor.IReloadableEditor;
import org.eclipse.papyrus.infra.ui.editor.reload.EditorReloadEvent;
import org.eclipse.papyrus.infra.ui.editor.reload.IEditorReloadListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.properties.PropertyShowInContext;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

class MultiDiagramPropertySheetPage
extends TabbedPropertySheetPage
implements IEditorReloadListener {
    private final CoreMultiDiagramEditor multiDiagramEditor;
    private UndoActionHandler undo;
    private RedoActionHandler redo;
    private DelegatingUndoContext undoContext;

    public MultiDiagramPropertySheetPage(CoreMultiDiagramEditor editor) {
        super((ITabbedPropertySheetPageContributor)editor);
        this.multiDiagramEditor = editor;
        IReloadableEditor.Adapter.getAdapter(editor).addEditorReloadListener(this);
    }

    public void dispose() {
        IReloadableEditor.Adapter.getAdapter(this.multiDiagramEditor).removeEditorReloadListener(this);
        if (this.undo != null) {
            this.undo.dispose();
        }
        if (this.redo != null) {
            this.redo.dispose();
        }
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IMultiDiagramEditor editor;
        ISashWindowsContainer sash;
        if (selection.isEmpty() && part instanceof IMultiDiagramEditor && (sash = (ISashWindowsContainer)(editor = (IMultiDiagramEditor)part).getAdapter(ISashWindowsContainer.class)) != null && sash.getActiveEditor() == null && sash.getActiveSashWindowsPage() != null) {
            Object newSelection;
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                newSelection = ((IFileEditorInput)input).getFile();
            } else if (input instanceof IStorageEditorInput) {
                IStorageEditorInput storageInput = (IStorageEditorInput)input;
                try {
                    newSelection = storageInput.getStorage();
                }
                catch (CoreException e) {
                    newSelection = storageInput;
                }
            } else {
                newSelection = input instanceof IURIEditorInput ? ((IURIEditorInput)input).getURI() : (input instanceof URIEditorInput ? ((URIEditorInput)input).getURI() : null);
            }
            if (newSelection != null) {
                selection = new StructuredSelection(newSelection);
            }
        }
        super.selectionChanged(part, selection);
    }

    @Override
    public void editorAboutToReload(EditorReloadEvent event) {
        IWorkbenchPart inputPart;
        ShowInContext context;
        Object propertySheet = this.getSite().getService(IViewPart.class);
        if (propertySheet instanceof IShowInSource && (context = ((IShowInSource)propertySheet).getShowInContext()) instanceof PropertyShowInContext && (inputPart = ((PropertyShowInContext)context).getPart()) != null) {
            event.putContext(inputPart);
        }
    }

    @Override
    public void editorReloaded(EditorReloadEvent event) {
        Object propertySheet;
        final IWorkbenchPart inputPart = (IWorkbenchPart)event.getContext();
        if (inputPart != null && (propertySheet = this.getSite().getService(IViewPart.class)) instanceof IPartListener) {
            ((IPartListener)propertySheet).partActivated(inputPart);
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ISelectionProvider selectionProvider = inputPart.getSite().getSelectionProvider();
                    if (selectionProvider != null) {
                        ((ISelectionListener)propertySheet).selectionChanged(inputPart, selectionProvider.getSelection());
                    }
                }
            });
        }
        if (this.undoContext != null) {
            this.undoContext.setDelegate((IUndoContext)PlatformHelper.getAdapter((Object)this.multiDiagramEditor, IUndoContext.class));
        }
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        this.undoContext = new DelegatingUndoContext();
        this.undoContext.setDelegate((IUndoContext)PlatformHelper.getAdapter((Object)this.multiDiagramEditor, IUndoContext.class));
        this.undo = new UndoActionHandler(this.multiDiagramEditor.getSite(), (IUndoContext)this.undoContext);
        this.redo = new RedoActionHandler(this.multiDiagramEditor.getSite(), (IUndoContext)this.undoContext);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undo);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redo);
    }
}

