/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.parts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.ExternalLabelPrimaryDragRoleEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.parsers.ParserUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.Activator;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.IPopupEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.UMLEditPartFactory;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.directedit.MultilineLabelDirectEditManager;
import org.eclipse.papyrus.uml.diagram.common.editparts.AbstractLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.ILabelRoleProvider;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeExternalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AppliedStereotypeWrappingLabelFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Feature;

public class InputPinInSendSigActAsTargetAppliedStereotypeEditPart
extends AbstractLabelEditPart
implements ITextAwareEditPart,
IBorderItemEditPart,
ILabelRoleProvider {
    public static final String VISUAL_ID = "InputPin_SendSignalActionTargetStereotypeLabel";
    private DirectEditManager manager;
    private IParser parser;
    private List<?> parserElements;
    private String defaultText;
    protected int directEditionMode = 0;
    protected IDirectEditorConfiguration configuration;

    static {
        InputPinInSendSigActAsTargetAppliedStereotypeEditPart.registerSnapBackPosition((String)UMLVisualIDRegistry.getType(VISUAL_ID), (Point)new Point(0, 0));
    }

    public InputPinInSendSigActAsTargetAppliedStereotypeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new UMLTextSelectionEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeExternalNodeEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ExternalLabelPrimaryDragRoleEditPolicy());
    }

    public IBorderItemLocator getBorderItemLocator() {
        IFigure parentFigure = this.getFigure().getParent();
        if (parentFigure != null && parentFigure.getLayoutManager() != null) {
            Object constraint = parentFigure.getLayoutManager().getConstraint(this.getFigure());
            return (IBorderItemLocator)constraint;
        }
        return null;
    }

    public void refreshBounds() {
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        this.getBorderItemLocator().setConstraint(new Rectangle(x, y, width, height));
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getText();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getText();
        }
        return ((Label)figure).getText();
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setText(text);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setText(text);
        } else {
            ((Label)figure).setText(text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getIcon();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getIcon();
        }
        return ((Label)figure).getIcon();
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setIcon(icon);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setIcon(icon);
        } else {
            ((Label)figure).setIcon(icon);
        }
    }

    public void setLabel(IFigure figure) {
        this.unregisterVisuals();
        this.setFigure(figure);
        this.defaultText = this.getLabelTextHelper(figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    protected List<?> getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    public void setParser(IParser parser) {
        this.parser = parser;
    }

    protected EObject getParserElement() {
        return this.resolveSemanticElement();
    }

    protected Image getLabelIcon() {
        return DiagramEditPartsUtil.getIcon((EObject)this.getParserElement(), (EditPartViewer)this.getViewer());
    }

    protected String getLabelText() {
        String text = null;
        EObject parserElement = this.getParserElement();
        if (parserElement != null && this.getParser() != null) {
            text = this.getParser().getPrintString(ParserUtil.getParserAdapter((EObject)this.getParserElement(), (EditPart)this), this.getParserOptions().intValue());
        }
        if (text == null || text.length() == 0) {
            text = this.defaultText;
        }
        return text;
    }

    public void setLabelText(String text) {
        EditPolicy sfEditPolicy;
        this.setLabelTextHelper(this.getFigure(), text);
        EditPolicy pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (pdEditPolicy instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString(ParserUtil.getParserAdapter((EObject)this.getParserElement(), (EditPart)this), this.getParserOptions().intValue());
    }

    protected boolean isEditable() {
        return false;
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    EObject element = InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.getParserElement();
                    final IParser parser = InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.getParser();
                    try {
                        IParserEditStatus valid = (IParserEditStatus)InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl<Object>(){

                            public void run() {
                                this.setResult(parser.isValidEditString(ParserUtil.getParserAdapter((EObject)InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.getParserElement(), (EditPart)InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this), (String)value));
                            }
                        });
                        return valid.getCode() == 0 ? null : valid.getMessage();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor(ParserUtil.getParserAdapter((EObject)this.getParserElement(), (EditPart)this));
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = ParserUtil.getParser((IElementType)UMLElementTypes.InputPin_SendSignalActionTargetShape, (EObject)this.getParserElement(), (EditPart)this, (String)VISUAL_ID);
        }
        return this.parser;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new MultilineLabelDirectEditManager((GraphicalEditPart)this, MultilineLabelDirectEditManager.getTextCellEditorClass((GraphicalEditPart)this), UMLEditPartFactory.getTextCellEditorLocator(this)));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void performDirectEdit() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.getManager().show();
            }
        });
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }

    protected void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        Request theRequest = request;
        if (this.directEditionMode == 0) {
            this.directEditionMode = this.getDirectEditionType();
        }
        switch (this.directEditionMode) {
            case 8: {
                return;
            }
            case 4: {
                this.updateExtendedEditorConfiguration();
                if (this.configuration == null || this.configuration.getLanguage() == null) {
                    this.setManager((DirectEditManager)new MultilineLabelDirectEditManager((GraphicalEditPart)this, MultilineLabelDirectEditManager.getTextCellEditorClass((GraphicalEditPart)this), UMLEditPartFactory.getTextCellEditorLocator(this)));
                    this.performDefaultDirectEditorEdit(theRequest);
                    break;
                }
                this.configuration.preEditAction((Object)this.resolveSemanticElement());
                Dialog dialog = null;
                if (this.configuration instanceof ICustomDirectEditorConfiguration) {
                    this.setManager(((ICustomDirectEditorConfiguration)this.configuration).createDirectEditManager((ITextAwareEditPart)this));
                    this.initializeDirectEditManager(theRequest);
                    return;
                }
                if (this.configuration instanceof IPopupEditorConfiguration) {
                    IPopupEditorHelper helper = ((IPopupEditorConfiguration)this.configuration).createPopupEditorHelper((Object)this);
                    helper.showEditor();
                    return;
                }
                if (this.configuration instanceof IAdvancedEditorConfiguration) {
                    dialog = ((IAdvancedEditorConfiguration)this.configuration).createDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()));
                } else if (this.configuration instanceof IDirectEditorConfiguration) {
                    dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()), this.configuration);
                } else {
                    return;
                }
                final Dialog finalDialog = dialog;
                if (dialog.open() != 0) break;
                TransactionalEditingDomain domain = this.getEditingDomain();
                RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                    protected void doExecute() {
                        InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.configuration.postEditAction((Object)InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.resolveSemanticElement(), ((ILabelEditorDialog)finalDialog).getValue());
                    }
                };
                domain.getCommandStack().execute((Command)command);
                break;
            }
            case 2: {
                this.initializeDirectEditManager(theRequest);
                break;
            }
        }
    }

    protected void initializeDirectEditManager(final Request request) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.isActive() && InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.isEditable()) {
                        if (request.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)request.getExtendedData().get("directedit_extendeddata_initial_char");
                            InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.performDirectEdit(initialChar.charValue());
                        } else {
                            InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    protected void refreshLabel() {
        EditPolicy sfEditPolicy;
        EditPolicy pdEditPolicy;
        EditPolicy maskLabelPolicy = this.getEditPolicy("MaskManagedLabelPolicy");
        if (maskLabelPolicy == null) {
            maskLabelPolicy = this.getEditPolicy("INDRIRECT_MASK_MANAGED_LABEL");
        }
        if (maskLabelPolicy == null) {
            View view = (View)this.getModel();
            if (view.isVisible()) {
                this.setLabelTextHelper(this.getFigure(), this.getLabelText());
                this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
            } else {
                this.setLabelTextHelper(this.getFigure(), "");
                this.setLabelIconHelper(this.getFigure(), null);
            }
        }
        if ((pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextUnderline(style.isUnderline());
        }
        if (this.resolveSemanticElement() instanceof Feature) {
            if (((Feature)this.resolveSemanticElement()).isStatic()) {
                ((WrappingLabel)this.getFigure()).setTextUnderline(true);
            } else {
                ((WrappingLabel)this.getFigure()).setTextUnderline(false);
            }
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextStrikeThrough(style.isStrikeThrough());
        }
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject element = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(element);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + i, (NotificationListener)this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.getLabelTextHelper(InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.getFigure());
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return this.getPrimaryView();
    }

    public int getDirectEditionType() {
        return 8;
    }

    protected boolean checkExtendedEditor() {
        if (this.resolveSemanticElement() != null) {
            return DirectEditorsUtil.hasSpecificEditorConfiguration((Object)this.resolveSemanticElement(), (Object)((Object)this));
        }
        return false;
    }

    protected boolean checkDefaultEdition() {
        return this.getParser() != null;
    }

    protected void initExtendedEditorConfiguration() {
        if (this.configuration == null) {
            String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
            this.configuration = languagePreferred != null && !languagePreferred.equals("") ? DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (Object)this.resolveSemanticElement(), (Object)((Object)this)) : DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (Object)this.resolveSemanticElement(), (Object)((Object)this));
        }
    }

    protected void updateExtendedEditorConfiguration() {
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
        if (languagePreferred != null && !languagePreferred.equals("") && !languagePreferred.equals(this.configuration.getLanguage())) {
            this.configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (Object)this.resolveSemanticElement(), (Object)((Object)this));
        } else if ("Simple Direct Editor".equals(languagePreferred)) {
            this.configuration = null;
        }
    }

    protected void performDefaultDirectEditorEdit(final Request theRequest) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.isActive() && InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.isEditable()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.getEditText().equals(InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            InputPinInSendSigActAsTargetAppliedStereotypeEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else {
            ISemanticParser modelParser;
            if (this.getParser() != null && this.getParser().isAffectingEvent((Object)event, this.getParserOptions().intValue())) {
                this.refreshLabel();
            }
            if (this.getParser() instanceof ISemanticParser && (modelParser = (ISemanticParser)this.getParser()).areSemanticElementsAffected(null, (Object)event)) {
                this.removeSemanticListeners();
                if (this.resolveSemanticElement() != null) {
                    this.addSemanticListeners();
                }
                this.refreshLabel();
            }
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createFigure() {
        IFigure label = this.createFigurePrim();
        this.defaultText = this.getLabelTextHelper(label);
        return label;
    }

    protected IFigure createFigurePrim() {
        return new AppliedStereotypeWrappingLabelFigure();
    }

    public String getLabelRole() {
        return "Stereotype";
    }

    public String getIconPathRole() {
        return "platform:/plugin/org.eclipse.papyrus.uml.diagram.common/icons/stereotype.gif";
    }
}

