/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.uml.tools.commands.ApplyProfileCommand;
import org.eclipse.papyrus.uml.tools.commands.UnapplyProfileCommand;
import org.eclipse.papyrus.uml.tools.databinding.AbstractStereotypeListener;
import org.eclipse.papyrus.uml.tools.helper.ProfileApplicationDelegateRegistry;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ProfileApplicationObservableList
extends WritableList
implements ICommitListener,
IObserving {
    private Package umlSource;
    private EditingDomain domain;
    private final List<Command> commands;
    private AbstractStereotypeListener listener;

    public ProfileApplicationObservableList(Package umlSource, EditingDomain domain) {
        super(ProfileApplicationObservableList.getAppliedProfiles(umlSource), Profile.class);
        this.umlSource = umlSource;
        this.domain = domain;
        this.commands = new LinkedList<Command>();
        this.listener = new AbstractStereotypeListener((Element)umlSource){

            protected void handleUnappliedStereotype(final EObject newValue) {
                ProfileApplicationObservableList.this.fireListChange(new ListDiff(){

                    public ListDiffEntry[] getDifferences() {
                        return new ListDiffEntry[]{new ListDiffEntry(){

                            public int getPosition() {
                                return 0;
                            }

                            public boolean isAddition() {
                                return false;
                            }

                            public Object getElement() {
                                return newValue;
                            }
                        }};
                    }
                });
            }

            protected void handleAppliedStereotype(final EObject newValue) {
                ProfileApplicationObservableList.this.fireListChange(new ListDiff(){

                    public ListDiffEntry[] getDifferences() {
                        return new ListDiffEntry[]{new ListDiffEntry(){

                            public int getPosition() {
                                return 0;
                            }

                            public boolean isAddition() {
                                return true;
                            }

                            public Object getElement() {
                                return newValue;
                            }
                        }};
                    }
                });
            }
        };
    }

    public Object getObserved() {
        return this.umlSource;
    }

    public synchronized void dispose() {
        super.dispose();
        this.listener.dispose();
    }

    public void commit(AbstractEditor editor) {
        if (this.commands.isEmpty()) {
            return;
        }
        CompoundCommand compoundCommand = new CompoundCommand(){

            public void execute() {
                super.execute();
                ProfileApplicationObservableList.this.refreshCacheList();
            }

            public void undo() {
                super.undo();
                ProfileApplicationObservableList.this.refreshCacheList();
            }

            public void redo() {
                super.redo();
                ProfileApplicationObservableList.this.refreshCacheList();
            }

            public boolean canExecute() {
                return this.commandList.isEmpty() ? false : ((Command)this.commandList.get(0)).canExecute();
            }
        };
        for (Command cmd : this.commands) {
            compoundCommand.append(cmd);
        }
        this.domain.getCommandStack().execute((Command)compoundCommand);
        this.refreshCacheList();
        this.commands.clear();
    }

    protected final void refreshCacheList() {
        this.wrappedList.clear();
        this.wrappedList.addAll(ProfileApplicationObservableList.getAppliedProfiles(this.umlSource));
        this.fireListChange(null);
    }

    static Collection<Profile> getAppliedProfiles(Package package_) {
        ProfileApplicationDelegateRegistry reg = ProfileApplicationDelegateRegistry.INSTANCE;
        ArrayList<Profile> result = new ArrayList<Profile>();
        for (ProfileApplication next : reg.getDelegate(package_).getProfileApplications(package_)) {
            Profile profile = reg.getDelegate(next).getAppliedProfile(next);
            if (profile == null) continue;
            result.add(profile);
        }
        return result;
    }

    public void clear() {
        this.removeAll(new LinkedList(this.wrappedList));
    }

    public boolean add(Object o) {
        if (!(o instanceof Profile)) {
            return false;
        }
        Profile profile = (Profile)EMFHelper.reloadIntoContext((EObject)((Profile)o), (EObject)this.umlSource);
        ApplyProfileCommand command = new ApplyProfileCommand(this.umlSource, profile, (TransactionalEditingDomain)this.domain);
        this.commands.add((Command)command);
        return this.wrappedList.add(o);
    }

    public boolean remove(Object o) {
        if (!(o instanceof Profile)) {
            return false;
        }
        Profile profile = (Profile)o;
        UnapplyProfileCommand command = new UnapplyProfileCommand(this.umlSource, profile, (TransactionalEditingDomain)this.domain);
        this.commands.add((Command)command);
        return this.wrappedList.remove(o);
    }

    public boolean addAll(Collection c) {
        c.removeAll(this.wrappedList);
        LinkedList<Profile> profiles = new LinkedList<Profile>();
        for (Object element : c) {
            if (element instanceof Profile) {
                profiles.add((Profile)EMFHelper.reloadIntoContext((EObject)((Profile)element), (EObject)this.umlSource));
                continue;
            }
            throw new IllegalArgumentException("The new value should only contain profiles");
        }
        ApplyProfileCommand command = new ApplyProfileCommand(this.umlSource, profiles, (TransactionalEditingDomain)this.domain);
        this.commands.add((Command)command);
        return this.wrappedList.addAll(c);
    }

    public boolean removeAll(Collection c) {
        UnapplyProfileCommand command = new UnapplyProfileCommand(this.umlSource, c, (TransactionalEditingDomain)this.domain);
        this.commands.add((Command)command);
        return this.wrappedList.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        LinkedList objectsToRemove = new LinkedList();
        for (Object object : c) {
            if (this.contains(object)) continue;
            objectsToRemove.add(object);
        }
        return this.removeAll(objectsToRemove);
    }

    public void add(int index, Object value) {
        this.add(value);
    }

    public boolean addAll(int index, Collection c) {
        return this.addAll(c);
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object move(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }
}

