/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.stereotype.display.label.provider;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.papyrus.infra.emf.nattable.provider.EMFFeatureHeaderLabelProvider;
import org.eclipse.papyrus.infra.emf.nattable.registry.EStructuralFeatureImageRegistry;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.FeatureLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ObjectLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.LabelConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.nattable.messages.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class StereotypeDisplayPropertyHeaderLabelProvider
extends EMFFeatureHeaderLabelProvider {
    public static final String REQUIRED_PROFILE_NOT_AVALAIBLE = Messages.StereotypePropertyHeaderLabelProvider_RequiredProfileNotFound;
    public static final String AGGREG_SHARED = "icons/aggreg_shared.gif";

    public boolean accept(Object element) {
        if (element instanceof ILabelProviderContextElementWrapper) {
            Object object = ((ILabelProviderContextElementWrapper)element).getObject();
            if (object instanceof IAxis) {
                object = ((IAxis)object).getElement();
            }
            return object instanceof Property && ((Property)object).eContainer() instanceof Stereotype && !(object instanceof EStructuralFeature);
        }
        return false;
    }

    public String getText(Object element) {
        LabelProviderCellContextElementWrapper wrapper = (LabelProviderCellContextElementWrapper)element;
        IConfigRegistry configRegistry = wrapper.getConfigRegistry();
        Object value = this.getWrappedValue((ILabelProviderContextElementWrapper)wrapper);
        String alias = "";
        if (value instanceof FeatureAxis) {
            alias = ((FeatureAxis)value).getAlias();
        }
        ILabelProviderConfiguration conf = this.getLabelConfiguration((ILabelProviderCellContextElementWrapper)wrapper);
        String returnedValue = null;
        if (conf instanceof ObjectLabelProviderConfiguration && !((ObjectLabelProviderConfiguration)conf).isDisplayLabel()) {
            returnedValue = "";
        } else {
            Object object = ((ILabelProviderContextElementWrapper)element).getObject();
            Property prop = null;
            if (object instanceof IAxis) {
                prop = (Property)((IAxis)object).getElement();
            }
            if (prop != null) {
                returnedValue = alias != null && !alias.isEmpty() ? alias : UMLLabelInternationalization.getInstance().getLabel((NamedElement)prop);
                if (conf != null) {
                    if (alias != null && !alias.equals("")) {
                        returnedValue = alias;
                    }
                    returnedValue = this.getText((FeatureLabelProviderConfiguration)conf, configRegistry, returnedValue, prop.getType(), prop.isDerived(), prop.getLower(), prop.getUpper());
                }
            }
        }
        return returnedValue;
    }

    protected ILabelProviderConfiguration getLabelConfiguration(ILabelProviderCellContextElementWrapper wrapper) {
        FeatureLabelProviderConfiguration conf = null;
        IConfigRegistry configRegistry = wrapper.getConfigRegistry();
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        Table table = modelManager.getTable();
        if (wrapper instanceof ILabelProviderCellContextElementWrapper) {
            LabelStack labels = wrapper.getConfigLabels();
            if (labels.hasLabel("COLUMN_HEADER")) {
                conf = LabelConfigurationManagementUtils.getUsedColumnFeatureLabelConfiguration((Table)table);
            } else if (labels.hasLabel("ROW_HEADER")) {
                conf = LabelConfigurationManagementUtils.getUsedRowFeatureLabelConfiguration((Table)table);
            }
        }
        return conf;
    }

    public Image getImage(Object element) {
        ILabelProviderConfiguration conf = this.getLabelConfiguration((ILabelProviderCellContextElementWrapper)((LabelProviderCellContextElementWrapper)element));
        if (conf instanceof ObjectLabelProviderConfiguration && !((ObjectLabelProviderConfiguration)conf).isDisplayIcon()) {
            return null;
        }
        Object object = ((ILabelProviderContextElementWrapper)element).getObject();
        Property prop = null;
        if (object instanceof IAxis) {
            prop = (Property)((IAxis)object).getElement();
        }
        if (prop != null) {
            Type type = prop.getType();
            if (type instanceof DataType) {
                return EStructuralFeatureImageRegistry.getAttributeIcon();
            }
            switch (prop.getAggregation().getValue()) {
                case 0: {
                    return EStructuralFeatureImageRegistry.getLinkIcon();
                }
                case 2: {
                    return EStructuralFeatureImageRegistry.getAggregIcon();
                }
                case 1: {
                    return Activator.getDefault().getImage("org.eclipse.papyrus.uml.nattable", AGGREG_SHARED);
                }
            }
        }
        return null;
    }
}

