/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class MultiRowReorderCommand
implements ILayerCommand {
    private List<RowPositionCoordinate> fromRowPositionCoordinates;
    private RowPositionCoordinate toRowPositionCoordinate;
    private boolean reorderToTopEdge;

    public MultiRowReorderCommand(ILayer layer, List<Integer> fromRowPositions, int toRowPosition) {
        this(layer, fromRowPositions, toRowPosition < layer.getRowCount() ? toRowPosition : toRowPosition - 1, toRowPosition < layer.getRowCount());
    }

    public MultiRowReorderCommand(ILayer layer, List<Integer> fromRowPositions, int toRowPosition, boolean reorderToTopEdge) {
        this.fromRowPositionCoordinates = new ArrayList<RowPositionCoordinate>();
        for (Integer fromRowPosition : fromRowPositions) {
            this.fromRowPositionCoordinates.add(new RowPositionCoordinate(layer, fromRowPosition));
        }
        this.toRowPositionCoordinate = new RowPositionCoordinate(layer, toRowPosition);
        this.reorderToTopEdge = reorderToTopEdge;
    }

    protected MultiRowReorderCommand(MultiRowReorderCommand command) {
        this.fromRowPositionCoordinates = new ArrayList<RowPositionCoordinate>(command.fromRowPositionCoordinates);
        this.toRowPositionCoordinate = command.toRowPositionCoordinate;
        this.reorderToTopEdge = command.reorderToTopEdge;
    }

    public List<Integer> getFromRowPositions() {
        ArrayList<Integer> fromRowPositions = new ArrayList<Integer>();
        for (RowPositionCoordinate fromRowPositionCoordinate : this.fromRowPositionCoordinates) {
            fromRowPositions.add(fromRowPositionCoordinate.getRowPosition());
        }
        return fromRowPositions;
    }

    public int getToRowPosition() {
        return this.toRowPositionCoordinate.getRowPosition();
    }

    public boolean isReorderToTopEdge() {
        return this.reorderToTopEdge;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        ArrayList<RowPositionCoordinate> convertedFromRowPositionCoordinates = new ArrayList<RowPositionCoordinate>();
        for (RowPositionCoordinate fromRowPositionCoordinate : this.fromRowPositionCoordinates) {
            RowPositionCoordinate convertedFromRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(fromRowPositionCoordinate, targetLayer);
            if (convertedFromRowPositionCoordinate == null) continue;
            convertedFromRowPositionCoordinates.add(convertedFromRowPositionCoordinate);
        }
        RowPositionCoordinate targetToRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(this.toRowPositionCoordinate, targetLayer);
        if (convertedFromRowPositionCoordinates.size() > 0 && targetToRowPositionCoordinate != null) {
            this.fromRowPositionCoordinates = convertedFromRowPositionCoordinates;
            this.toRowPositionCoordinate = targetToRowPositionCoordinate;
            return true;
        }
        return false;
    }

    @Override
    public MultiRowReorderCommand cloneCommand() {
        return new MultiRowReorderCommand(this);
    }
}

