/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.welcome.internal.widgets;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.papyrus.infra.editor.welcome.nattable.widgets.HyperlinkTable;
import org.eclipse.papyrus.infra.gmfdiag.welcome.internal.modelelements.NotationObservable;
import org.eclipse.swt.widgets.Composite;

public class NotationsTable
extends HyperlinkTable<NotationObservable> {
    public NotationsTable(Composite parent, int style) {
        super(parent, style, true, (IColumnPropertyAccessor)new NotationsColumnAccessor(), new String[]{"View", "Context"});
    }

    static class NotationsColumnAccessor
    implements IColumnPropertyAccessor<NotationObservable> {
        static final String VIEW = "view";
        static final String CONTEXT = "context";

        NotationsColumnAccessor() {
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getDataValue(NotationObservable rowObject, int columnIndex) {
            IObservableValue<EObject> result;
            switch (columnIndex) {
                case 0: {
                    result = rowObject.getView();
                    break;
                }
                case 1: {
                    result = rowObject.getContext();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(columnIndex));
                }
            }
            return result;
        }

        public void setDataValue(NotationObservable rowObject, int columnIndex, Object newValue) {
            throw new IllegalStateException("not editable");
        }

        public String getColumnProperty(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return VIEW;
                }
                case 1: {
                    return CONTEXT;
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(columnIndex));
        }

        public int getColumnIndex(String propertyName) {
            switch (propertyName) {
                case "view": {
                    return 0;
                }
                case "context": {
                    return 1;
                }
            }
            throw new IllegalArgumentException(propertyName);
        }
    }
}

