/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkDocument;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkSpecificObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkWeb;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class HyperLinkLabelProvider
extends LabelProvider {
    protected final String HYPERLINK_WEB_ICON_PATH = "/icons/hyperlink.gif";
    protected final String HYPERLINK_DOCUMENT_ICON_PATH = "/icons/file.gif";
    private final String SEP = " - ";

    public org.eclipse.swt.graphics.Image getImage(Object element) {
        EObject targetElement;
        if (element instanceof HyperLinkDocument) {
            ImageData imageData;
            FileSystemView view;
            Icon icon;
            File theDoc = new File(((HyperLinkDocument)element).getHyperlinkDocument());
            if (theDoc != null && (icon = (view = FileSystemView.getFileSystemView()).getSystemIcon(theDoc)) instanceof ImageIcon && (imageData = HyperLinkLabelProvider.convertAWTImageToSWT(((ImageIcon)icon).getImage())) != null) {
                return new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), imageData);
            }
            return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.infra.hyperlink", "/icons/file.gif");
        }
        if (element instanceof HyperLinkWeb) {
            block11: {
                try {
                    InputStream stream = this.getRawStreamFromURL(new URL("http://www.google.com/s2/favicons?domain=" + ((HyperLinkWeb)element).getHyperLinkWeb()));
                    if (stream == null) break block11;
                    try {
                        BufferedImage image = ImageIO.read(stream);
                        ImageData imageData = HyperLinkLabelProvider.convertAWTImageToSWT(image);
                        if (imageData != null) {
                            return new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), imageData);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("org.eclipse.papyrus.infra.hyperlink", "/icons/hyperlink.gif");
        }
        if (element instanceof HyperLinkSpecificObject && (targetElement = ((HyperLinkSpecificObject)element).getTargetElement()) != null) {
            try {
                return ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)targetElement)).getLabelProvider().getImage((Object)targetElement);
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        String out = "";
        if (element instanceof HyperLinkDocument) {
            out = ((HyperLinkDocument)element).getHyperlinkDocument();
        } else if (element instanceof HyperLinkWeb) {
            out = ((HyperLinkWeb)element).getHyperLinkWeb();
        } else if (element instanceof HyperLinkSpecificObject) {
            EObject targetElement = ((HyperLinkSpecificObject)element).getTargetElement();
            if (targetElement != null) {
                try {
                    return ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)targetElement)).getLabelProvider().getText((Object)targetElement);
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
        } else {
            return super.getText(element);
        }
        out = String.valueOf(((HyperLinkObject)element).getTooltipText()) + " - " + out;
        return out;
    }

    public static ImageData convertAWTImageToSWT(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w == -1 || h == -1) {
            return null;
        }
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return HyperLinkLabelProvider.convertToSWT(bi);
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    protected InputStream getRawStreamFromURL(URL url) {
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            return input;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

