/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.modelelement;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AbstractModelElementFactory;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.modelelement.CustomImageModelElement;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Image;

public class CustomImageModelElementFactory
extends AbstractModelElementFactory<CustomImageModelElement> {
    protected CustomImageModelElement doCreateFromSource(Object sourceElement, DataContextElement context) {
        Element umlSource = UMLUtil.resolveUMLElement((Object)sourceElement);
        if (umlSource == null) {
            Activator.log.warn("Unable to resolve the selected element to a UML Element");
            return null;
        }
        if (umlSource instanceof Image) {
            EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)umlSource);
            return new CustomImageModelElement((Image)umlSource, domain);
        }
        Activator.log.warn("The selected element is not a UML Image");
        return null;
    }

    protected void updateModelElement(CustomImageModelElement modelElement, Object newSourceElement) {
        Element element = UMLUtil.resolveUMLElement((Object)newSourceElement);
        if (!(element instanceof Image)) {
            throw new IllegalArgumentException("Cannot resolve UML Image selection: " + newSourceElement);
        }
        modelElement.image = (Image)element;
        modelElement.editingDomain = EMFHelper.resolveEditingDomain((EObject)element);
    }
}

