/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.IPageUtils;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IComponentPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

class PageContext {
    final IEditorPart editor;
    final IPageManager pageManager;
    final ISashWindowsContainer sashContainer;
    final Object currentPageIdentifier;
    final IPage currentPage;

    PageContext(ExecutionEvent event) {
        this(HandlerUtil.getActiveEditor((ExecutionEvent)event));
    }

    PageContext(Object evaluationContext) {
        this((IEditorPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor"));
    }

    PageContext(IEditorPart activeEditor) {
        this.editor = activeEditor;
        ISashWindowsContainer iSashWindowsContainer = this.sashContainer = activeEditor == null ? null : (ISashWindowsContainer)activeEditor.getAdapter(ISashWindowsContainer.class);
        if (this.sashContainer == null || this.sashContainer.isDisposed()) {
            this.pageManager = null;
            this.currentPage = null;
            this.currentPageIdentifier = null;
        } else {
            this.pageManager = (IPageManager)activeEditor.getAdapter(IPageManager.class);
            this.currentPage = this.sashContainer.getActiveSashWindowsPage();
            this.currentPageIdentifier = this.currentPage == null ? null : IPageUtils.getRawModel(this.currentPage);
        }
    }

    boolean isValid() {
        return this.pageManager != null && this.currentPageIdentifier != null && this.sashContainer != null;
    }

    int getOpenPageCount() {
        return this.getOpenPages().size();
    }

    Collection<IPage> getOpenPages() {
        List<IPage> result;
        if (!this.isValid()) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            this.sashContainer.visit(new IPageVisitor(){

                public void accept(IEditorPage page) {
                    result.add(page);
                }

                public void accept(IComponentPage page) {
                    result.add(page);
                }
            });
        }
        return result;
    }
}

