/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.sort;

import ca.odell.glazedlists.SortedList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.sort.AbstractGlazedListSortModel;
import org.eclipse.papyrus.infra.nattable.sort.IPapyrusSortModel;
import org.eclipse.papyrus.infra.nattable.sort.PapyrusColumnAccessor;
import org.eclipse.papyrus.infra.nattable.sort.PapyrusGlazedListsSortModel;
import org.eclipse.ui.services.IDisposable;

public class PapyrusCompositeGlazedListSortModel
extends AbstractGlazedListSortModel
implements IPapyrusSortModel,
IDisposable {
    private PapyrusGlazedListsSortModel columnSortModel;
    private PapyrusGlazedListsSortModel rowSortModel;
    private boolean isTableInverted = false;
    private ILayer columnHeaderLayer;

    public PapyrusCompositeGlazedListSortModel(INattableModelManager manager, SortedList<Object> realRowObjectList, SortedList<Object> realColumnObjectList, boolean isInverted) {
        super(manager);
        this.isTableInverted = isInverted;
        PapyrusColumnAccessor columnAccessor = new PapyrusColumnAccessor(manager);
        this.columnSortModel = new PapyrusGlazedListsSortModel(manager, realRowObjectList, columnAccessor);
        this.rowSortModel = new PapyrusGlazedListsSortModel(manager, realColumnObjectList, columnAccessor);
    }

    @Override
    public void updateSort() {
    }

    public void handleLayerEvent(ILayerEvent event) {
    }

    public List<Integer> getSortedColumnIndexes() {
        if (this.isTableInverted) {
            return this.rowSortModel.getSortedColumnIndexes();
        }
        return this.columnSortModel.getSortedColumnIndexes();
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        if (this.isTableInverted) {
            return this.rowSortModel.isColumnIndexSorted(columnIndex);
        }
        return this.columnSortModel.isColumnIndexSorted(columnIndex);
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        if (this.isTableInverted) {
            return this.rowSortModel.getSortDirection(columnIndex);
        }
        return this.columnSortModel.getSortDirection(columnIndex);
    }

    public int getSortOrder(int columnIndex) {
        if (this.isTableInverted) {
            return this.rowSortModel.getSortOrder(columnIndex);
        }
        return this.columnSortModel.getSortOrder(columnIndex);
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        if (this.isTableInverted) {
            return this.rowSortModel.getComparatorsForColumnIndex(columnIndex);
        }
        return this.columnSortModel.getComparatorsForColumnIndex(columnIndex);
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        if (this.isTableInverted) {
            this.rowSortModel.sort(columnIndex, sortDirection, accumulate);
        } else {
            this.columnSortModel.sort(columnIndex, sortDirection, accumulate);
        }
    }

    public void clear() {
    }

    public void setColumnHeaderLayer(ILayer compositeLayer) {
        this.columnHeaderLayer = compositeLayer;
        this.rowSortModel.clear();
        this.columnSortModel.clear();
        if (this.isTableInverted) {
            compositeLayer.removeLayerListener((ILayerListener)this.columnSortModel);
            this.rowSortModel.setColumnHeaderLayer(compositeLayer);
        } else {
            compositeLayer.removeLayerListener((ILayerListener)this.rowSortModel);
            this.columnSortModel.setColumnHeaderLayer(compositeLayer);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.columnSortModel.dispose();
        this.rowSortModel.dispose();
        this.rowSortModel = null;
        this.columnSortModel = null;
    }

    @Override
    public void setTableInverted(boolean isInverted) {
        this.isTableInverted = isInverted;
        this.setColumnHeaderLayer(this.columnHeaderLayer);
    }

    public Comparator<?> getColumnComparator(int columnIndex) {
        return null;
    }
}

