/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.property.xtext.umlProperty;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VisibilityKind implements Enumerator
{
    PUBLIC(0, "public", "+"),
    PRIVATE(1, "private", "-"),
    PROTECTED(2, "protected", "#"),
    PACKAGE(3, "package", "~");

    public static final int PUBLIC_VALUE = 0;
    public static final int PRIVATE_VALUE = 1;
    public static final int PROTECTED_VALUE = 2;
    public static final int PACKAGE_VALUE = 3;
    private static final VisibilityKind[] VALUES_ARRAY;
    public static final List<VisibilityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VisibilityKind[]{PUBLIC, PRIVATE, PROTECTED, PACKAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VisibilityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VisibilityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VisibilityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VisibilityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VisibilityKind get(int value) {
        switch (value) {
            case 0: {
                return PUBLIC;
            }
            case 1: {
                return PRIVATE;
            }
            case 2: {
                return PROTECTED;
            }
            case 3: {
                return PACKAGE;
            }
        }
        return null;
    }

    private VisibilityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

