/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringListValueStyle;
import org.eclipse.gmf.runtime.notation.View;

public class RemoveCssClassStyleCommand
extends RecordingCommand
implements Command {
    private Collection<View> views;
    private String style;

    public RemoveCssClassStyleCommand(TransactionalEditingDomain domain, View view, String newValue) {
        this(domain, Collections.singleton(view), newValue);
    }

    public RemoveCssClassStyleCommand(TransactionalEditingDomain domain, Collection<View> views, String style) {
        super(domain);
        this.views = views;
        this.style = style;
    }

    protected void doExecute() {
        for (View view : this.views) {
            StringListValueStyle namedStyle = (StringListValueStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getStringListValueStyle(), "cssClass");
            if (namedStyle == null) {
                return;
            }
            if (this.style == null || !namedStyle.getStringListValue().contains((Object)this.style)) continue;
            namedStyle.getStringListValue().remove((Object)this.style);
        }
    }
}

