/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTreeRowHideShowCategoryHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;

public class TreeRowHideShowCategoryHandler
extends AbstractTreeRowHideShowCategoryHandler {
    public static final String HIDE_CATEGORY_PARAMETER_KEY = "hideCategory";
    public static final String DEPTH_PARAMETER_KEY = "depth";
    public static final String COMMAND_ID = "org.eclipse.papyrus.infra.nattable.row.show.hide.category.command";

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        Boolean hide = (Boolean)arg0.getParameters().get(HIDE_CATEGORY_PARAMETER_KEY);
        Integer depth = (Integer)arg0.getParameters().get(DEPTH_PARAMETER_KEY);
        if (hide.booleanValue()) {
            this.hideCategory(depth);
        } else {
            this.showCategory(depth);
        }
        return null;
    }

    protected void hideCategory(Integer depth) {
        IntListValueStyle style = StyleUtils.getHiddenDepthsValueStyle(this.getTable());
        if (style != null && style.getIntListValue().contains((Object)depth)) {
            return;
        }
        if (depth == 0 && !FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.getTable(), 0)) {
            return;
        }
        if (style == null) {
            style = NattablestyleFactory.eINSTANCE.createIntListValueStyle();
            style.setName("hiddenCategoriesByDepth");
            style.eSet((EStructuralFeature)NattablestylePackage.eINSTANCE.getIntListValueStyle_IntListValue(), Collections.singleton(depth));
            Command cmd = AddCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)this.getTable(), (Object)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), Collections.singleton(style));
            this.getTableEditingDomain().getCommandStack().execute(cmd);
            return;
        }
        ArrayList<Integer> allValues = new ArrayList<Integer>();
        if (style != null) {
            allValues.addAll((Collection<Integer>)style.getIntListValue());
        }
        if (allValues.contains(depth)) {
            return;
        }
        allValues.add(depth);
        Collections.sort(allValues);
        int index = allValues.indexOf(depth);
        Command cmd = AddCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)style, (Object)NattablestylePackage.eINSTANCE.getIntListValueStyle_IntListValue(), (Object)depth, (int)index);
        this.getTableEditingDomain().getCommandStack().execute(cmd);
    }

    protected void showCategory(Integer depth) {
        IntListValueStyle style = StyleUtils.getHiddenDepthsValueStyle(this.getTable());
        if (style == null) {
            return;
        }
        ArrayList newValues = new ArrayList(new HashSet(style.getIntListValue()));
        newValues.remove(depth);
        Command cmd = newValues.isEmpty() ? RemoveCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)this.getTable(), (Object)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)style) : RemoveCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)style, (Object)NattablestylePackage.eINSTANCE.getIntListValueStyle_IntListValue(), (Object)depth);
        this.getTableEditingDomain().getCommandStack().execute(cmd);
    }
}

