/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.providers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.providers.DecoratorPackageCache;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.helper.IProfileApplicationDelegate;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.internal.operations.PackageOperations;

public class ExternalizedProfileApplicationDelegate
implements IProfileApplicationDelegate {
    public static final String PREFERENCE_CONSTANT = "externalized_profile_application_delegate";
    private final PrivateUtil util = new PrivateUtil();

    public boolean appliesTo(Package package_) {
        return true;
    }

    public Iterable<ProfileApplication> getProfileApplications(Package package_) {
        return Iterables.concat((Iterable)package_.getProfileApplications(), DecoratorModelUtils.getDecoratorModelProfileApplications(package_));
    }

    public ProfileApplication getProfileApplication(Package package_, Profile profile) {
        ProfileApplication result = package_.getProfileApplication(profile);
        if (result == null) {
            for (ProfileApplication next : DecoratorModelUtils.getDecoratorModelProfileApplications(package_)) {
                if (next.getAppliedProfile() != profile) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    public EList<EObject> applyProfile(Package package_, Profile profile, Package context, IProgressMonitor monitor) {
        ProfileApplication profileApplication;
        if (!DecoratorModelUtils.isDecoratorModel(context) || EcoreUtil.isAncestor((EObject)context, (EObject)package_)) {
            profileApplication = package_.createProfileApplication();
        } else {
            Package decorator = DecoratorModelUtils.getDecoratorPackage(context, package_, true);
            profileApplication = decorator.createProfileApplication();
        }
        profileApplication.setAppliedProfile(profile);
        return this.util.reapplyProfile(package_, profileApplication, monitor);
    }

    public boolean appliesTo(ProfileApplication profileApplication) {
        return true;
    }

    public Package getApplyingPackage(ProfileApplication profileApplication) {
        Resource resource;
        Package result = profileApplication.getApplyingPackage();
        Resource resource2 = resource = result == null ? null : result.eResource();
        if (resource != null) {
            if (DecoratorModelUtils.isDecoratorModel(resource)) {
                result = DecoratorModelUtils.getUserModelApplyingPackage(profileApplication);
            }
        } else {
            Package userModel = DecoratorPackageCache.getUserModelPackage(result);
            if (userModel != null) {
                result = userModel;
            }
        }
        return result;
    }

    public Profile getAppliedProfile(ProfileApplication profileApplication) {
        return profileApplication.getAppliedProfile();
    }

    public EList<EObject> reapplyProfile(Package package_, Profile profile, IProgressMonitor monitor) {
        ProfileApplication existing = this.getProfileApplication(package_, profile);
        return existing == null ? ECollections.emptyEList() : this.util.reapplyProfile(package_, existing, monitor);
    }

    public String getPreferenceConstant() {
        return PREFERENCE_CONSTANT;
    }

    public String getPreferenceLabel() {
        return "External stereotype application tool";
    }

    private class PrivateUtil
    extends PackageOperations {
        private PrivateUtil() {
        }

        EList<EObject> reapplyProfile(Package package_, ProfileApplication profileApplication, IProgressMonitor monitor) {
            Profile profile = ExternalizedProfileApplicationDelegate.this.getAppliedProfile(profileApplication);
            EPackage definition = profile.getDefinition();
            monitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Re-applying profile \"{0}\" to package \"{1}\"", (Object)UMLLabelInternationalization.getInstance().getLabel((NamedElement)profile), (Object)UMLLabelInternationalization.getInstance().getLabel((NamedElement)package_)), (int)-1);
            ArrayList originals = Lists.newArrayList();
            PrivateStereotypeCopier copier = new PrivateStereotypeCopier(profile);
            TreeIterator allContents = PrivateUtil.getAllContents((EObject)package_, (boolean)true, (boolean)false);
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Element element = (Element)eObject;
                if (element instanceof Package) {
                    for (ProfileApplication next : ExternalizedProfileApplicationDelegate.this.getProfileApplications((Package)element)) {
                        if (ExternalizedProfileApplicationDelegate.this.getAppliedProfile(next) != profile) continue;
                        EList references = PrivateUtil.getEAnnotation((EModelElement)profileApplication, (String)"http://www.eclipse.org/uml2/2.0.0/UML", (boolean)true).getReferences();
                        if (references.isEmpty()) {
                            references.add((Object)definition);
                            continue;
                        }
                        references.set(0, (Object)definition);
                    }
                }
                for (EObject stereotypeApplication : element.getStereotypeApplications()) {
                    Stereotype stereotype = PrivateUtil.getStereotype((EObject)stereotypeApplication);
                    if (stereotype == null || stereotype.getProfile() != profile) continue;
                    if (element.isStereotypeApplicable(stereotype)) {
                        EObject copy = copier.copy(stereotypeApplication);
                        Resource eResource = stereotypeApplication.eResource();
                        if (eResource != null) {
                            EList contents = eResource.getContents();
                            if (eResource == copy.eResource()) {
                                contents.move(contents.indexOf((Object)stereotypeApplication), (Object)copy);
                            } else {
                                contents.set(contents.indexOf((Object)stereotypeApplication), (Object)copy);
                            }
                        }
                    }
                    originals.add(stereotypeApplication);
                }
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            copier.copyReferences();
            for (EObject key : copier.keySet()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EObject copy = (EObject)copier.get(key);
                Resource eResource = key.eResource();
                if (eResource instanceof XMLResource) {
                    XMLResource xmlResource = (XMLResource)eResource;
                    xmlResource.setID(copy, xmlResource.getID(key));
                }
                for (EStructuralFeature.Setting setting : new ArrayList(PrivateUtil.getNonNavigableInverseReferences((EObject)key))) {
                    EStructuralFeature eStructuralFeature;
                    EObject eObject = setting.getEObject();
                    if (copier.containsKey(eObject) || (eStructuralFeature = setting.getEStructuralFeature()) == null || !eStructuralFeature.isChangeable()) continue;
                    if (eStructuralFeature.isMany()) {
                        Object value = eObject.eGet(eStructuralFeature);
                        EList list = (EList)value;
                        list.set(list.indexOf((Object)key), (Object)copy);
                        continue;
                    }
                    setting.set((Object)copy);
                }
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PrivateUtil.destroyAll((Collection)originals);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            return profile.getOwnedExtensions(true).isEmpty() ? ECollections.emptyEList() : PrivateUtil.applyAllRequiredStereotypes((Element)package_);
        }

        private class PrivateStereotypeCopier
        extends PackageOperations.StereotypeApplicationCopier {
            private static final long serialVersionUID = 1L;
            private Set<Profile> extendedProfiles;

            PrivateStereotypeCopier(Profile profile) {
                super(profile);
            }

            protected ENamedElement getDefinition(NamedElement element) {
                ENamedElement result = super.getDefinition(element);
                if (result == null) {
                    for (Profile next : this.getExtendedProfiles()) {
                        if (EcoreUtil.isAncestor((EObject)next, (EObject)element) && (result = next.getDefinition(element)) != null) break;
                    }
                }
                return result;
            }

            protected Set<Profile> getExtendedProfiles() {
                if (this.extendedProfiles == null) {
                    this.extendedProfiles = Sets.newHashSet();
                    this.computeExtendedProfiles(this.profile, this.extendedProfiles);
                }
                return this.extendedProfiles;
            }

            protected void computeExtendedProfiles(Profile profile, Set<Profile> result) {
                TreeIterator iter = profile.eAllContents();
                while (iter.hasNext()) {
                    EObject next = (EObject)iter.next();
                    if (next instanceof Stereotype) {
                        for (Stereotype super_ : Iterables.filter((Iterable)((Stereotype)next).getSuperClasses(), Stereotype.class)) {
                            Profile supersProfile = super_.containingProfile();
                            if (supersProfile == null || supersProfile == profile) continue;
                            result.add(supersProfile);
                        }
                        continue;
                    }
                    if (next instanceof Profile) {
                        iter.prune();
                        continue;
                    }
                    if (next instanceof Package) continue;
                    iter.prune();
                }
            }
        }
    }
}

