/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.dataprovider;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.papyrus.infra.nattable.dataprovider.AbstractDataProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisIndexStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.tools.util.IntegerAndSpreadsheetNumberConverter;

public abstract class AbstractHeaderDataProvider
extends AbstractDataProvider {
    protected boolean displayIndex;
    protected boolean displayLabel;
    protected boolean displayFilter;
    protected AxisIndexStyle style;
    private Adapter invertedListener;
    private Adapter axisListener;
    private Adapter localHeaderConfigListener;
    private AbstractHeaderAxisConfiguration listenAxisConfiguration = this.getAxisConfiguration();

    public AbstractHeaderDataProvider(INattableModelManager tableModelManager) {
        super(tableModelManager);
        this.initListeners();
        this.manager.getTable().eAdapters().add((Object)this.invertedListener);
        this.manager.getTable().eAdapters().add((Object)this.localHeaderConfigListener);
        this.initFields();
    }

    protected void initListeners() {
        this.axisListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                Object feature = msg.getFeature();
                if (feature != null) {
                    if (feature.equals(NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_DisplayFilter())) {
                        AbstractHeaderDataProvider.this.displayFilter = msg.getNewBooleanValue();
                        AbstractHeaderDataProvider.this.updateAxisCount();
                    } else if (feature.equals(NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_DisplayIndex())) {
                        AbstractHeaderDataProvider.this.displayIndex = msg.getNewBooleanValue();
                        AbstractHeaderDataProvider.this.updateAxisCount();
                    } else if (feature.equals(NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_DisplayLabel())) {
                        AbstractHeaderDataProvider.this.displayLabel = msg.getNewBooleanValue();
                        AbstractHeaderDataProvider.this.updateAxisCount();
                    } else if (feature.equals(NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_IndexStyle())) {
                        AbstractHeaderDataProvider.this.style = AxisIndexStyle.get((String)msg.getNewStringValue());
                        AbstractHeaderDataProvider.this.updateAxisCount();
                    }
                }
            }
        };
        this.invertedListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == NattablePackage.eINSTANCE.getTable_InvertAxis()) {
                    Object oldValue = msg.getOldValue();
                    Object newValue = msg.getNewValue();
                    if (oldValue != null && newValue != null) {
                        AbstractHeaderDataProvider.this.initFields();
                    }
                }
            }
        };
        this.localHeaderConfigListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration() || msg.getFeature() == NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration()) {
                    AbstractHeaderDataProvider.this.initFields();
                }
            }
        };
    }

    private void initFields() {
        if (this.listenAxisConfiguration != this.getAxisConfiguration() && this.listenAxisConfiguration != null) {
            this.listenAxisConfiguration.eAdapters().remove((Object)this.axisListener);
        }
        this.listenAxisConfiguration = this.getAxisConfiguration();
        if (this.listenAxisConfiguration != null) {
            this.listenAxisConfiguration.eAdapters().add((Object)this.axisListener);
            if (this.listenAxisConfiguration instanceof AbstractHeaderAxisConfiguration) {
                AbstractHeaderAxisConfiguration config = this.listenAxisConfiguration;
                this.style = config.getIndexStyle();
                this.displayFilter = config.isDisplayFilter();
                this.displayLabel = config.isDisplayLabel();
                this.displayIndex = config.isDisplayIndex();
            }
        }
        this.updateAxisCount();
    }

    protected abstract void updateAxisCount();

    protected abstract AbstractHeaderAxisConfiguration getAxisConfiguration();

    @Override
    public void dispose() {
        this.removeListeners();
        this.listenAxisConfiguration = null;
        super.dispose();
    }

    protected void removeListeners() {
        if (this.listenAxisConfiguration != null) {
            this.listenAxisConfiguration.eAdapters().remove((Object)this.axisListener);
        }
        this.manager.getTable().eAdapters().remove((Object)this.invertedListener);
        this.manager.getTable().eAdapters().remove((Object)this.localHeaderConfigListener);
    }

    protected Object getAxisIndex(int axisIndex) {
        if (axisIndex > -1) {
            switch (this.style) {
                case ALPHABETIC: {
                    return IntegerAndSpreadsheetNumberConverter.toString((int)(axisIndex + 1));
                }
                case NUMERIC: {
                    return axisIndex;
                }
            }
        }
        return null;
    }
}

