/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;

public class TableSelectionWrapper2
extends TableSelectionWrapper {
    private final INattableModelManager manager;
    private final SelectionLayer selectionLayer;
    private Map<Integer, Object> rowPositionAndAxis = new HashMap<Integer, Object>();
    private final Collection<Object> rowAxisElements = new HashSet<Object>();
    private Map<Integer, Object> columnPositionAndAxis = new HashMap<Integer, Object>();
    private final Collection<Object> columnAxisElements = new HashSet<Object>();
    private final Map<PositionCoordinate, CellReference> allSelectedCells = new LinkedHashMap<PositionCoordinate, CellReference>();
    private final Map<PositionCoordinate, CellReference> singleCellsCoordinatesAndUniqueReference = new HashMap<PositionCoordinate, CellReference>();
    private final Collection<Object> singleCellValues = new ArrayList<Object>();
    private boolean isSelectAll = false;

    public TableSelectionWrapper2(INattableModelManager manager, SelectionLayer selectionLayer) {
        super(manager, Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap());
        this.manager = manager;
        this.selectionLayer = selectionLayer;
        this.buildSelection();
    }

    protected final void buildSelection() {
        this.buildColumnSelection();
        this.buildRowSelection();
        this.buildCellSelection();
        this.calculateSelectAll();
    }

    protected void buildColumnSelection() {
        int[] nArray = this.selectionLayer.getFullySelectedColumnPositions();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int currentPosition = nArray[n2];
            int currentIndex = this.selectionLayer.getColumnIndexByPosition(currentPosition);
            Object el = this.manager.getColumnElement(currentIndex);
            this.columnPositionAndAxis.put(currentPosition, el);
            Object representedElement = AxisUtils.getRepresentedElement(el);
            if (representedElement != null) {
                this.columnAxisElements.add(representedElement);
            } else {
                this.columnAxisElements.add(el);
            }
            ++n2;
        }
    }

    protected void buildRowSelection() {
        int[] nArray = this.selectionLayer.getFullySelectedRowPositions();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int currentPosition = nArray[n2];
            int currentIndex = this.selectionLayer.getRowIndexByPosition(currentPosition);
            Object el = this.manager.getRowElement(currentIndex);
            this.rowPositionAndAxis.put(currentPosition, el);
            Object representedElement = AxisUtils.getRepresentedElement(el);
            if (representedElement != null) {
                this.rowAxisElements.add(representedElement);
            } else {
                this.rowAxisElements.add(el);
            }
            ++n2;
        }
    }

    protected void buildCellSelection() {
        PositionCoordinate[] positionCoordinateArray = this.selectionLayer.getSelectedCellPositions();
        int n = positionCoordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate positionCoordinate = positionCoordinateArray[n2];
            ILayerCell cell = this.selectionLayer.getCellByPosition(positionCoordinate.getColumnPosition(), positionCoordinate.getRowPosition());
            if (cell != null) {
                int columnIndex = this.selectionLayer.getColumnIndexByPosition(positionCoordinate.getColumnPosition());
                int rowIndex = this.selectionLayer.getRowIndexByPosition(positionCoordinate.getRowPosition());
                Object columnElement = this.manager.getColumnElement(columnIndex);
                Object rowElement = this.manager.getRowElement(rowIndex);
                CellReference reference = new CellReference(columnElement, rowElement);
                this.allSelectedCells.put(positionCoordinate, reference);
                if (this.isSingleSelectedCell(positionCoordinate)) {
                    this.singleCellsCoordinatesAndUniqueReference.put(positionCoordinate, reference);
                    Object value = cell.getDataValue();
                    if (value != null) {
                        if (value instanceof Collection) {
                            for (Object current : (Collection)value) {
                                this.singleCellValues.add(current);
                            }
                        } else {
                            this.singleCellValues.add(value);
                        }
                    } else {
                        this.singleCellValues.add(cell);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public void updatePositions() {
        this.updateRowPositions();
        this.updateColumnPositions();
        this.updateCellPositions();
    }

    public boolean isSelectAll() {
        return this.isSelectAll;
    }

    private void calculateSelectAll() {
        boolean res = false;
        int columnCount = this.selectionLayer.getColumnCount();
        int rowCount = this.selectionLayer.getRowCount();
        if (this.rowPositionAndAxis.size() >= rowCount && this.columnPositionAndAxis.size() >= columnCount) {
            res = true;
        }
        this.isSelectAll = res;
    }

    private void updateRowPositions() {
        HashMap<Integer, Object> rows = new HashMap<Integer, Object>();
        for (Object current : this.rowPositionAndAxis.values()) {
            int index = this.manager.getRowElementsList().indexOf(current);
            if (index >= 0) {
                int position = this.selectionLayer.getRowPositionByIndex(index);
                rows.put(position, current);
                continue;
            }
            this.rowAxisElements.remove(AxisUtils.getRepresentedElement(current));
            this.rowAxisElements.remove(current);
        }
        this.rowPositionAndAxis = rows;
    }

    private void updateColumnPositions() {
        HashMap<Integer, Object> columns = new HashMap<Integer, Object>();
        for (Object current : this.columnPositionAndAxis.values()) {
            int index = this.manager.getColumnElementsList().indexOf(current);
            if (index >= 0) {
                int position = this.selectionLayer.getColumnPositionByIndex(index);
                columns.put(position, current);
                continue;
            }
            this.columnAxisElements.remove(AxisUtils.getRepresentedElement(current));
            this.columnAxisElements.remove(current);
        }
        this.columnPositionAndAxis = columns;
    }

    private void updateCellPositions() {
        ArrayList<PositionCoordinate> toRemove = new ArrayList<PositionCoordinate>();
        for (Map.Entry<PositionCoordinate, CellReference> current : this.allSelectedCells.entrySet()) {
            PositionCoordinate pos = current.getKey();
            CellReference ref = current.getValue();
            int columnIndex = this.manager.getColumnElementsList().indexOf(ref.getColumnAxis());
            int rowIndex = this.manager.getRowElementsList().indexOf(ref.getRowAxis());
            if (rowIndex >= 0 && columnIndex >= 0) {
                int columnPosition = this.selectionLayer.getColumnPositionByIndex(columnIndex);
                int rowPosition = this.selectionLayer.getRowPositionByIndex(rowIndex);
                if (columnPosition >= 0 && rowPosition >= 0) {
                    pos.setColumnPosition(columnPosition);
                    pos.setRowPosition(rowPosition);
                    continue;
                }
                toRemove.add(pos);
                continue;
            }
            toRemove.add(pos);
        }
        for (PositionCoordinate removeMe : toRemove) {
            this.singleCellsCoordinatesAndUniqueReference.remove(removeMe);
        }
    }

    @Override
    public Map<Integer, Object> getFullySelectedRows() {
        return this.rowPositionAndAxis;
    }

    @Override
    public Set<PositionCoordinate> getSingleSelectedCells() {
        return this.singleCellsCoordinatesAndUniqueReference.keySet();
    }

    private boolean isSingleSelectedCell(PositionCoordinate cellLocation) {
        return !this.rowPositionAndAxis.containsKey(cellLocation.getRowPosition()) && !this.columnPositionAndAxis.containsKey(cellLocation.getColumnPosition());
    }

    @Override
    public Map<Integer, Object> getFullySelectedColumns() {
        return this.columnPositionAndAxis;
    }

    @Override
    public Collection<Object> getSelectedElements() {
        HashSet<Object> selection = new HashSet<Object>();
        selection.addAll(this.rowAxisElements);
        selection.addAll(this.columnAxisElements);
        selection.addAll(this.singleCellValues);
        return selection;
    }

    @Override
    public Collection<PositionCoordinate> getSelectedCells() {
        return this.allSelectedCells.keySet();
    }

    @Override
    public boolean isCellsOutsideOfAxis() {
        boolean result = false;
        Iterator<PositionCoordinate> selectedCells = this.allSelectedCells.keySet().iterator();
        while (!result && selectedCells.hasNext()) {
            PositionCoordinate selectedCell = selectedCells.next();
            boolean bl = result = !this.rowPositionAndAxis.containsKey(selectedCell.getRowPosition()) && !this.columnPositionAndAxis.containsKey(selectedCell.getColumnPosition());
        }
        return result;
    }

    @Override
    public boolean isContinuousRows() {
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        for (int rowIndex : this.getFullySelectedRows().keySet()) {
            if (-1 == firstRowIndex || rowIndex < firstRowIndex) {
                firstRowIndex = rowIndex;
            }
            if (-1 != lastRowIndex && rowIndex <= lastRowIndex) continue;
            lastRowIndex = rowIndex;
        }
        return lastRowIndex - firstRowIndex + 1 == this.getFullySelectedRows().size();
    }

    @Override
    public boolean isContinuousColumns() {
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        for (int rowIndex : this.getFullySelectedColumns().keySet()) {
            if (-1 == firstColumnIndex || rowIndex < firstColumnIndex) {
                firstColumnIndex = rowIndex;
            }
            if (-1 != lastColumnIndex && rowIndex <= lastColumnIndex) continue;
            lastColumnIndex = rowIndex;
        }
        return lastColumnIndex - firstColumnIndex + 1 == this.getFullySelectedColumns().size();
    }

    @Override
    public boolean isContinuousCells() {
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        for (PositionCoordinate currentPosition : this.getSelectedCells()) {
            if (-1 == firstRowIndex || currentPosition.getRowPosition() < firstRowIndex) {
                firstRowIndex = currentPosition.getRowPosition();
            }
            if (-1 == firstColumnIndex || currentPosition.getColumnPosition() < firstColumnIndex) {
                firstColumnIndex = currentPosition.getColumnPosition();
            }
            if (-1 == lastRowIndex || currentPosition.getRowPosition() > lastRowIndex) {
                lastRowIndex = currentPosition.getRowPosition();
            }
            if (-1 != lastColumnIndex && currentPosition.getColumnPosition() <= lastColumnIndex) continue;
            lastColumnIndex = currentPosition.getColumnPosition();
        }
        return (lastColumnIndex - firstColumnIndex + 1) * (lastRowIndex - firstRowIndex + 1) == this.getSelectedCells().size();
    }

    @Override
    public void clearWrappedSelection() {
        super.clearWrappedSelection();
        this.columnAxisElements.clear();
        this.rowAxisElements.clear();
        this.columnPositionAndAxis.clear();
        this.rowPositionAndAxis.clear();
        this.singleCellsCoordinatesAndUniqueReference.clear();
        this.singleCellValues.clear();
        this.allSelectedCells.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableSelectionWrapper2)) {
            return false;
        }
        TableSelectionWrapper2 wrapper = (TableSelectionWrapper2)o;
        if (wrapper.getNatTableModelManager() != this.manager) {
            return false;
        }
        if (wrapper.isSelectAll() != this.isSelectAll()) {
            return false;
        }
        if (!wrapper.getFullySelectedColumns().equals(this.getFullySelectedColumns())) {
            return false;
        }
        if (!wrapper.getFullySelectedRows().equals(this.getFullySelectedRows())) {
            return false;
        }
        if (!wrapper.getSingleSelectedCells().equals(this.getSingleSelectedCells())) {
            return false;
        }
        return !wrapper.getSelectedCells().equals(this.getSelectedCells());
    }

    @Override
    public INattableModelManager getNatTableModelManager() {
        return this.manager;
    }

    private final class CellReference {
        private Object columnAxis;
        private Object rowAxis;

        public CellReference(Object columnAxis, Object rowAxis) {
            this.columnAxis = columnAxis;
            this.rowAxis = rowAxis;
        }

        public Object getColumnAxis() {
            return this.columnAxis;
        }

        public Object getRowAxis() {
            return this.rowAxis;
        }
    }
}

