/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.validation;

import com.google.common.base.Objects;
import com.google.common.util.concurrent.FutureCallback;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.StereotypeApplicationRepairSnippet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;

public class StereotypeRepairResolutionGenerator
implements IMarkerResolutionGenerator {
    private final Resolution resolution = new Resolution();

    public IMarkerResolution[] getResolutions(IMarker marker) {
        return new IMarkerResolution[]{this.resolution};
    }

    private static class Resolution
    implements IMarkerResolution2 {
        private Resolution() {
        }

        public String getLabel() {
            return "Repair Stereotype Applications";
        }

        public String getDescription() {
            return "Runs Stereotype Application Repair on the entire model, interactively resolving all broken stereotype problems.";
        }

        public Image getImage() {
            return null;
        }

        public void run(final IMarker marker) {
            StereotypeApplicationRepairSnippet repair;
            ModelSet modelSet;
            IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window == null ? null : window.getActivePage();
            ModelSet modelSet2 = modelSet = page == null ? null : this.getModelSet(page, marker.getResource());
            if (modelSet != null && (repair = StereotypeApplicationRepairSnippet.getInstance(modelSet)) != null) {
                repair.repairAsync(modelSet, new FutureCallback<IStatus>(){

                    public void onSuccess(IStatus result) {
                        try {
                            this.deleteMarkers(modelSet, marker.getType(), marker.getAttribute("source"));
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                        }
                    }

                    public void onFailure(Throwable t) {
                    }
                });
            }
        }

        ModelSet getModelSet(IWorkbenchPage page, IResource resource) {
            ModelSet result = null;
            if (resource instanceof IFile) {
                FileEditorInput input = new FileEditorInput((IFile)resource);
                IEditorReference[] refs = page.findEditors((IEditorInput)input, null, 1);
                int i = 0;
                while (result == null && i < refs.length) {
                    ServicesRegistry registry = (ServicesRegistry)AdapterUtils.adapt((Object)refs[i].getEditor(true), ServicesRegistry.class, null);
                    if (registry != null) {
                        try {
                            result = ServiceUtils.getInstance().getModelSet((Object)registry);
                        }
                        catch (ServiceException serviceException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            return result;
        }

        void deleteMarkers(ModelSet modelSet, final String markerType, final Object source) throws CoreException {
            for (Resource resource : modelSet.getResources()) {
                final IFile file = ResourceUtils.getFile((Resource)resource);
                if (file == null) continue;
                file.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IMarker[] markers;
                        IMarker[] iMarkerArray = markers = file.findMarkers(markerType, false, 0);
                        int n = markers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarker next = iMarkerArray[n2];
                            if (Objects.equal((Object)next.getAttribute("source"), (Object)source)) {
                                next.delete();
                            }
                            ++n2;
                        }
                    }
                }, (ISchedulingRule)file, 1, null);
            }
        }
    }
}

