/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.sdk.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public final class WorkbenchUtils {
    private WorkbenchUtils() {
    }

    public static void openNewFile(IFile modelFile, IWorkbench currentWorkbench, IWorkbenchWindow workbenchWindow, IWorkbenchPage page) {
        try {
            page.openEditor((IEditorInput)new FileEditorInput(modelFile), currentWorkbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Open Editor", (String)exception.getMessage());
        }
    }

    public static IWorkbenchPage selectNewFile(IFile modelFile, IWorkbenchWindow workbenchWindow) {
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
            workbenchWindow.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        return page;
    }
}

