/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.creation;

import java.util.concurrent.Callable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.papyrus.infra.widgets.Activator;

public interface IAtomicOperationExecutor {
    public static final IAtomicOperationExecutor DEFAULT = new Default();

    public void execute(Runnable var1, String var2);

    public <V> V execute(Callable<V> var1, String var2);

    public static class Default
    implements IAtomicOperationExecutor {
        @Override
        public void execute(Runnable operation, String label) {
            try {
                operation.run();
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
        }

        @Override
        public <V> V execute(Callable<V> operation, String label) {
            class CallableWrapper
            implements Runnable {
                V result;
                private final /* synthetic */ Callable val$operation;

                CallableWrapper(Callable callable) {
                    this.val$operation = callable;
                }

                @Override
                public void run() {
                    try {
                        this.result = this.val$operation.call();
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Activator.log.error("Callable operation failed.", (Throwable)e);
                        throw new OperationCanceledException();
                    }
                }
            }
            CallableWrapper wrapper = new CallableWrapper(operation);
            this.execute(wrapper, label);
            return wrapper.result;
        }
    }
}

