/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.ui.properties.widgets;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.types.ui.properties.messages.Messages;
import org.eclipse.papyrus.infra.emf.types.ui.properties.providers.ViewContentProvider;
import org.eclipse.papyrus.infra.emf.types.ui.properties.providers.ViewLabelProvider;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.ReferenceDialog;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ViewToDisplayValueEditor
extends ReferenceDialog {
    private static final String BROWSE_ICON = "/icons/browse_12x12.gif";
    private static final int DEFAULT_HEIGHT_HINT = 55;
    private static final int DEFAULT_WIDTH_HINT = 100;
    private Button button = null;

    public ViewToDisplayValueEditor(Composite parent, int style) {
        super(parent, style);
        ++((GridLayout)this.getLayout()).numColumns;
        this.button = factory.createButton((Composite)this, null, 8);
        this.button.setImage(Activator.getDefault().getImage(BROWSE_ICON));
        this.button.setToolTipText(Messages.ViewToDisplayValueEditor_browserButtonTooltip);
        this.button.setEnabled(!this.readOnly);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewToDisplayValueEditor.this.handleManageBrowseButtonPressed();
            }
        });
        this.setLabelProvider((ILabelProvider)new ViewLabelProvider());
    }

    protected GridData getDefaultLayoutData() {
        GridData data = super.getDefaultLayoutData();
        data.minimumHeight = 55;
        data.minimumWidth = 100;
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    public void updateControls() {
        this.setExclusion((Control)this.editInstanceButton, true);
        this.setExclusion((Control)this.createInstanceButton, true);
        this.setExclusion((Control)this.browseValuesButton, true);
        this.setExclusion((Control)this.unsetButton, this.mandatory);
        if (!this.mandatory) {
            boolean enabled = !this.readOnly;
            enabled = enabled && this.getValue() != null;
            this.unsetButton.setEnabled(enabled);
        }
    }

    public void updateLabel() {
    }

    protected void handleManageBrowseButtonPressed() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getParent().getShell());
        dialog.setContentProvider((ITreeContentProvider)new ViewContentProvider());
        dialog.setLabelProvider((ILabelProvider)new ViewLabelProvider());
        dialog.setTitle(Messages.ViewToDisplayValueEditor_dialogTitle);
        dialog.setMessage(Messages.ViewToDisplayValueEditor_dialogMessage);
        if (dialog.open() == 0) {
            Object[] values = dialog.getResult();
            if (1 != values.length) {
                this.error = true;
            } else if (values[0] instanceof View) {
                this.setValue((View)values[0]);
            } else {
                this.error = true;
            }
            this.updateStatus(null);
            this.pack();
            this.layout();
        }
    }

    protected void editAction() {
        this.handleManageBrowseButtonPressed();
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.button.setEnabled(!readOnly);
    }
}

