/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.types.handlers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.dev.types.Activator;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.IConfiguredHintedElementType;
import org.eclipse.ui.handlers.HandlerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MigrateSpecializations
extends AbstractHandler {
    final String FILE_EXTENSION = "elementtypesconfigurations";
    final String TYPE_ATTRIBUTE = "xsi:type";
    final String NAME_ATTRIBUTE = "name";
    final String IDENTIFIER_ATTRIBUTE = "identifier";
    final String ELEMENTTYPECONFIGURATION_NAMESPACE_ATTRIBUTE = "xmlns:elementtypesconfigurations";
    final String ELEMENTTYPECONFIGURATION_NAMESPACE_OLD = "http://www.eclipse.org/papyrus/infra/elementtypesconfigurations/1.1";
    final String ELEMENTTYPECONFIGURATION_NAMESPACE_NEW = "http://www.eclipse.org/papyrus/infra/elementtypesconfigurations/1.2";
    final String ELEMENTTYPECONFIGURATIONS = "elementTypeConfigurations";
    final String ELEMENTTYPESCONFIGURATIONS_SPECIALIZATIONTYPECONFIGURATION = "elementtypesconfigurations:SpecializationTypeConfiguration";
    final String SPECIALIZEDTYPESID_ATTRIBUTE = "specializedTypesID";
    final String SPECIALIZEDTYPES_ATTRIBUTE = "specializedTypes";
    final String HREF_ATTRIBUTE = "href";
    final String ELEMENTTYPESCONFIGURATIONS_METAMODELTYPECONFIGURATION = "elementtypesconfigurations:MetamodelTypeConfiguration";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Element elementTypeConfiguration;
        NodeList elementTypeConfigurations;
        Element root;
        Document doc;
        DocumentBuilder builder;
        DocumentBuilderFactory factory;
        File file;
        URI uri;
        IFile selectedFile;
        HashMap<String, String> mapSpecializationMigration = new HashMap<String, String>();
        HashMap<String, String> mapMetamodelMigration = new HashMap<String, String>();
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(currentSelection instanceof IStructuredSelection) || currentSelection.isEmpty()) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        for (Object selectedElement : selection) {
            if (!(selectedElement instanceof IFile) || !"elementtypesconfigurations".equals(((IFile)selectedElement).getFileExtension())) continue;
            selectedFile = (IFile)selectedElement;
            uri = selectedFile.getLocationURI();
            if (selectedFile.isLinked()) {
                uri = selectedFile.getRawLocationURI();
            }
            try {
                file = EFS.getStore((URI)uri).toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                factory = DocumentBuilderFactory.newInstance();
                builder = factory.newDocumentBuilder();
                doc = builder.parse(file);
                root = doc.getDocumentElement();
                elementTypeConfigurations = root.getElementsByTagName("elementTypeConfigurations");
                int i = 0;
                while (i < elementTypeConfigurations.getLength()) {
                    elementTypeConfiguration = (Element)elementTypeConfigurations.item(i);
                    Node identifierAttrib = elementTypeConfiguration.getAttributes().getNamedItem("identifier");
                    Node xmiid = elementTypeConfiguration.getAttributes().getNamedItem("xmi:id");
                    Node type = elementTypeConfiguration.getAttributes().getNamedItem("xsi:type");
                    if (type.getNodeValue().equals("elementtypesconfigurations:SpecializationTypeConfiguration")) {
                        mapSpecializationMigration.put(identifierAttrib.getNodeValue(), "platform:/plugin" + selectedFile.getFullPath().toString() + "#" + xmiid.getNodeValue());
                    } else {
                        mapMetamodelMigration.put(identifierAttrib.getNodeValue(), "platform:/plugin" + selectedFile.getFullPath().toString() + "#" + xmiid.getNodeValue());
                    }
                    ++i;
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        for (Object selectedElement : selection) {
            if (!(selectedElement instanceof IFile) || !"elementtypesconfigurations".equals(((IFile)selectedElement).getFileExtension())) continue;
            selectedFile = (IFile)selectedElement;
            uri = selectedFile.getLocationURI();
            if (selectedFile.isLinked()) {
                uri = selectedFile.getRawLocationURI();
            }
            try {
                file = EFS.getStore((URI)uri).toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                factory = DocumentBuilderFactory.newInstance();
                builder = factory.newDocumentBuilder();
                doc = builder.parse(file);
                root = doc.getDocumentElement();
                root.setAttribute("xmlns:elementtypesconfigurations", "http://www.eclipse.org/papyrus/infra/elementtypesconfigurations/1.2");
                elementTypeConfigurations = root.getElementsByTagName("elementTypeConfigurations");
                int i = 0;
                while (i < elementTypeConfigurations.getLength()) {
                    elementTypeConfiguration = (Element)elementTypeConfigurations.item(i);
                    NodeList children = elementTypeConfiguration.getChildNodes();
                    ArrayList<String> specializedIDs = new ArrayList<String>();
                    ArrayList<Node> childToRemove = new ArrayList<Node>();
                    int j = 0;
                    while (j < children.getLength()) {
                        Node child = children.item(j);
                        if (child instanceof Element && child.getNodeName().equals("specializedTypesID")) {
                            String specialized = ((Element)child).getFirstChild().getNodeValue();
                            specializedIDs.add(specialized);
                            childToRemove.add(child);
                        }
                        ++j;
                    }
                    for (Node node : childToRemove) {
                        elementTypeConfiguration.removeChild(node);
                    }
                    for (String specialized : specializedIDs) {
                        Element specializedTypes = doc.createElement("specializedTypes");
                        if (mapMetamodelMigration.containsKey(specialized)) {
                            specializedTypes.setAttribute("xsi:type", "elementtypesconfigurations:MetamodelTypeConfiguration");
                            specializedTypes.setAttribute("href", (String)mapMetamodelMigration.get(specialized));
                            elementTypeConfiguration.appendChild(specializedTypes);
                            continue;
                        }
                        if (mapSpecializationMigration.containsKey(specialized)) {
                            specializedTypes.setAttribute("xsi:type", "elementtypesconfigurations:SpecializationTypeConfiguration");
                            specializedTypes.setAttribute("href", (String)mapSpecializationMigration.get(specialized));
                            elementTypeConfiguration.appendChild(specializedTypes);
                            continue;
                        }
                        IElementType elementType = ElementTypeRegistry.getInstance().getType(specialized);
                        if (elementType instanceof IConfiguredHintedElementType) {
                            ElementTypeConfiguration etc = ((IConfiguredHintedElementType)elementType).getConfiguration();
                            if (etc == null) continue;
                            specializedTypes.setAttribute("xsi:type", "elementtypesconfigurations:SpecializationTypeConfiguration");
                            specializedTypes.setAttribute("href", String.valueOf(etc.eResource().getURI().toString()) + "#" + etc.eResource().getURIFragment((EObject)etc));
                            elementTypeConfiguration.appendChild(specializedTypes);
                            continue;
                        }
                        Activator.log.debug("Couldn't find : " + specialized);
                    }
                    ++i;
                }
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                StreamResult output = new StreamResult(file);
                DOMSource input = new DOMSource(doc);
                transformer.transform(input, output);
                selectedFile.touch((IProgressMonitor)new NullProgressMonitor());
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerFactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

