/**
 * Copyright (c) 2010, 2021 CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Yann Tanguy (CEA LIST) - initial API and implementation
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package utils;

import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class EditPartsUtils_qvto {
  public boolean hasSpecificLocator(final GenExternalNodeLabel it) {
    String _locatorClassName = it.getLocatorClassName();
    return (_locatorClassName != null);
  }
  
  public String getSpecificLocator(final GenExternalNodeLabel it) {
    return it.getLocatorClassName();
  }
  
  public List<GenExternalNodeLabel> getExternalLabelsWithoutSpecificLocator(final GenNode it) {
    final Function1<GenExternalNodeLabel, Boolean> _function = new Function1<GenExternalNodeLabel, Boolean>() {
      @Override
      public Boolean apply(final GenExternalNodeLabel l) {
        boolean _hasSpecificLocator = EditPartsUtils_qvto.this.hasSpecificLocator(l);
        return Boolean.valueOf((!_hasSpecificLocator));
      }
    };
    return IterableExtensions.<GenExternalNodeLabel>toList(IterableExtensions.<GenExternalNodeLabel>filter(Iterables.<GenExternalNodeLabel>filter(it.getLabels(), GenExternalNodeLabel.class), _function));
  }
  
  public List<GenExternalNodeLabel> getExternalLabelsWithSpecificLocator(final GenNode it) {
    final Function1<GenExternalNodeLabel, Boolean> _function = new Function1<GenExternalNodeLabel, Boolean>() {
      @Override
      public Boolean apply(final GenExternalNodeLabel l) {
        return Boolean.valueOf(EditPartsUtils_qvto.this.hasSpecificLocator(l));
      }
    };
    return IterableExtensions.<GenExternalNodeLabel>toList(IterableExtensions.<GenExternalNodeLabel>filter(Iterables.<GenExternalNodeLabel>filter(it.getLabels(), GenExternalNodeLabel.class), _function));
  }
}
