/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.utils;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EMFUtil {
    public static boolean isReadOnly(EObject eObject) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
        return EMFUtil.isReadOnly(eObject, domain);
    }

    public static boolean isReadOnly(EObject eObject, EditingDomain domain) {
        return EMFUtil.isReadOnly(eObject.eResource(), domain);
    }

    public static boolean isReadOnly(Resource resource, EditingDomain domain) {
        if (domain instanceof AdapterFactoryEditingDomain) {
            return ((AdapterFactoryEditingDomain)domain).isReadOnly(resource);
        }
        if (resource == null) {
            return false;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return false;
        }
        Map attributes = resourceSet.getURIConverter().getAttributes(resource.getURI(), null);
        Boolean readOnly = (Boolean)attributes.get("readOnly");
        return readOnly == null ? false : readOnly;
    }
}

