/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.dnd.preferences;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.papyrus.infra.gmfdiag.dnd.policy.DropStrategyManager;
import org.eclipse.papyrus.infra.gmfdiag.dnd.preferences.DropStrategyLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.DropStrategy;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DropStrategyEditor
extends MultipleReferenceEditor {
    public static final int ACTIVATION_COLUMN = 0;
    public static final int LABEL_COLUMN = 1;
    private final Map<DropStrategy, Button> checkboxes;

    public DropStrategyEditor(Composite parent, int style) {
        super(parent, style, true, true, "Strategies");
        List<DropStrategy> values = DropStrategyManager.instance.getAllStrategies();
        StaticContentProvider provider = new StaticContentProvider(values.toArray());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        this.setProviders((IStaticContentProvider)provider, (ILabelProvider)new DropStrategyLabelProvider());
        this.setModelObservable((IObservableList)new DropStrategyObservableList(values));
        TableLayout layout = new TableLayout();
        new TreeColumn(this.tree, 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 25, false));
        new TreeColumn(this.tree, 16384);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 250, true));
        this.tree.setLayout((Layout)layout);
        this.tree.setHeaderVisible(false);
        this.setToolTipText("Strategies");
        this.treeViewer.refresh();
        this.checkboxes = new HashMap<DropStrategy, Button>();
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof DropStrategy) {
                TreeEditor editor = new TreeEditor(this.tree);
                final Button button = new Button((Composite)this.tree, 32);
                TreeItem currentItem = item;
                final DropStrategy strategy = (DropStrategy)currentItem.getData();
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        DropStrategyEditor.this.updateStrategy(strategy, button);
                        DropStrategyEditor.this.treeViewer.refresh();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.checkboxes.put(strategy, button);
                button.setSelection(DropStrategyManager.instance.isActive(strategy));
                editor.setEditor((Control)button, item, 0);
                editor.horizontalAlignment = 0x1000000;
                editor.grabHorizontal = true;
            }
            ++n2;
        }
        this.tree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ISelection selection;
                if (e.keyCode == 32 && (selection = DropStrategyEditor.this.treeViewer.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Activation isActive = DropStrategyEditor.this.findIsActive(structuredSelection);
                    if (isActive != Activation.UNDEFINED) {
                        for (Object element : structuredSelection) {
                            if (!(element instanceof DropStrategy)) continue;
                            DropStrategy strategy = (DropStrategy)element;
                            Button button = DropStrategyEditor.this.checkboxes.get(strategy);
                            if (isActive != Activation.TRUE) {
                                DropStrategyEditor.this.updateStrategy(strategy, button, true);
                                continue;
                            }
                            DropStrategyEditor.this.updateStrategy(strategy, button, false);
                        }
                    }
                    DropStrategyEditor.this.treeViewer.refresh();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private Activation findIsActive(IStructuredSelection selection) {
        for (Object element : selection) {
            if (!(element instanceof DropStrategy)) continue;
            boolean isActive = DropStrategyManager.instance.isActive((DropStrategy)element);
            if (isActive) {
                return Activation.FALSE;
            }
            return Activation.TRUE;
        }
        return Activation.UNDEFINED;
    }

    private void updateStrategy(DropStrategy strategy, Button button, boolean isActive) {
        DropStrategyManager.instance.setActive(strategy, isActive);
        button.setSelection(isActive);
    }

    private void updateStrategy(DropStrategy strategy, Button button) {
        boolean isActive = DropStrategyManager.instance.isActive(strategy);
        this.updateStrategy(strategy, button, !isActive);
    }

    public void createListControls() {
        super.createListControls();
        this.edit.dispose();
        this.remove.dispose();
        this.add.dispose();
        this.up.dispose();
        this.down.dispose();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DropStrategyEditor.this.updateControls();
            }
        });
    }

    protected Object[] getSelectedElements() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        return selection.toArray();
    }

    public void widgetSelected(SelectionEvent event) {
        super.widgetSelected(event);
    }

    protected void toggleAction(boolean activate) {
        Object[] selectedElements;
        Object[] objectArray = selectedElements = this.getSelectedElements();
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            if (selected instanceof DropStrategy) {
                DropStrategyManager.instance.setActive((DropStrategy)selected, activate);
            }
            ++n2;
        }
        this.treeViewer.refresh();
    }

    protected void updateControls() {
    }

    public void refresh() {
        for (Map.Entry<DropStrategy, Button> entry : this.checkboxes.entrySet()) {
            boolean isActive = DropStrategyManager.instance.isActive(entry.getKey());
            this.updateStrategy(entry.getKey(), entry.getValue(), isActive);
        }
        this.treeViewer.refresh();
    }

    private static enum Activation {
        TRUE,
        FALSE,
        UNDEFINED;

    }

    private class DropStrategyObservableList
    extends WritableList {
        public DropStrategyObservableList(List<DropStrategy> values) {
            this.addAll(values);
        }

        public Object move(int oldIndex, int newIndex) {
            Object objectToMove = this.get(oldIndex);
            Object other = this.get(newIndex);
            if (objectToMove instanceof DropStrategy && other instanceof DropStrategy) {
                DropStrategy strategyToMove = (DropStrategy)objectToMove;
                DropStrategy otherStrategy = (DropStrategy)other;
                int priority = DropStrategyManager.instance.findPriority(otherStrategy);
                int newPriority = newIndex > oldIndex ? priority + 1 : priority - 1;
                DropStrategyManager.instance.setPriority(strategyToMove, newPriority);
            }
            return super.move(oldIndex, newIndex);
        }
    }
}

