/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class MultipleValueSelectorWidget
implements ISelectionChangedListener,
IDoubleClickListener,
IElementSelectionListener,
SelectionListener {
    public static int MANY = -1;
    protected Composite contentArea;
    protected IElementSelector selector;
    protected Composite selectorSection;
    protected Composite buttonsSection;
    protected Composite rightButtonsSection;
    protected StructuredViewer selectedElementsViewer;
    protected Tree selectedElements;
    protected Button add;
    protected Button create;
    protected Button delete;
    protected Button remove;
    protected Button addAll;
    protected Button removeAll;
    protected Button up;
    protected Button down;
    protected ILabelProvider labelProvider;
    protected final Collection<Object> allElements;
    private List initialSelections = new ArrayList();
    protected boolean unique;
    protected boolean ordered;
    protected ReferenceValueFactory factory;
    protected Object contextElement;
    protected Set<Object> newObjects = new HashSet<Object>();
    protected int upperBound;
    private Object[] result;

    public MultipleValueSelectorWidget(Composite parentShell, IElementSelector selector) {
        this(parentShell, selector, null, false, false);
    }

    public MultipleValueSelectorWidget(Composite parentShell, IElementSelector selector, String title) {
        this(parentShell, selector, title, false, false);
    }

    public MultipleValueSelectorWidget(Composite parentShell, IElementSelector selector, boolean unique) {
        this(parentShell, selector, null, unique, false);
    }

    public MultipleValueSelectorWidget(Composite parentShell, IElementSelector selector, String title, boolean unique, boolean ordered) {
        this(parentShell, selector, title, unique, false, MANY);
    }

    public MultipleValueSelectorWidget(Composite parent, IElementSelector selector, String title, boolean unique, boolean ordered, int upperBound) {
        Assert.isNotNull((Object)selector, (String)"The element selector should be defined");
        this.selector = selector;
        this.allElements = unique ? new LinkedHashSet() : new LinkedList();
        this.unique = unique;
        this.ordered = ordered;
        this.upperBound = upperBound;
        selector.addElementSelectionListener((IElementSelectionListener)this);
        this.createContent(parent);
        this.updateControls();
        this.hookControl();
    }

    protected void createContent(Composite parent) {
        this.contentArea = this.createContentArea(parent);
        this.createDialogContents();
    }

    protected Composite createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected void createDialogContents() {
        Composite parent = this.contentArea;
        Composite selectorPane = new Composite(parent, 0);
        selectorPane.setLayout((Layout)new GridLayout(2, false));
        selectorPane.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite selectedPane = new Composite(parent, 0);
        selectedPane.setLayout((Layout)new GridLayout(2, false));
        selectedPane.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSelectorSection(selectorPane);
        this.createControlsSection(selectorPane);
        this.createListSection(selectedPane);
        this.createRightButtonsSection(selectedPane);
    }

    private void createSelectorSection(Composite parent) {
        this.selectorSection = new Composite(parent, 0);
        this.selectorSection.setLayout((Layout)new FillLayout());
        this.selectorSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selector.createControls(this.selectorSection);
    }

    private void createControlsSection(Composite parent) {
        this.buttonsSection = new Composite(parent, 0);
        this.buttonsSection.setLayout((Layout)new GridLayout(1, true));
        this.add = new Button(this.buttonsSection, 8);
        this.add.setImage(Activator.getDefault().getImage("/icons/arrow_right.gif"));
        this.add.addSelectionListener((SelectionListener)this);
        this.add.setToolTipText(Messages.MultipleValueSelectorDialog_AddSelectedElements);
        this.remove = new Button(this.buttonsSection, 8);
        this.remove.setImage(Activator.getDefault().getImage("/icons/arrow_left.gif"));
        this.remove.addSelectionListener((SelectionListener)this);
        this.remove.setToolTipText(Messages.MultipleValueEditor_RemoveSelectedElements);
        this.addAll = new Button(this.buttonsSection, 8);
        this.addAll.setImage(Activator.getDefault().getImage("/icons/arrow_double.gif"));
        this.addAll.addSelectionListener((SelectionListener)this);
        this.addAll.setToolTipText(Messages.MultipleValueSelectorDialog_AddAllElements);
        if (this.upperBound != MANY && this.allElements.size() > this.upperBound) {
            this.addAll.setEnabled(false);
        }
        this.removeAll = new Button(this.buttonsSection, 8);
        this.removeAll.setImage(Activator.getDefault().getImage("/icons/arrow_left_double.gif"));
        this.removeAll.addSelectionListener((SelectionListener)this);
        this.removeAll.setToolTipText(Messages.MultipleValueSelectorDialog_RemoveAllElements);
    }

    private void createListSection(Composite parent) {
        this.selectedElements = new Tree(parent, 2818);
        GridData data = new GridData(4, 4, true, true);
        this.selectedElements.setLayoutData((Object)data);
        this.selectedElementsViewer = new TreeViewer(this.selectedElements);
        this.selectedElementsViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.selectedElementsViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.selectedElementsViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        if (this.labelProvider != null) {
            this.selectedElementsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.selectedElementsViewer.setInput(this.allElements);
        this.selector.setSelectedElements(this.allElements.toArray());
    }

    private void createRightButtonsSection(Composite parent) {
        this.rightButtonsSection = new Composite(parent, 0);
        this.rightButtonsSection.setLayout((Layout)new GridLayout(1, true));
        this.up = new Button(this.rightButtonsSection, 8);
        this.up.setImage(Activator.getDefault().getImage("/icons/Up_12x12.gif"));
        this.up.addSelectionListener((SelectionListener)this);
        this.up.setToolTipText(Messages.MultipleValueEditor_MoveSelectedElementsUp);
        this.down = new Button(this.rightButtonsSection, 8);
        this.down.setImage(Activator.getDefault().getImage("/icons/Down_12x12.gif"));
        this.down.addSelectionListener((SelectionListener)this);
        this.down.setToolTipText(Messages.MultipleValueEditor_MoveSelectedElementsDown);
        this.create = new Button(this.rightButtonsSection, 8);
        this.create.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.create.addSelectionListener((SelectionListener)this);
        this.create.setToolTipText(Messages.MultipleValueSelectorDialog_CreateNewElement);
        this.delete = new Button(this.rightButtonsSection, 8);
        this.delete.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.delete.addSelectionListener((SelectionListener)this);
        this.delete.setToolTipText(Messages.MultipleValueSelectorDialog_DeleteNewElement);
        this.delete.setEnabled(false);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        if (this.selectedElementsViewer != null) {
            this.selectedElementsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.add) {
            this.addAction();
        } else if (e.widget == this.remove) {
            this.removeAction();
        } else if (e.widget == this.addAll) {
            this.addAllAction();
        } else if (e.widget == this.removeAll) {
            this.removeAllAction();
        } else if (e.widget == this.up) {
            this.upAction();
        } else if (e.widget == this.down) {
            this.downAction();
        } else if (e.widget == this.create) {
            this.createAction();
        }
        this.updateControls();
    }

    public void setFactory(ReferenceValueFactory factory) {
        this.factory = factory;
        this.updateControls();
    }

    protected void initAllElements() {
        this.allElements.clear();
        this.allElements.addAll(this.getInitialElementSelections());
    }

    protected void addAction() {
        Object[] elements = this.selector.getSelectedElements();
        this.addElements(elements);
    }

    protected void upAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        LinkedList<Object> list = new LinkedList<Object>(this.allElements);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            int oldIndex = list.indexOf(o);
            if (oldIndex > 0) {
                this.move(list, oldIndex, oldIndex - 1);
            }
            ++n2;
        }
        this.allElements.clear();
        this.allElements.addAll(list);
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.selectedElementsViewer.setSelection((ISelection)selectionCopy);
        this.selectedElementsViewer.refresh();
    }

    protected void downAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        LinkedList<Object> list = new LinkedList<Object>(this.allElements);
        int maxIndex = list.size() - 1;
        Object[] selectionArray = selection.toArray();
        int i = selectionArray.length - 1;
        while (i >= 0) {
            Object o = selectionArray[i];
            int oldIndex = list.indexOf(o);
            if (oldIndex < maxIndex) {
                this.move(list, oldIndex, oldIndex + 1);
            }
            --i;
        }
        this.allElements.clear();
        this.allElements.addAll(list);
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.selectedElementsViewer.setSelection((ISelection)selectionCopy);
        this.selectedElementsViewer.refresh();
    }

    protected void createAction() {
        Object newObject;
        if (this.factory == null) {
            return;
        }
        try {
            newObject = this.factory.createObject((Control)this.create, this.contextElement);
        }
        catch (OperationCanceledException e) {
            newObject = null;
        }
        if (newObject == null) {
            return;
        }
        this.newObjects.add(newObject);
        this.selector.newObjectCreated(newObject);
        Object[] createdObjects = new Object[]{newObject};
        this.addElements(createdObjects);
        this.selector.setSelectedElements(this.allElements.toArray());
    }

    private void move(List<Object> list, int oldIndex, int newIndex) {
        int size = list.size();
        if (oldIndex < 0 || oldIndex >= size) {
            throw new IndexOutOfBoundsException("oldIndex: " + oldIndex + ", size:" + size);
        }
        if (newIndex < 0 || newIndex >= size) {
            throw new IndexOutOfBoundsException("newIndex: " + newIndex + ", size:" + size);
        }
        Object element = list.remove(oldIndex);
        list.add(newIndex, element);
    }

    protected void removeAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.allElements.remove(element);
            ++n2;
        }
        this.selector.setSelectedElements(this.allElements.toArray());
        this.selectedElementsViewer.setSelection(null);
        this.selectedElementsViewer.refresh();
    }

    protected void deleteAction() {
    }

    protected void removeAllAction() {
        this.allElements.clear();
        this.selector.setSelectedElements(new Object[0]);
        this.selectedElementsViewer.setSelection(null);
        this.selectedElementsViewer.refresh();
    }

    protected void addAllAction() {
        Object[] elements = this.selector.getAllElements();
        this.addElements(elements);
    }

    public void addElements(Object[] elements) {
        if (elements != null) {
            this.allElements.addAll(Arrays.asList(elements));
            this.selectedElementsViewer.refresh();
        }
    }

    protected void prepareResult() {
        if (this.factory != null) {
            LinkedList<Object> objectsToValidate = new LinkedList<Object>();
            for (Object object : this.newObjects) {
                if (!this.allElements.contains(object)) continue;
                objectsToValidate.add(object);
            }
            this.factory.validateObjects(objectsToValidate);
            this.selector.clearTemporaryElements();
        }
        this.setResult(new LinkedList<Object>(this.allElements));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
        this.updateControls();
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
        this.updateControls();
    }

    private void updateControls() {
        this.updateControl((Control)this.up, this.ordered);
        this.updateControl((Control)this.down, this.ordered);
        this.updateControl((Control)this.create, this.factory != null && this.factory.canCreateObject());
        boolean canAdd = true;
        if (this.upperBound != MANY && this.allElements.size() >= this.upperBound) {
            canAdd = false;
        }
        this.updateControl((Control)this.add, canAdd);
    }

    private void updateControl(Control control, boolean enabled) {
        if (control != null) {
            control.setEnabled(enabled);
        }
    }

    public void setSelector(IElementSelector selector) {
        this.selector = selector;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public void setContextElement(Object contextElement) {
        this.contextElement = contextElement;
    }

    public Object getContextElement() {
        return this.contextElement;
    }

    protected void hookControl() {
        if ((this.contentArea.getStyle() & 0x10000000) != 0) {
            this.contentArea.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MultipleValueSelectorWidget.this.dispose();
                }
            });
        }
    }

    public void dispose() {
        this.selector.removeElementSelectionListener((IElementSelectionListener)this);
    }

    public void doubleClick(DoubleClickEvent event) {
        this.removeAction();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateControls();
    }

    protected List getInitialElementSelections() {
        return this.initialSelections;
    }

    public void setInitialSelections(Object[] selectedElements) {
        this.initialSelections = new ArrayList(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            this.initialSelections.add(selectedElements[i]);
            ++i;
        }
        this.initAllElements();
        this.refreshSourceAndTargetTrees();
    }

    public void setInitialElementSelections(List selectedElements) {
        this.initialSelections = selectedElements;
        this.initAllElements();
        this.refreshSourceAndTargetTrees();
    }

    private void refreshSourceAndTargetTrees() {
        this.selectedElementsViewer.refresh();
        this.selector.setSelectedElements(this.allElements.toArray());
    }

    public Object[] getResult() {
        this.prepareResult();
        return this.result;
    }

    protected void setResult(List newResult) {
        if (newResult == null) {
            this.result = null;
        } else {
            this.result = new Object[newResult.size()];
            newResult.toArray(this.result);
        }
    }

    protected void setSelectionResult(Object[] newResult) {
        this.result = newResult;
    }
}

