/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.providers;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class DiagramElementTypeImages {
    private AdapterFactory myAdapterFactory;
    private ImageRegistry myImageRegistry;

    public DiagramElementTypeImages(AdapterFactory adapterFactory) {
        this(adapterFactory, null);
    }

    public DiagramElementTypeImages(AdapterFactory adapterFactory, ImageRegistry imageRegistry) {
        this.myAdapterFactory = adapterFactory;
        this.myImageRegistry = imageRegistry;
    }

    public ImageRegistry getImageRegistry() {
        if (this.myImageRegistry == null) {
            this.myImageRegistry = new ImageRegistry(DisplayUtils.getDisplay());
        }
        return this.myImageRegistry;
    }

    public String getImageRegistryKey(ENamedElement element) {
        return element.getName();
    }

    public Image getImage(ENamedElement element) {
        if (element == null) {
            return null;
        }
        this.getImageDescriptor(element);
        String key = this.getImageRegistryKey(element);
        return this.getImageRegistry().get(key);
    }

    public ImageDescriptor getImageDescriptor(ENamedElement element) {
        if (element == null) {
            return null;
        }
        String key = this.getImageRegistryKey(element);
        ImageDescriptor imageDescriptor = this.getImageRegistry().getDescriptor(key);
        if (imageDescriptor == null) {
            imageDescriptor = this.getProvidedImageDescriptor(element);
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            this.getImageRegistry().put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public ImageDescriptor getProvidedImageDescriptor(ENamedElement element) {
        EClass eClass;
        if (element instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)element;
            EClass eContainingClass = this.findNotAbstractEClassOrSubClass((EClassifier)feature.getEContainingClass());
            EClass eType = this.findNotAbstractEClassOrSubClass(feature.getEType());
            if (eContainingClass != null && !eContainingClass.isAbstract()) {
                element = eContainingClass;
            } else if (eType != null && !eType.isAbstract()) {
                element = eType;
            }
        }
        if (element instanceof EClass && !(eClass = (EClass)element).isAbstract()) {
            EObject instance = eClass.getEPackage().getEFactoryInstance().create(eClass);
            return this.getItemImageDescriptor(instance);
        }
        return null;
    }

    public ImageDescriptor getItemImageDescriptor(EObject item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.myAdapterFactory.adapt((Notifier)item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)item));
        }
        return null;
    }

    public ImageDescriptor getReferenceImageDescritor(EStructuralFeature feature) {
        EObject child;
        EObject containerInstance = this.instantiate((EClassifier)feature.getEContainingClass());
        if (containerInstance == null) {
            return null;
        }
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.myAdapterFactory.adapt((Notifier)containerInstance, IItemLabelProvider.class);
        if (!(labelProvider instanceof CreateChildCommand.Helper)) {
            return null;
        }
        CreateChildCommand.Helper helper = (CreateChildCommand.Helper)labelProvider;
        Object imageUrl = helper.getCreateChildImage((Object)containerInstance, (Object)feature, null, null);
        if (imageUrl == null && (child = this.instantiate(feature.getEType())) != null) {
            imageUrl = helper.getCreateChildImage((Object)containerInstance, (Object)feature, (Object)child, null);
        }
        if (imageUrl == null) {
            return null;
        }
        return ExtendedImageRegistry.getInstance().getImageDescriptor(imageUrl);
    }

    protected EObject instantiate(EClassifier classifier) {
        if (!(classifier instanceof EClass)) {
            return null;
        }
        EClass instantiatable = this.findNotAbstractEClassOrSubClass((EClassifier)((EClass)classifier));
        return instantiatable == null ? null : instantiatable.getEPackage().getEFactoryInstance().create(instantiatable);
    }

    protected EClass findNotAbstractEClassOrSubClass(EClassifier classifier) {
        if (!(classifier instanceof EClass)) {
            return null;
        }
        EClass eClass = (EClass)classifier;
        if (!eClass.isAbstract()) {
            return eClass;
        }
        for (EClassifier nextFromSameEPackage : eClass.getEPackage().getEClassifiers()) {
            EClass nextEClass;
            if (!(nextFromSameEPackage instanceof EClass) || (nextEClass = (EClass)nextFromSameEPackage).isAbstract() || !eClass.isSuperTypeOf(nextEClass)) continue;
            return nextEClass;
        }
        return null;
    }
}

