/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.language;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.language.ILanguage;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;

public class LanguageModelRegistry {
    private static final String EXT_POINT = "language";
    public static final LanguageModelRegistry INSTANCE = new LanguageModelRegistry();
    private final Map<String, String> modelBindings = new HashMap<String, String>();

    private LanguageModelRegistry() {
        new MyRegistryReader().readRegistry();
    }

    public String getModelID(String languageID) {
        return this.modelBindings.get(languageID);
    }

    public String getModelID(ILanguage language) {
        return this.getModelID(language.getID());
    }

    public IModel getModel(ILanguage language, ModelSet modelSet) {
        String modelID = this.getModelID(language);
        return modelID == null ? null : modelSet.getModel(modelID);
    }

    public void bind(String languageID, String modelID) {
        String current = this.modelBindings.putIfAbsent(languageID, modelID);
        if (current != null) {
            Activator.log.warn(NLS.bind((String)"Language {0} is already bound to model {1}; ignoring model {2}", (Object[])new Object[]{languageID, current, modelID}));
        }
    }

    public void unbind(String languageID, String modelID) {
        if (!this.modelBindings.remove(languageID, modelID)) {
            Activator.log.warn(NLS.bind((String)"Attempt to unbind model {0} from language {1} to which it is not bound", (Object)modelID, (Object)languageID));
        }
    }

    private class MyRegistryReader
    extends RegistryReader {
        private static final String E_MODEL_BINDING = "modelBinding";
        private static final String A_LANGUAGE = "language";
        private static final String A_MODEL = "model";

        MyRegistryReader() {
            super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.infra.core", "language");
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            return add ? this.handleAdd(element) : this.handleRemove(element);
        }

        private boolean handleAdd(IConfigurationElement element) {
            boolean result = true;
            if (E_MODEL_BINDING.equals(element.getName())) {
                String languageID = element.getAttribute("language");
                String modelID = element.getAttribute(A_MODEL);
                if (Strings.isNullOrEmpty((String)languageID)) {
                    this.logMissingAttribute(element, "language");
                } else if (Strings.isNullOrEmpty((String)modelID)) {
                    this.logMissingAttribute(element, A_MODEL);
                } else {
                    LanguageModelRegistry.this.bind(languageID, modelID);
                }
            }
            return result;
        }

        private boolean handleRemove(IConfigurationElement element) {
            boolean result = true;
            if (E_MODEL_BINDING.equals(element.getName())) {
                String languageID = element.getAttribute("language");
                String modelID = element.getAttribute(A_MODEL);
                if (!Strings.isNullOrEmpty((String)languageID) && !Strings.isNullOrEmpty((String)modelID)) {
                    LanguageModelRegistry.this.unbind(languageID, modelID);
                }
            }
            return result;
        }
    }
}

